/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iarray.h"
#include "ifamily.h"


template<class O, class C>
iFamily<O,C>* iFamily<O,C>::New(C *m)
{
	return new iFamily<O,C>(m);
}


template<class O, class C>
iFamily<O,C>::iFamily(C *m) : mMemlist(0)
{
	this->mModule = m;
	this->mCur = 0;

	O* tmp;
	tmp = O::New(this->mModule); IERROR_ASSERT_NULL_POINTER(tmp);
	this->mMemlist.Add(tmp);
}


template<class O, class C>
iFamily<O,C>::~iFamily()
{
	int i;
	//
	//  Delete members in reverse order in case they create static instances of reference-counted variables
	//
    for(i=this->mMemlist.Last(); i>=0; i--) this->mMemlist[i]->Delete(); 
}


template<class O, class C>
int iFamily<O,C>::CreateMember()
{
	O* tmp = O::New(this->mModule); if(tmp == 0) return -1;
	this->mMemlist.Add(tmp);
	return this->mMemlist.Last();

}


template<class O, class C>
bool iFamily<O,C>::DeleteMember(int i)
{
	if(i>=0 && i<this->mMemlist.Size() && this->mMemlist.Size()>1)
	{
		this->mMemlist.Remove(i)->Delete();
		if(this->mCur>=i && i>0) this->mCur--;
		return true;
    }
	else return false;
}

