/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  Abstract DataSubject for reading various particle files
//
#ifndef IGENERICPARTICLESDATASUBJECT_H
#define IGENERICPARTICLESDATASUBJECT_H


#include "idatasubject.h"


#include <vtkMath.h>

class iGenericParticlesDataHelper;

class vtkPolyData;


class iGenericParticlesDataSubject : public iDataSubject
{

public:

//	static const iObjectType& Type();

	void SetDownsampleMode(int v);
	inline int GetDownsampleMode() const { return mDownsampleMode; }

	void SetDownsampleFactor(int v);
	inline int GetDownsampleFactor() const { return mDownsampleFactor; }

protected:

	iGenericParticlesDataSubject(iDataReader *r, const iDataType &type);
	virtual ~iGenericParticlesDataSubject();

	//
	//  helper functions
	//
	void FinalizePolyData(vtkPolyData *data);
	void ShiftPolyData(vtkPolyData *data, int d, double dx);

	vtkIdType PrepareMask(vtkIdType ntot, int downsampleFactor, vtkIdType offm = 0, vtkIdType offt = 0);
	bool IsMasked(vtkIdType idm, vtkIdType idt);

	bool mHaveNormals;
	int mDownsampleMode, mDownsampleFactor;

	iGenericParticlesDataHelper *mHelper;

	//
	//  Helper variables for masking
	//
	struct Mask
	{
		vtkIdType NumTotal;
		vtkIdType NumMasked;
		vtkIdType NumUnmasked;
		vtkIdType OffsetTotal;
		vtkIdType OffsetMasked;
		int DownsampleFactor;
		float RandomThreshold;
	};

	Mask wMask;
};


//
//  Inlined for efficiency
//
inline bool iGenericParticlesDataSubject::IsMasked(vtkIdType idm, vtkIdType idt)
{
	idt -= wMask.OffsetTotal;
	idm -= wMask.OffsetMasked;

	if(wMask.DownsampleFactor==1 || idt>=idm+wMask.NumUnmasked) return true;
	if(idm >= wMask.NumMasked) return false;

	switch(mDownsampleMode)
	{
	case 0:
		{
			return (idt%wMask.DownsampleFactor == 0);
		}
	case 1:
		{
			return (vtkMath::Random() < wMask.RandomThreshold);
		}
	case 2:
		{
			return true;
		}
	case 3:
		{
			return false;
		}
	}

	return false;
}

#endif

