/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IMEASURINGBOX_H
#define IMEASURINGBOX_H


#include "iactor.h"
#include "iviewmodulecomponent.h"


#include <vtkProperty.h>


class iColor;
class iTextActor;

class vtkCubeSource;
class vtkPolyDataMapper;


class iMeasuringBox : public iActor, protected iViewModuleComponent
{
	
public:
	
	static iMeasuringBox* New(iViewModule *vm);
	
	virtual void ReleaseGraphicsResources(vtkWindow *win);

	virtual int RenderOverlay(vtkViewport*);
	virtual int RenderOpaqueGeometry(vtkViewport*);
	virtual int RenderTranslucentGeometry(vtkViewport *);

	virtual void SetSize(float s){ if(s > 0.0){ mSize = s; this->Modified(); } }
	virtual void SetOpacity(float s);
	virtual void SetColor(iColor &c);
	virtual void SetBaseScale(float s);

	inline float GetOpacity(){ return this->GetProperty()->GetOpacity(); }
	inline float GetSize(){ return mSize; }
	
	virtual iTextActor *GetTextActor(){ return mText; }

	virtual double *GetBounds(){ return 0; }  // Set to zero so that the text is always displayed
	virtual float GetLength();

protected:
	
	iMeasuringBox(iViewModule *vm);
	virtual ~iMeasuringBox();
	
private:

	vtkCubeSource *mCube;
	iActor *mFrame;

	iTextActor *mText;

	bool mStarted;
	float mSize, mBaseScale;
	float mFactor1r, mFactor1g, mFactor1b, mFactor2;

};

#endif // IMEASURINGBOX_H
