/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "ioverlaybase.h"


#include "ivtk.h"
#include "imagnifier.h"
#include "imath.h"
#include "irendertool.h"

#include <vtkCamera.h>


iOverlayBase::iOverlayBase(const iRenderTool *rv) : mRenderTool(rv)
{
}


iOverlayBase::~iOverlayBase()
{
}


int iOverlayBase::GetRenderingMagnification() const
{
	return mRenderTool->GetRenderingMagnification();
}


void iOverlayBase::ComputePositionShiftsUnderMagnification(vtkCamera *cam, int winij[2], vtkViewport* /*viewport*/)
{
	int mag = mRenderTool->GetRenderingMagnification();
	//
	//  Compute position shifts if under magnification
	//
	if(cam!=0 && mag>1)
	{
		mRenderTool->GetMagnifier()->GetTile(winij[0],winij[1]);
	}
	else winij[0] = winij[1] = 0;
}

