/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iparticlegroupserialpipeline.h"


#include "ierror.h"
#include "ieventobserver.h"
#include "ifunctionmapping.h"
#include "iparticledataconverter.h"
#include "iparticlegroup.h"
#include "ipiecewisefunction.h"
#include "ireplicatedpolydata.h"
#include "iviewmodule.h"
#include "iviewobjectreplicator.h"

#include <vtkPolyData.h>

//
//  Templates
//
#include "igenericfiltertemplate.h"


//
// iParticleGroupSerialPipeline class
//
iParticleGroupSerialPipeline::iParticleGroupSerialPipeline(iParticleGroup *s) : iPolyDataToPolyDataPipeline(1,s)
{
	mParent = s;

//
//  Do VTK stuff
//	
	mDataConverter = iParticleDataConverter::New(mParent); IERROR_ASSERT_NULL_POINTER(mDataConverter);
	mDataReplicated = iReplicatedPolyData::New(mParent->GetReplicator()); IERROR_ASSERT_NULL_POINTER(mDataReplicated);

	mDataReplicated->SetInput(mDataConverter->GetOutput());

	this->UpdateAll();
	mDataConverter->SetInput(0);
}


iParticleGroupSerialPipeline::~iParticleGroupSerialPipeline()
{
	mDataConverter->Delete();
	mDataReplicated->Delete();
}


void iParticleGroupSerialPipeline::AttachObservers(bool master)
{
	iEventObserver *obsAbortRender;
	
	if(master)
	{
		obsAbortRender = mParent->GetViewModule()->GetAbortRenderEventObserver();
	}
	else
	{
		obsAbortRender = mParent->GetViewModule()->GetSlaveAbortRenderEventObserver();
	}

	mDataConverter->AddObserver(vtkCommand::ProgressEvent,obsAbortRender);
	mDataReplicated->AddObserver(vtkCommand::ProgressEvent,obsAbortRender);
}


void iParticleGroupSerialPipeline::ProduceOutput(vtkPolyData *input, vtkPolyData *output)
{
	if(mDataConverter->GetInput() != input)
	{
		mDataConverter->SetInput(input);
	}
	
	//
	//  Update the pipeline
	//
	mDataReplicated->Update();
	output->ShallowCopy(mDataReplicated->GetOutput());
}


float iParticleGroupSerialPipeline::GetMemorySize() const
{
	float s = 0.0;
	s += mDataConverter->GetMemorySize();
	s += mDataReplicated->GetMemorySize();
	return s;
}


iPolyDataToPolyDataPipeline* iParticleGroupSerialPipeline::Copy() const
{
	iParticleGroupSerialPipeline *tmp = mParent->CreateSerialPipeline();	
	if(tmp == 0) return 0;

	//
	//  Update the pipeline
	//
	tmp->UpdateAll();

	return tmp;
}


void iParticleGroupSerialPipeline::UpdateAll()
{
	this->UpdateAttToSize();
	this->UpdateType();
	this->UpdateFixedSize();
	this->UpdateReplicas();
}


void iParticleGroupSerialPipeline::UpdateAttToSize()
{ 
	mDataConverter->Modified();
	this->Modified();
}


void iParticleGroupSerialPipeline::UpdateType()
{ 
	mDataConverter->SetType(mParent->GetType());
	this->Modified();
}


void iParticleGroupSerialPipeline::UpdateFixedSize()
{ 
	mDataConverter->SetSize(mParent->GetFixedSize());
	this->Modified();
}


void iParticleGroupSerialPipeline::UpdateReplicas()
{
	mDataReplicated->Modified();
	this->Modified();
}


void iParticleGroupSerialPipeline::UpdateSizeFunction()
{
	mDataConverter->Modified();
	this->Modified();
}
