/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


//
//	A replacement for vtkStreamLineFilter which is VERY SLOW and takes all of the memory
//

#ifndef ISTREAMLINEFILTER_H
#define ISTREAMLINEFILTER_H


#include "igenericfilter.h"
#include "iviewobjectcomponent.h"


class iDataLimits;

class vtkImageData;
class vtkPoints;


class iStreamLineFilter : public iAbstractPolyDataToPolyDataFilter, protected iViewObjectComponent
{

public:

	// Description:
	// Construct object to extract all of the input data.
	static iStreamLineFilter* New(iViewObject *);

	void SetGridData(vtkImageData *s);
	vtkImageData* GetGridData() const { return mGridData; }

	void SetLength(float d);
	void SetComputeVorticity(bool d);
	void SetComputeDivergence(bool d);
	void SetMinimumSpeed(float v);
	void SetDirection(int d);
	void SetSplitLines(bool s);
	void SetQuality(int q);

	inline float GetLength() const { return mLength; }
	inline bool GetComputeVorticity() const { return mComputeVort; }
	inline bool GetComputeDivergence() const { return mComputeDiv; }
	inline float GetMinimumSpeed() const { return mVmin; }
	inline int GetDirection() const { return mDir; }
	inline bool GetSplitLines() const { return mSplitLines; }
	inline int GetQuality() const { return mQuality; }

	virtual float GetMemorySize();

	static vtkIdType GetVector(double x[3], float v[3], float *ptrdata, int dims[3], double origin[3], double spacing[3], const iDataLimits *limits, float *vort = 0, float *div = 0);

protected:
	
	iStreamLineFilter(iViewObject *vo);
	virtual ~iStreamLineFilter();
	
	virtual void SyncWithData(int info, void *data);

	virtual vtkIdType GetVector(double x[3], float v[3], float *vort = 0, float *div = 0);
	virtual int FollowLine(double x[3], double &d, float &h, float eps, vtkIdType l);
	
	virtual bool DefinePointers();
	virtual void AssignScalars(float *p, vtkIdType l);
	virtual void GetDmin(vtkIdType l, float &ddmin, float &dx);

	virtual void ProduceOutput(vtkPolyData *input, vtkPolyData *output);

	float mVmin, mDmin, mEps;
	float mLength;
	bool mComputeVort, mComputeDiv;
	int mDir, mQuality, mItMax, mAxisDir;
	bool mSplitLines;

	vtkImageData *mGridData;
	//
	//  Work variables
	//
	const iDataLimits *wLimits;
	int wDims[3], wNsca;
	float *wPtrVec, *wPtrSca;
	double wOrg[3], wSpa[3];
};

#endif  // ISTREAMLINEFILTER_H


