/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "isurfaceparallelpipeline.h"


#include "idatadistributor.h"
#include "ierror.h"
#include "ifamily.h"
#include "iserialpipeline.h"
#include "isurfaceserialpipeline.h"
#include "isurfaceviewobject.h"

#include <vtkPolyData.h>
#include <vtkStructuredPoints.h>

//
//  Templates
//
#include "iarraytemplate.h"
#include "igenericfiltertemplate.h"
#include "iparallelpipelinetemplate.h"

//
//  Macros
//
#include "iparallelpipelinemacro.h"


//
// iSurfaceParallelPipeline class
//
iSurfaceParallelPipeline::iSurfaceParallelPipeline(iSurfaceViewObject *s) : iParallelGridDataToPolyDataPipeline(1,s)
{
	mParent = s;
}


iSurfaceParallelPipeline::~iSurfaceParallelPipeline()
{
}


IPARALLELPIPELINE_DEFINE_UPDATE_FUNCTION(iSurface,GridDataToPolyData,Method);
IPARALLELPIPELINE_DEFINE_UPDATE_FUNCTION(iSurface,GridDataToPolyData,IsoSurfacePipeline);
IPARALLELPIPELINE_DEFINE_UPDATE_FUNCTION(iSurface,GridDataToPolyData,IsoSurfaceVar);
IPARALLELPIPELINE_DEFINE_UPDATE_FUNCTION(iSurface,GridDataToPolyData,IsoSurfaceLevel);
IPARALLELPIPELINE_DEFINE_UPDATE_FUNCTION(iSurface,GridDataToPolyData,NormalsFlipped);
IPARALLELPIPELINE_DEFINE_UPDATE_FUNCTION(iSurface,GridDataToPolyData,Replicas);
IPARALLELPIPELINE_DEFINE_UPDATE_FUNCTION(iSurface,GridDataToPolyData,ProbeSize);
IPARALLELPIPELINE_DEFINE_UPDATE_FUNCTION(iSurface,GridDataToPolyData,ProbePosition);
IPARALLELPIPELINE_DEFINE_UPDATE_FUNCTION(iSurface,GridDataToPolyData,PlaneDirection);


void iSurfaceParallelPipeline::UpdateVarPaint(int s)
{ 
	int i;
	for(i=0; i<mWorkPipelines.Size(); i++) 
	{
		iPointerCast<iSurfaceSerialPipeline,iGridDataToPolyDataPipeline>(mWorkPipelines[i])->UpdateVarPaint(s);
	}
	this->Modified();
}


iGridDataToPolyDataPipeline* iSurfaceParallelPipeline::CreateSerialPipeline()
{
	return mParent->CreateSerialPipeline();
}

