/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef ITENSORFIELDSERIALPIPELINE_H
#define ITENSORFIELDSERIALPIPELINE_H


#include "iserialpipeline.h"


class iReplicatedPolyData;
class iTensorGlyphFilter;
class iTensorFieldViewObject;

class vtkExtractVOI;
class vtkSphereSource;


class iTensorFieldSerialPipeline : public iGridDataToPolyDataPipeline
{

	friend class iTensorFieldViewObject;

public:
	
	virtual iGridDataToPolyDataPipeline* Copy() const;
	virtual void AttachObservers(bool master);
	virtual float GetMemorySize() const;

	//
	//  Pipeline operation
	//
	virtual void UpdateSize();
	virtual void UpdateScalingOn();
	virtual void UpdateSampleRate();
	virtual void UpdateReplicas();

	virtual void ComputeSpacing();

protected:
	
	iTensorFieldSerialPipeline(iTensorFieldViewObject *s);
	virtual ~iTensorFieldSerialPipeline();

	virtual void ProduceOutput(vtkImageData *input, vtkPolyData *output);

	virtual void SyncWithData(int info, void *data);

	void UpdateAll();

	iTensorFieldViewObject *mParent;
	double mCurSpacing;

	//
	//  VTK stuff
	//
	vtkExtractVOI *mFilter;
	vtkSphereSource *mGlyphSphere;

	iTensorGlyphFilter *mGlyph;
	iReplicatedPolyData *mDataReplicated;
};

#endif // ITENSORFIELDSERIALPIPELINE_H

