/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "itensorfieldviewobject.h"

#include "idata.h"
#include "idatareader.h"
#include "ierror.h"
#include "iextensionfactory.h"
//#include "igriddataconverter.h"
#include "ireplicatedactor.h"
#include "itensorfieldparallelpipeline.h"
#include "itensorfieldserialpipeline.h"
#include "iviewmodule.h"

#include <vtkPolyData.h>
#include <vtkStructuredPoints.h>

//
//  Templates (needed for some compilers)
//
#include "iarraytemplate.h"


using namespace iParameter;


IVIEWOBJECT_DEFINE_TYPE(iTensorFieldViewObject,Tensor,t);

IOBJECT_DEFINE_KEY(iTensorFieldViewObject,Method,m,Int,1);
IOBJECT_DEFINE_KEY(iTensorFieldViewObject,ScalingOn,so,Bool,1);

//
//  Inherited keys
//
IVIEWOBJECT_DEFINE_INHERITED_KEYS_COMMON(iTensorFieldViewObject);
IVIEWOBJECT_DEFINE_INHERITED_KEYS_REPLICATING(iTensorFieldViewObject);
IVIEWOBJECT_DEFINE_INHERITED_KEYS_COLOR(iTensorFieldViewObject,1);
IVIEWOBJECT_DEFINE_INHERITED_KEYS_OPACITY(iTensorFieldViewObject,1);
IVIEWOBJECT_DEFINE_INHERITED_KEYS_PALETTE(iTensorFieldViewObject,1);
IVIEWOBJECT_DEFINE_INHERITED_KEYS_FIELD(iTensorFieldViewObject);


//
// iTensorFieldViewObject class
//
iTensorFieldViewObject* iTensorFieldViewObject::New(iViewModule *vm)
{
	iTensorFieldViewObject *tmp =  iPointerCast<iTensorFieldViewObject,iObject>(iExtensionFactory::CreateObject(Type(),vm));
	IERROR_ASSERT_NULL_POINTER(tmp);
	//
	//  Create pipeline (must be created after the object is fully created)
	//	
	tmp->mPipeline = tmp->CreateParallelPipeline(); IERROR_ASSERT_NULL_POINTER(tmp->mPipeline);
	tmp->mActors[0]->SetInput(tmp->mPipeline->GetOutput());

	tmp->Reset();

	return tmp;
}


iTensorFieldViewObject::iTensorFieldViewObject(iViewModule *vm, const iDataInfo &info) : iFieldViewObject(vm,info,1,2U,_ViewObjectAlwaysShaded)
{
	mName = "iTensorFieldViewObject";
	mObjectType = _ObjectTypeTensorField;

	this->AddSecondaryDataType(iDataType::UniformScalars());

	if(mPrimaryDataInfo->Index(iDataType::UniformTensors()) == -1)
	{
		IERROR_REPORT_FATAL_ERROR("iTensorFieldViewObject is configured incorrectly.");
	}

	mMethod = 0;
	mScalingOn = true;
}


iTensorFieldViewObject::~iTensorFieldViewObject()
{
	mPipeline->Delete();
}


void iTensorFieldViewObject::FinishInitialization()
{
}


iTensorFieldParallelPipeline* iTensorFieldViewObject::CreateParallelPipeline()
{
	iTensorFieldParallelPipeline *tmp = new iTensorFieldParallelPipeline(this); IERROR_ASSERT_NULL_POINTER(tmp);
	tmp->FinishInitialization();
	return tmp;
}


iTensorFieldSerialPipeline* iTensorFieldViewObject::CreateSerialPipeline()
{
	return new iTensorFieldSerialPipeline(this);
}


void iTensorFieldViewObject::ResetPipelineInput(vtkImageData *input)
{
	mPipeline->SetInput(input);
}


void iTensorFieldViewObject::ResetPipeline()
{
}


void iTensorFieldViewObject::SetScalingOn(bool s)
{
	if(s != mScalingOn)
	{
		mScalingOn = s;
		mPipeline->UpdateScalingOn();
		this->ClearCache();
	}
}


void iTensorFieldViewObject::UpdateGlyphSize()
{ 
	mPipeline->UpdateSize();
}


void iTensorFieldViewObject::UpdateGlyphSampleRate()
{ 
	mPipeline->UpdateSampleRate();
}


void iTensorFieldViewObject::ShowBody(bool show)
{
	if(show)
	{
		mActors[0]->VisibilityOn();
		this->ShowColorBars(true);
	} 
	else 
	{
		this->ShowColorBars(false);
		mActors[0]->VisibilityOff();
	}
}


float iTensorFieldViewObject::GetMemorySize() const
{
	return mPipeline->GetOutput()->GetActualMemorySize();
}


//
//  Two functions used in saving/restoring the state and in creating new instances with
//
void iTensorFieldViewObject::FieldViewObjectPackStateBody(iString &s) const
{
	this->PackValue(s,KeyMethod(),mMethod);
	this->PackValue(s,KeyScalingOn(),mScalingOn);
}


void iTensorFieldViewObject::FieldViewObjectUnPackStateBody(const iString &s)
{
	bool b;

//	if(this->UnPackValue(s,KeyMethod(),i)) this->SetMethod(i);
	if(this->UnPackValue(s,KeyScalingOn(),b)) this->SetScalingOn(b);
}


int iTensorFieldViewObject::GetDataOffset() const
{
	return 0;
}


void iTensorFieldViewObject::FieldViewObjectSyncWithData(int info, void *)
{
}

