/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//**********************************************************************
//
//  Superclass for displaying text in VTK
//
//**********************************************************************


#ifndef ITEXT_H
#define ITEXT_H


#include <vtkProp.h>
#include "ioverlaybase.h"


#include "icolor.h"
#include "iparameter.h"
#include "istring.h"

class vtkViewport;


class iText: public vtkProp, protected iOverlayBase
{
	
public:

	virtual int RenderOverlay(vtkViewport *v) = 0;
	virtual int RenderOpaqueGeometry(vtkViewport *v) = 0;
	virtual int RenderTranslucentGeometry(vtkViewport *){ return 0; }
	virtual void ReleaseGraphicsResources(vtkWindow *w);
	
	virtual void SetColor(iColor &c){ mColor = c; }
	virtual void SetFontSize(int s){ if(s>0 && s<99) mFontSize = s; }
	virtual void SetBold(bool s){ mBold = s; }
	virtual void SetHJustification(int s){ if(s>=0 && s<iParameter::__NumTextJusts) mHorJust = s; }
	virtual void SetVJustification(int s){ if(s>=0 && s<iParameter::__NumTextJusts) mVerJust = s; }
	virtual void SetPosition(float p[2]){ mPos[0] = p[0]; mPos[1] = p[1]; }
	virtual void SetPosition(float p0, float p1){ mPos[0] = p0; mPos[1] = p1; }
	virtual void Rotate(float a){ mAngle = a; }

	inline int GetFontSize() const { return mFontSize; }
	inline bool GetBold() const { return mBold; }
	inline const float* GetPosition() const { return mPos; }
	inline const float* GetSize() const { return mSize; }

	virtual void GetSize(vtkViewport *v, float s[2]) = 0;

	virtual void SetText(const iString &s);

protected:
	
	iText(const iRenderTool *rv);
	virtual ~iText();

	void SetActorPosition(vtkViewport *viewport);

	int mFontSize;
	bool mBold;
	int mHorJust, mVerJust;
	float mPos[2], mActorPos[2];
	float mAngle;
	iColor mColor;
	float mSize[2];
	iString mText;
};

#endif // ITEXT_H
