/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "ivectorfieldstreamlineparallelpipeline.h"


#include "idatadistributor.h"
#include "ierror.h"
#include "ifamily.h"
#include "iserialpipeline.h"
#include "ivectorfieldstreamlineserialpipeline.h"
#include "ivectorfieldviewobject.h"

#include <vtkPolyData.h>
#include <vtkStructuredPoints.h>

//
//  Templates
//
#include "iarraytemplate.h"
#include "igenericfiltertemplate.h"
#include "iparallelpipelinetemplate.h"

//
//  Macros
//
#include "iparallelpipelinemacro.h"


//
// iVectorFieldStreamLineParallelPipeline class
//
iVectorFieldStreamLineParallelPipeline::iVectorFieldStreamLineParallelPipeline(iVectorFieldViewObject *s) : iParallelPolyDataToPolyDataPipeline(2,s)
{
	mParent = s;
}


iVectorFieldStreamLineParallelPipeline::~iVectorFieldStreamLineParallelPipeline()
{
}


void iVectorFieldStreamLineParallelPipeline::SetGridInput(vtkImageData *input)
{
	this->SetNthInput(1,input);
	this->Modified();
}


IPARALLELPIPELINE_DEFINE_UPDATE_FUNCTION(iVectorFieldStreamLine,PolyDataToPolyData,Pipeline);
IPARALLELPIPELINE_DEFINE_UPDATE_FUNCTION(iVectorFieldStreamLine,PolyDataToPolyData,Direction);
IPARALLELPIPELINE_DEFINE_UPDATE_FUNCTION(iVectorFieldStreamLine,PolyDataToPolyData,Length);
IPARALLELPIPELINE_DEFINE_UPDATE_FUNCTION(iVectorFieldStreamLine,PolyDataToPolyData,Quality);
IPARALLELPIPELINE_DEFINE_UPDATE_FUNCTION(iVectorFieldStreamLine,PolyDataToPolyData,TubeSize);
IPARALLELPIPELINE_DEFINE_UPDATE_FUNCTION(iVectorFieldStreamLine,PolyDataToPolyData,TubeRangeFactor);
IPARALLELPIPELINE_DEFINE_UPDATE_FUNCTION(iVectorFieldStreamLine,PolyDataToPolyData,TubeVariationFactor);
IPARALLELPIPELINE_DEFINE_UPDATE_FUNCTION(iVectorFieldStreamLine,PolyDataToPolyData,Replicas);


iPolyDataToPolyDataPipeline* iVectorFieldStreamLineParallelPipeline::CreateSerialPipeline()
{
	return mParent->CreateStreamLineSerialPipeline();
}


