/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  This class provides all functionality for writing images and animations
//
#ifndef IWRITER_H
#define IWRITER_H


#include "iviewmodulecomponent.h"
#include "ideletable.h"


#include "istring.h"

class iGenericMultiImageMovieWriter;
class iStereoImageArray;

class vtkImageWriter;


class iWriter : public iViewModuleComponent, public iDeletable
{
	
public:

	static iWriter* New(iViewModule *cm);

	//
	//  Writing functionality
	//
	void Start();
	void WriteFrame(const iStereoImageArray& images, int mode);
	void Finish();

	void SetImageFormat(int);
	inline int GetImageFormat() const { return mImageFormat; }

	void SetAnimationOutput(int); // only has effect under VTK5
	inline int GetAnimationOutput() const { return mAnimationOutput; }

	void SetPostScriptPaperFormat(int);
	inline int GetPostScriptPaperFormat() const { return mPostScriptPaperFormat; }

	void SetPostScriptOrientation(int);
	inline int GetPostScriptOrientation() const { return mPostScriptOrientation; }

	inline void ResetAnimationImageIndex(int v = 1){ if(v > 0) mCurrentAnimationImageIndex = v; }
	inline int GetCurrentAnimationImageIndex() const { return mCurrentAnimationImageIndex; }

protected:
	
	iWriter(iViewModule *vm);
	virtual ~iWriter();

	void WriteImageFrame(const iStereoImageArray& images, const iString &path, const iString &root);
	void WriteMovieFrame(const iStereoImageArray& images, const iString &path, const iString &root);

	//
	//  Members
	//
	static int mCurrentSnapshotImageIndex, mCurrentAnimationImageIndex;
	static iString mCurrentSnapshotImageFilePrefix, mCurrentAnimationImageFilePrefix;
	
	int mImageFormat, mAnimationOutput;
	int mPostScriptPaperFormat, mPostScriptOrientation;

	//
	//  VTK classes
	//
	iGenericMultiImageMovieWriter *mMovieWriter;  // for stereo movies
	vtkImageWriter *mImageWriter;
};

#endif // IWRITER_H

