/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#define curAnimator				curScript->GetAnimator()
#define curVisual				curScript->GetAnimator()->GetViewModule()
#define curControl				curScript->GetAnimator()->GetViewModule()->GetControlModule()
#define curReader				curScript->GetAnimator()->GetViewModule()->GetReader()
#define curRenderer				curScript->GetAnimator()->GetViewModule()->GetRenderer()
#define curCamera				curScript->GetAnimator()->GetViewModule()->GetRenderer()->GetActiveCamera()
#define curLimits(t)			curScript->GetAnimator()->GetViewModule()->GetReader()->GetLimits(t)
#define curObject(name)			curScript->GetAnimator()->GetViewModule()->Get##name##ViewSubject()
#define indObject(name,n)		curScript->GetAnimator()->GetViewModule()->Get##name##ViewSubject(n)
#define curObjectFamily(name)	curScript->GetAnimator()->GetViewModule()->GetViewObjectFamily(_ObjectType##name)


#define VECTOR_HELPER_ASSERT(_dim_) \
	if(index<-1 || (index>=_dim_ && index!=iMath::_LargeInt)) \
	{ \
		self->GetErrorStatus()->Set("Index is out of bounds."); \
		return false; \
	} \
	if(index==-1 && num!=_dim_) \
	{ \
		self->GetErrorStatus()->Set("Input array has incorrect dimension."); \
		return false; \
	} \
	if(index>-1 && num!=1) \
	{ \
		self->GetErrorStatus()->Set("A component of an array must be a scalar."); \
		return false; \
	}

#define VECTOR_HELPER_ASSIGN(_dim_,_type_) \
		if(index == -1) \
		{ \
			int i; \
			for(i=0; i<_dim_; i++) p[i] = iScriptKit::Variable<_type_>::Combine(p[i],value[i],at); \
		} \
		else \
		{ \
			p[index] = iScriptKit::Variable<_type_>::Combine(p[index],value[0],at); \
		} 


#define DEFINE_WORKER_REL(_class_,_method_,_type_) \
bool _class_##Set##_method_(iScript *self, short at, _type_ value) \
{ \
	_type_ next = iScriptKit::Variable<_type_>::Combine(cur##_class_->Get##_method_(),value,at); \
	cur##_class_->Set##_method_(next); \
	return true; \
}


#define DEFINE_WORKER_ABS(_class_,_method_,_type_) \
bool _class_##_method_(iScript *self, short, _type_ value) \
{ \
	cur##_class_->_method_(value); \
	return true; \
}


#define DEFINE_WORKER_ABSPTR(_class_,_method_,_type_) \
bool _class_##_method_(iScript *self, short, _type_ value) \
{ \
	cur##_class_->_method_(&value); \
	return true; \
}


#define DEFINE_WORKER_ABS_FILE(_class_,_method_,_error_) \
bool _class_##_method_(iScript *self, const iString& value) \
{ \
	if(cur##_class_->_method_(value)) return true; else \
	{ \
		self->GetErrorStatus()->Set(_error_); \
		return false; \
	} \
}


#define DEFINE_WORKER_LIMIT(_name_,_limit_) \
bool _class_##_method_(iScript *self, short at, int num, float *value, int index) \
{ \
	iDataLimits *lim = curLimits(_name_##DataSubject::DataType()); \
	if(lim!=0 && index>=0 && index<lim->GetNumVars()) \
	{ \
		float next = iScriptKit::Variable<float>::Combine(lim->Get##_method_(index),value,at); \
		lim->Set##_method_(index,next); \
		return true; \
	} \
	else \
	{ \
		self->GetErrorStatus()->Set("Invalid index."); \
		return false; \
	} \
}


#define DEFINE_WORKER_SHOW(_class_) \
bool _class_##Show(iScript *self, short, bool value) \
{ \
	curObjectFamily(_class_)->Show(value); \
	return true; \
}


#define DEFINE_WORKER_SUBJECT_BEGIN(_class_,_method_,_type_,_rel_) \
bool _class_##_method_(iScript *self, short at, int num, const _type_ *value, int index) \
{ \
	VECTOR_HELPER_ASSERT((curObjectFamily(_class_)->GetMaxMemberIndex()+1)); \
	i##_class_##ViewSubject *sub; \
	if(index == iMath::_LargeInt) index = curObjectFamily(_class_)->GetCurrentMemberIndex(); \
	_type_ val; int i, ib = (index == -1) ? 0 : index, ie = (index == -1) ? curObjectFamily(_class_)->GetMaxMemberIndex() : index; \
	for(i=ib; i<=ie; i++) \
	{ \
		sub = indObject(_class_,i); if(sub == 0) { self->GetErrorStatus()->Set("Incorrect View Object id."); return false; } \
		if(_rel_) val = iScriptKit::Variable<_type_>::Combine(sub->Get##_method_(),value[(ib<ie)?i:0],at); else val = value[(ib<ie)?i:0]

#define DEFINE_WORKER_SUBJECT_END \
	} \
	return true; \
}

