/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IFAMILY_H
#define IFAMILY_H


#include "iarray.h"


class iView;

template<class Object, class Parent>
class iFamily
{

public:

	static iFamily<Object,Parent>* New(Parent *p);
	virtual void Delete(){ delete this; }

	inline int GetMaxMemberIndex() const { return this->mMemlist.MaxIndex(); }
	inline int GetCurrentMemberIndex() const { return this->mCur; }
    Object* GetCurrentMember() const { return this->mMemlist[this->mCur]; }
    Object* GetMember(int i) const { return this->mMemlist[i]; }
    void SetCurrentMemberIndex(int i) { if(i>=0 && i<this->mMemlist.Size()) this->mCur = i; }
	virtual int CreateMember();
	virtual bool DeleteMember(int i);

protected:

//	iFamily();
	iFamily(Parent *p);
	virtual ~iFamily();

	int mCur;
	Parent *mParent;
	iArray<Object*> mMemlist; 
};

#endif // IFAMILY_H
