/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IVECTORFIELDVIEWSUBJECT_H
#define IVECTORFIELDVIEWSUBJECT_H


#include "ifieldviewsubject.h"


#include "iposition.h"

class iBoundedDiskSource;
class iBoundedPlaneSource;
class iBoundedSphereSource;
class iMarker;

class vtkCellArray;
class vtkFloatArray;
class vtkPoints;


class iVectorFieldViewSubject : public iFieldViewSubject
{
	
	friend class iAbstractExtension;
	friend class iObjectFactory;

public:
	
	vtkTypeMacro(iVectorFieldViewSubject,iFieldViewSubject);
	static const iObjectType& Type();
		
	IOBJECT_DECLARE_GETSET1(Method,int);
//	virtual void SetMethod(int m);
//	inline int GetMethod() const { return mMethod; }

	IOBJECT_DECLARE_GETSET(LineQuality,mLineQuality,int);
//	virtual void SetLineQuality(int q);
//	inline int GetLineQuality() const { return mLineQuality; }

	IOBJECT_DECLARE_GETSET1(LineLength,float);
//	virtual void SetLineLength(float q);
//	inline float GetLineLength() const { return mLineLength; }

	IOBJECT_DECLARE_GETSET1(LineDir,int);
//	virtual void SetLineDir(int n);
//	inline int GetLineDir() const { return mLineDir; }
	
	IOBJECT_DECLARE_GETSET1(TubeSize,int);
//	virtual void SetTubeSize(int t);
//	inline int GetTubeSize() const { return mTubeSize; }

	IOBJECT_DECLARE_GETSET1(TubeRangeFactor,float);
//	virtual void SetTubeRangeFactor(float q);
//	inline float GetTubeRangeFactor() const { return mTubeRangeFactor; }

	IOBJECT_DECLARE_GETSET1(TubeVariationFactor,float);
//	virtual void SetTubeVariationFactor(float q);
//	inline float GetTubeVariationFactor() const { return mTubeVariationFactor; }

	IOBJECT_DECLARE_GETSET1(SourceType,int);
//	virtual void SetSourceType(int v);
//	inline int GetSourceType() const { return mSourceType; }
	
	IOBJECT_DECLARE_GETSET(NumberOfStreamLines,mNumLines,int);
//	virtual void SetNumberOfStreamLines(int v);
//	inline int GetNumberOfStreamLines() const { return mNumLines; }

	IOBJECT_DECLARE_GETSET_DISTANCE(SourceSize,mSourceSize);  //  for sphere 
	//virtual void SetSourceSize(const iDistance &o);
	//inline const iDistance& GetSourceSize() const { return mSourceSize; }
	
	IOBJECT_DECLARE_GETSET(SourceOpacity,mOpacities[1],float);  
	//virtual void SetSourceObjectOpacity(float o);
	//inline float GetSourceObjectOpacity() const { return mOpacities[1]; }
	
	IOBJECT_DECLARE_GETSET(ShowSourceObject,mSourceShow,bool);  //  for sphere 
	//virtual void SetShowSourceObject(bool o);
	//inline float GetShowSourceObject() const { return mSourceShow; }

	virtual void SetSourceDirection(const float n[3]);  // for plane
	inline const float* GetSourceDirection() const { return mSourceDir; }
	static const iObjectKey& KeySourceDirection();

	virtual void UpdateAfterMarkerMove();
	virtual void UpdateAfterMarkerAdd(iMarker *m);
	virtual void UpdateAfterMarkerDelete(iMarker *m);

	//
	//  Inherited members
	//
	virtual iViewSubjectPipeline* CreatePipeline(int id);
	IFIELDVIEWSUBJECT_DECLARE_INHERITED_KEYS;
	IFIELDVIEWSUBJECT_DECLARE_INHERITED_MEMBERS;

#ifdef IOBJECT_BACKWARD_COMPATIBLE
	static const iObjectKey& KeySourcePosition(bool opengl = false);
	static const iObjectKey& KeyAttachSourceToMarker();
	static const iObjectKey& KeySourcePositionToPickedPoint();
#endif

protected:
	
	iVectorFieldViewSubject(iViewModule *vm, const iDataType &type, const iDataType &scalarType, const iString &name);
	virtual ~iVectorFieldViewSubject();
	virtual void ConfigureBody();
	virtual void ConfigureMainPipeline(iViewSubjectPipeline *p, int id);

	virtual float GetExtraMemorySize() const;
	virtual void RemoveInternalDataForExtraComponents();	

	virtual void UpdatePipelines();
	virtual void UpdateColorByExtra();
	virtual void UpdateStreamLineSource();
	virtual void UpdatePosition(const iPosition &oldPos);

	iDistance mSourceSize;

	bool mSourceShow;
	int mAttachedMarkerIndex;
	int mMethod, mTubeSize, mLineQuality;
	float mLineLength, mSourceDir[3];
	int mLineDir, mSourceType, mNumLines;
	float mTubeRangeFactor, mTubeVariationFactor;
	//
	//  VTK stuff
	//
	vtkPoints *mStreamLineSourcePoints;
	vtkCellArray *mStreamLineSourceVerts;
	vtkFloatArray *mStreamLineSourceNorms;

	iBoundedDiskSource *mSourceDisk;
	iBoundedPlaneSource *mSourcePlane;
	iBoundedSphereSource *mSourceSphere;
};

#endif // IVECTORFIELDVIEWSUBJECT_H

