/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iconfigure.h"
#if ISHELL_INCLUDED(ISHELL_GG)


#include "iggpagetensorfield.h"


#include "idatasubject.h"
#include "iimagefactory.h"
#include "itensorfieldviewsubject.h"
#include "iviewmodule.h"

#include "iggdatatypeprovider.h"
#include "iggframedatavariablelist.h"
#include "iggframematerialproperties.h"
#include "iggframepaletteselection.h"
#include "iggframereplicate.h"
#include "iggwidgetkeybutton.h"
#include "iggwidgetkeycolorselection.h"
#include "iggwidgetkeyselectionbox.h"
#include "iggwidgetkeyslider.h"
#include "iggwidgetotherbutton.h"

#include "ibgwidgetentrysubject.h"

#include "iggparameter.h"
using namespace iggParameter;

//
//  Templates (needed for some compilers)
//
#include "iarraytemplate.h"
#include "iggwidgetkeyslidertemplate.h"


iggPageTensorField::iggPageTensorField(iggFrameBase *parent) : iggPageObject(parent,iParameter::_ObjectTypeTensorField)
{
	const iImage *icon = iImageFactory::FindIcon("tens.png");

	//
	//  Main page
	// ************************************************
	//
	iggFrame *page0 = new iggFrame(mBook,3);
	mBook->AddPage("Main",icon,page0);
	//
	//  Show
	//
	page0->AddLine(new iggWidgetShowButton(iTensorFieldViewSubject::Type(),page0));
	page0->AddSpace(2);
	//
	//  Method & color
	//
	iggFrame *mc = new iggFrame(page0,2);
	iggWidgetKeyRadioBox *mb = new iggWidgetKeyRadioBox(1,"Method",0,iTensorFieldViewSubject::KeyMethod(),mc);
	mb->InsertItem("Glyph");
	mc->AddLine(mb,new iggWidgetKeyColorSelection(iTensorFieldViewSubject::KeyColor(),mc,false));
	page0->AddLine(mc);
	page0->AddSpace(10);
	//
	//  Glyph size
	//
	page0->AddLine(new iggWidgetKeySizeSlider(1.0e-5,0,"Glyph size",iTensorFieldViewSubject::KeyGlyphSize(true),_RenderModeUseGlobal,page0),2);
	page0->AddSpace(2);
	//
	//  Tensor magnitude and downsample
	//
	//iggWidgetKeyRelativeFloatSlider *ms = new iggWidgetKeyRelativeFloatSlider(iDataSubject::KeyMax(),0.0,1.0,100,0,5,"Tensor magnitude",iDataSubject::KeyUpperLimit(),_RenderModeUseGlobal,page0,0);
	//ms->AttachDataTypeProvider(mProvider);
	iggWidgetKeyVariableLimitsSlider *ms = new iggWidgetKeyVariableLimitsSlider(mProvider,5,"Tensor magnitude",iDataSubject::KeyUpperLimit(),0,0,_RenderModeUseGlobal,page0,0);
	ms->SetStretch(5,10,0);
	page0->AddLine(ms,2);
	iggWidgetKeyIntSlider *rs = new iggWidgetKeyIntSlider(1,20,5,"Sample rate",iTensorFieldViewSubject::KeyGlyphSampleRate(),_RenderModeUseGlobal,page0);
	rs->SetStretch(5,10,0);
	page0->AddLine(rs,2);
	page0->AddSpace(10);

	page0->SetColStretch(1,10);
	page0->SetColStretch(2,3);

	//
	//  Paint page
	// ************************************************
	//
	iggFrame *page1 = new iggFrame(mBook,1);
	mBook->AddPage("Paint",icon,page1);
	//
	//  Book
	//
	iggFrameBook *pb = new iggFrameBook(page1);
	page1->AddLine(pb);
	//
	//  Palette page
	//
	iggFrame *pbpage0 = new iggFrame(pb,3);
	pb->AddPage("Palette",icon,pbpage0);

	iggFrameDataVariableList *pl = new iggFrameDataVariableList(mScalarProvider,"Paint with...",iTensorFieldViewSubject::KeyColorBy(),&iTensorFieldViewSubject::KeyConnectedToScalars(),pbpage0);
	pl->InsertItem("None");
	pl->Complete();
	pbpage0->AddLine(pl);
	pbpage0->AddSpace(10);
	pbpage0->AddLine(new iggFramePaletteSelection(true,iTensorFieldViewSubject::KeyPalette(),pbpage0),2);
	pbpage0->AddSpace(20);
	pbpage0->SetColStretch(1,10);
	pbpage0->SetColStretch(2,3);
	//
	//  Material page
	//
	iggFrame *pbpage1 = new iggFrame(pb,2);
	pb->AddPage("Material",icon,pbpage1);

	pbpage1->AddLine(new iggFrameMaterialProperties(false,false,iTensorFieldViewSubject::Type(),pbpage1));
	pbpage1->AddSpace(10);
	pbpage1->SetColStretch(0,10);
	pbpage1->SetColStretch(1,3);

	//
	//  Replicate page
	// ************************************************
	//
	iggFrame *page2 = new iggFrame(mBook,2);
	mBook->AddPage("Replicate",icon,page2);
	//
	//  Replicate
	//
	page2->AddLine(new iggFrameReplicate(iTensorFieldViewSubject::Type(),page2));
	page2->AddSpace(10);
	page2->SetColStretch(1,3);
}

#endif
