/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


//
//  A generic GUI shell
//

#ifndef IGGSHELL_H
#define IGGSHELL_H


#include "ishell.h"


class iggDialogFlashWindow;
class iggMainWindow;

class ibgShellSubject;


class iggShell : public iShell
{

	friend class iShellFactory;

public:

	vtkTypeMacro(iggShell,iShell);

	inline iggMainWindow* GetMainWindow() const { return mMainWindow; }

	virtual void Exit();


	void GetDesktopDimensions(int &w, int &h) const;
	void ProcessEvents(bool sync = false);

	bool IsDesktopSmall(bool vert) const;
	bool CheckCondition(int flag) const;

protected:

	iggShell(const iString &type, int argc, char **argv);
	virtual ~iggShell();

	virtual void ConstructorBody();  
	virtual void DestructorBody();  

	virtual void Start();
	virtual void RunBody();
	virtual void PrepareForConstruction();
	virtual void PrepareToLoadStateFile();
	virtual bool LoadShellStateFromFileBody(iFile &F);
	virtual bool SaveShellStateToFileBody(iFile &F) const;
	virtual void DefineSpecificCommandLineOptions();
	virtual bool AnalyseOneExtendedCommandLineOption(const struct Option &o);

	virtual void OnInitAtomBody(bool timed);
	virtual void OnLoadStateFileAtomBody(int prog);

private:

	ibgShellSubject *mSubject;
	iggMainWindow *mMainWindow;
	bool mShowFlashWindow, mAccept8BitDisplay, mStartDocked;
	int mConditionFlags;
	iggDialogFlashWindow *mFlashWindow;
};

#endif  // IGGSHELL_H

