/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IPALETTESET_H
#define IPALETTESET_H


#include "iobject.h"


#include "iarray.h"

class iPalette;

class vtkColorTransferFunction;
class vtkLookupTable;


//
//  We inherit from iObejct to get access to state saving
//
class iPaletteSet : public iObject
{

public:

	vtkTypeMacro(iPaletteSet,iObject);
	static iPaletteSet* New();
	static const iObjectType& Type();
	
	//
	//  Default set, available everywhere
	//
	static iPaletteSet* Default();

	//
	//  Palette interface
	//
	inline int GetNumberOfPalettes() const { return mList.Size(); }

	iPalette* GetPalette(int n) const;
	vtkLookupTable* GetLookupTable(int id) const;
	vtkColorTransferFunction* GetColorTransferFunction(int id) const;

	bool AddEmptyPalette();

	//
	//  Palette packing helpers (not using keys) - internal access for shells etc
	//
	void PackValuePalette(iString &s, const iPalette *p) const;
	bool UnPackValuePalette(const iString &s, iPalette *p);

protected:

	virtual ~iPaletteSet();

	virtual void PackStateBody(iString &s) const;
	virtual void UnPackStateBody(const iString &s);

private:

    iPaletteSet();

	void CreateDefaultPalettes();

	static const iObjectKey& KeyPalette();
	//
	//  Deprecated access
	//
	static const iObjectKey& KeyRed();
	static const iObjectKey& KeyGreen();
	static const iObjectKey& KeyBlue();

	//
	//  Palettes
	//
	iArray<iPalette*> mList;
};

#endif  // IPALETTESET_H
