/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2011 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  IFrIT control script class - maps control commands to function calls
//

#ifndef ICONTROLSCRIPT_H
#define ICONTROLSCRIPT_H


#include "ibasicscript.h"


#include "ipointermacro.h"

class iControlModule;
class iObjectKey;


class iControlScript: public iBasicScript
{

	IPOINTER_AS_PART(ControlModule);

public:

	enum _HelpId
	{
		_Root = 0,
		_Exec = 1,
		_Print = 2,
		_CreateDelete = 3,
		_Current = 4,
		_Control = 5
	};

	vtkTypeMacro(iControlScript,iBasicScript);
	static iControlScript* New(iControlModule *cm = 0, iScript *parent = 0);

	virtual const iString& GetHelpString(_HelpId id) const;

	void SetAutoRender(bool s){ mAutoRender = s; }
	inline bool GetAutoRender() const { return mAutoRender; }

protected:

	iControlScript(iControlModule *cm, iScript *parent);
	virtual ~iControlScript();

	//
	//  Factory method: replace the calculator with the one that understands key values
	//
	virtual iScriptKit::Calculator* CreateCalculator();

	//
	//  Convert keys into calculator variables
	//
	virtual bool SatisfyRequestForVariables(const iString &vars);

private:

	//
	//  Own console functions for re-directing the output into special windows
	//
	virtual void OutputText(const iString &s) const = 0;
	virtual void OutputError(const iString &s) const = 0;

	//
	//  Helper for using object keys as script variables
	//
	void UpdateObjectKey(const iObjectKey *key) const;
	void UpdateObjectKeyVariable(const iObjectKey *key, iScriptKit::Value *val) const;

	static bool ExecBody(iScript *self, const iString &request, int mode);

	bool mAutoRender;

	//
	//  Basic functions
	//
	static bool Exec(iScript *self, const iString &request);
	static bool ExecAllObjects(iScript *self, const iString &request);
	static bool ExecAllWindows(iScript *self, const iString &request);
	static bool Print(iScript *self, const iString &arg);
	static bool Animate(iScript *self, const iString &arg);
	static bool EmbedAnimatorScript(iScript *self, const iString &arg);
	//
	//  Help functions
	//
	static bool Help(iScript *self, const iString &arg);
	static bool HelpObject(iScript *self, const iString &arg);
	static bool HelpProperty(iScript *self, const iString &arg);

	static bool ListObjects(iScript *self);
	static bool ListProperties(iScript *self, const iString &arg);
};

#endif // ICONTROLCRIPT_H
