/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.BaseFileObject;
import com.sun.tools.javac.file.FSInfo;
import com.sun.tools.javac.file.Paths;
import com.sun.tools.javac.file.RegularFileObject;
import com.sun.tools.javac.file.RelativePath;
import com.sun.tools.javac.file.SymbolArchive;
import com.sun.tools.javac.file.ZipArchive;
import com.sun.tools.javac.file.ZipFileIndex;
import com.sun.tools.javac.file.ZipFileIndexArchive;
import com.sun.tools.javac.main.OptionName;
import com.sun.tools.javac.util.BaseFileManager;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipFile;
import javax.lang.model.SourceVersion;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavacFileManager
extends BaseFileManager
implements StandardJavaFileManager {
    boolean useZipFileIndex;
    private Paths paths;
    private FSInfo fsInfo;
    private final File uninited = new File("U N I N I T E D");
    private final Set<JavaFileObject.Kind> sourceOrClass = EnumSet.of(JavaFileObject.Kind.SOURCE, JavaFileObject.Kind.CLASS);
    private File classOutDir = this.uninited;
    private File sourceOutDir = this.uninited;
    protected boolean mmappedIO;
    protected boolean ignoreSymbolFile;
    private static final boolean fileSystemIsCaseSensitive = File.separatorChar == '/';
    Map<File, Archive> archives = new HashMap<File, Archive>();
    private static final String[] symbolFileLocation = new String[]{"lib", "ct.sym"};
    private static final RelativePath.RelativeDirectory symbolFilePrefix = new RelativePath.RelativeDirectory("META-INF/sym/rt.jar/");
    private String defaultEncodingName;

    public static char[] toArray(CharBuffer charBuffer) {
        if (charBuffer.hasArray()) {
            return ((CharBuffer)charBuffer.compact().flip()).array();
        }
        return charBuffer.toString().toCharArray();
    }

    public static void preRegister(final Context context) {
        context.put(JavaFileManager.class, new Context.Factory<JavaFileManager>(){

            @Override
            public JavaFileManager make() {
                return new JavacFileManager(context, true, null);
            }
        });
    }

    public JavacFileManager(Context context, boolean bl, Charset charset) {
        super(charset);
        if (bl) {
            context.put(JavaFileManager.class, this);
        }
        this.setContext(context);
    }

    @Override
    public void setContext(Context context) {
        super.setContext(context);
        if (this.paths == null) {
            this.paths = Paths.instance(context);
        } else {
            this.paths.setContext(context);
        }
        this.fsInfo = FSInfo.instance(context);
        this.useZipFileIndex = System.getProperty("useJavaUtilZip") == null;
        this.mmappedIO = this.options.get("mmappedIO") != null;
        this.ignoreSymbolFile = this.options.get("ignore.symbol.file") != null;
    }

    public JavaFileObject getFileForInput(String string) {
        return this.getRegularFile(new File(string));
    }

    public JavaFileObject getRegularFile(File file) {
        return new RegularFileObject(this, file);
    }

    public JavaFileObject getFileForOutput(String string, JavaFileObject.Kind kind, JavaFileObject javaFileObject) throws IOException {
        return this.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, string, kind, javaFileObject);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> iterable) {
        ListBuffer<File> listBuffer = new ListBuffer<File>();
        for (String string : iterable) {
            listBuffer.append(new File(JavacFileManager.nullCheck(string)));
        }
        return this.getJavaFileObjectsFromFiles(listBuffer.toList());
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... stringArray) {
        return this.getJavaFileObjectsFromStrings(Arrays.asList((Object[])JavacFileManager.nullCheck(stringArray)));
    }

    private static boolean isValidName(String string) {
        for (String string2 : string.split("\\.", -1)) {
            if (SourceVersion.isIdentifier(string2)) continue;
            return false;
        }
        return true;
    }

    private static void validateClassName(String string) {
        if (!JavacFileManager.isValidName(string)) {
            throw new IllegalArgumentException("Invalid class name: " + string);
        }
    }

    private static void validatePackageName(String string) {
        if (string.length() > 0 && !JavacFileManager.isValidName(string)) {
            throw new IllegalArgumentException("Invalid packageName name: " + string);
        }
    }

    public static void testName(String string, boolean bl, boolean bl2) {
        try {
            JavacFileManager.validatePackageName(string);
            if (!bl) {
                throw new AssertionError((Object)("Invalid package name accepted: " + string));
            }
            JavacFileManager.printAscii("Valid package name: \"%s\"", string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (bl) {
                throw new AssertionError((Object)("Valid package name rejected: " + string));
            }
            JavacFileManager.printAscii("Invalid package name: \"%s\"", string);
        }
        try {
            JavacFileManager.validateClassName(string);
            if (!bl2) {
                throw new AssertionError((Object)("Invalid class name accepted: " + string));
            }
            JavacFileManager.printAscii("Valid class name: \"%s\"", string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (bl2) {
                throw new AssertionError((Object)("Valid class name rejected: " + string));
            }
            JavacFileManager.printAscii("Invalid class name: \"%s\"", string);
        }
    }

    private static void printAscii(String string, Object ... objectArray) {
        String string2;
        try {
            string2 = new String(String.format(null, string, objectArray).getBytes("US-ASCII"), "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
        System.out.println(string2);
    }

    private void listDirectory(File file, RelativePath.RelativeDirectory relativeDirectory, Set<JavaFileObject.Kind> set, boolean bl, ListBuffer<JavaFileObject> listBuffer) {
        block12: {
            block11: {
                List<String> list;
                Archive archive = this.archives.get(file);
                boolean bl2 = this.fsInfo.isFile(file);
                if (archive == null && !bl2) break block11;
                if (archive == null) {
                    try {
                        archive = this.openArchive(file);
                    }
                    catch (IOException iOException) {
                        this.log.error("error.reading.file", file, JavacFileManager.getMessage(iOException));
                        return;
                    }
                }
                if ((list = archive.getFiles(relativeDirectory)) != null) {
                    while (!list.isEmpty()) {
                        String string = (String)list.head;
                        if (this.isValidFile(string, set)) {
                            listBuffer.append(archive.getFileObject(relativeDirectory, string));
                        }
                        list = list.tail;
                    }
                }
                if (!bl) break block12;
                for (RelativePath.RelativeDirectory relativeDirectory2 : archive.getSubdirectories()) {
                    if (!relativeDirectory.contains(relativeDirectory2)) continue;
                    this.listDirectory(file, relativeDirectory2, set, false, listBuffer);
                }
                break block12;
            }
            File file2 = relativeDirectory.getFile(file);
            if (!this.caseMapCheck(file2, relativeDirectory)) {
                return;
            }
            File[] fileArray = file2.listFiles();
            if (fileArray == null) {
                return;
            }
            for (File file3 : fileArray) {
                String string = file3.getName();
                if (file3.isDirectory()) {
                    if (!bl || !SourceVersion.isIdentifier(string)) continue;
                    this.listDirectory(file, new RelativePath.RelativeDirectory(relativeDirectory, string), set, bl, listBuffer);
                    continue;
                }
                if (!this.isValidFile(string, set)) continue;
                RegularFileObject regularFileObject = new RegularFileObject(this, string, new File(file2, string));
                listBuffer.append(regularFileObject);
            }
        }
    }

    private boolean isValidFile(String string, Set<JavaFileObject.Kind> set) {
        JavaFileObject.Kind kind = JavacFileManager.getKind(string);
        return set.contains((Object)kind);
    }

    private boolean caseMapCheck(File file, RelativePath relativePath) {
        String string;
        if (fileSystemIsCaseSensitive) {
            return true;
        }
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return false;
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = relativePath.path.toCharArray();
        int n = cArray.length - 1;
        int n2 = cArray2.length - 1;
        while (n >= 0 && n2 >= 0) {
            while (n >= 0 && cArray[n] == File.separatorChar) {
                --n;
            }
            while (n2 >= 0 && cArray2[n2] == '/') {
                --n2;
            }
            if (n < 0 || n2 < 0) continue;
            if (cArray[n] != cArray2[n2]) {
                return false;
            }
            --n;
            --n2;
        }
        return n2 < 0;
    }

    protected Archive openArchive(File object) throws IOException {
        Archive archive = this.archives.get(object);
        if (archive == null) {
            Object object2;
            Object file = object;
            if (!this.ignoreSymbolFile && this.paths.isBootClassPathRtJar((File)object)) {
                object2 = ((File)object).getParentFile().getParentFile();
                if (new File(((File)object2).getName()).equals(new File("jre"))) {
                    object2 = ((File)object2).getParentFile();
                }
                for (String object3 : symbolFileLocation) {
                    object2 = new File((File)object2, object3);
                }
                if (((File)object2).exists()) {
                    object = object2;
                }
            }
            try {
                object2 = null;
                boolean bl = false;
                String string = null;
                if (!this.useZipFileIndex) {
                    object2 = new ZipFile((File)object);
                } else {
                    bl = this.options.get("usezipindex") != null;
                    string = this.options.get("java.io.tmpdir");
                    String string2 = this.options.get("cachezipindexdir");
                    if (string2 != null && string2.length() != 0) {
                        File file2;
                        if (string2.startsWith("\"")) {
                            string2 = string2.endsWith("\"") ? string2.substring(1, string2.length() - 1) : string2.substring(1);
                        }
                        if ((file2 = new File(string2)).exists() && file2.canWrite() && !(string = string2).endsWith("/") && !string.endsWith(File.separator)) {
                            string = string + File.separator;
                        }
                    }
                }
                archive = file == object ? (!this.useZipFileIndex ? new ZipArchive(this, (ZipFile)object2) : new ZipFileIndexArchive(this, ZipFileIndex.getZipFileIndex((File)object, null, bl, string, this.options.get("writezipindexfiles") != null))) : (!this.useZipFileIndex ? new SymbolArchive(this, (File)file, (ZipFile)object2, symbolFilePrefix) : new ZipFileIndexArchive(this, ZipFileIndex.getZipFileIndex((File)object, symbolFilePrefix, bl, string, this.options.get("writezipindexfiles") != null)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                archive = new MissingArchive((File)object);
            }
            catch (IOException iOException) {
                if (((File)object).exists()) {
                    this.log.error("error.reading.file", object, JavacFileManager.getMessage(iOException));
                }
                archive = new MissingArchive((File)object);
            }
            this.archives.put((File)file, archive);
        }
        return archive;
    }

    @Override
    public void flush() {
        this.contentCache.clear();
    }

    @Override
    public void close() {
        Iterator<Archive> iterator = this.archives.values().iterator();
        while (iterator.hasNext()) {
            Archive archive = iterator.next();
            iterator.remove();
            try {
                archive.close();
            }
            catch (IOException iOException) {}
        }
    }

    private String getDefaultEncodingName() {
        if (this.defaultEncodingName == null) {
            this.defaultEncodingName = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
        }
        return this.defaultEncodingName;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        JavacFileManager.nullCheck(location);
        Iterable<? extends File> iterable = this.getLocation(location);
        if (iterable == null) {
            return null;
        }
        ListBuffer<URL> listBuffer = new ListBuffer<URL>();
        for (File file : iterable) {
            try {
                listBuffer.append(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                throw new AssertionError((Object)malformedURLException);
            }
        }
        return this.getClassLoader(listBuffer.toArray(new URL[listBuffer.size()]));
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String string, Set<JavaFileObject.Kind> set, boolean bl) throws IOException {
        JavacFileManager.nullCheck(string);
        JavacFileManager.nullCheck(set);
        Iterable<? extends File> iterable = this.getLocation(location);
        if (iterable == null) {
            return List.nil();
        }
        RelativePath.RelativeDirectory relativeDirectory = RelativePath.RelativeDirectory.forPackage(string);
        ListBuffer<JavaFileObject> listBuffer = new ListBuffer<JavaFileObject>();
        for (File file : iterable) {
            this.listDirectory(file, relativeDirectory, set, bl, listBuffer);
        }
        return listBuffer.toList();
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject javaFileObject) {
        javaFileObject.getClass();
        location.getClass();
        Iterable<? extends File> iterable = this.getLocation(location);
        if (iterable == null) {
            return null;
        }
        if (javaFileObject instanceof BaseFileObject) {
            return ((BaseFileObject)javaFileObject).inferBinaryName(iterable);
        }
        throw new IllegalArgumentException(javaFileObject.getClass().getName());
    }

    @Override
    public boolean isSameFile(FileObject fileObject, FileObject fileObject2) {
        JavacFileManager.nullCheck(fileObject);
        JavacFileManager.nullCheck(fileObject2);
        if (!(fileObject instanceof BaseFileObject)) {
            throw new IllegalArgumentException("Not supported: " + fileObject);
        }
        if (!(fileObject2 instanceof BaseFileObject)) {
            throw new IllegalArgumentException("Not supported: " + fileObject2);
        }
        return fileObject.equals(fileObject2);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return this.getLocation(location) != null;
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(string);
        JavacFileManager.nullCheck(kind);
        if (!this.sourceOrClass.contains((Object)kind)) {
            throw new IllegalArgumentException("Invalid kind " + (Object)((Object)kind));
        }
        return this.getFileForInput(location, RelativePath.RelativeFile.forClass(string, kind));
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String string, String string2) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(string);
        if (!JavacFileManager.isRelativeUri(string2)) {
            throw new IllegalArgumentException("Invalid relative name: " + string2);
        }
        RelativePath.RelativeFile relativeFile = string.length() == 0 ? new RelativePath.RelativeFile(string2) : new RelativePath.RelativeFile(RelativePath.RelativeDirectory.forPackage(string), string2);
        return this.getFileForInput(location, relativeFile);
    }

    private JavaFileObject getFileForInput(JavaFileManager.Location location, RelativePath.RelativeFile relativeFile) throws IOException {
        Iterable<? extends File> iterable = this.getLocation(location);
        if (iterable == null) {
            return null;
        }
        for (File file : iterable) {
            Object object;
            if (file.isDirectory()) {
                object = relativeFile.getFile(file);
                if (!((File)object).exists()) continue;
                return new RegularFileObject(this, (File)object);
            }
            object = this.openArchive(file);
            if (!object.contains(relativeFile)) continue;
            return object.getFileObject(relativeFile.dirname(), relativeFile.basename());
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, FileObject fileObject) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(string);
        JavacFileManager.nullCheck(kind);
        if (!this.sourceOrClass.contains((Object)kind)) {
            throw new IllegalArgumentException("Invalid kind " + (Object)((Object)kind));
        }
        return this.getFileForOutput(location, RelativePath.RelativeFile.forClass(string, kind), fileObject);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String string, String string2, FileObject fileObject) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(string);
        if (!JavacFileManager.isRelativeUri(string2)) {
            throw new IllegalArgumentException("relativeName is invalid");
        }
        RelativePath.RelativeFile relativeFile = string.length() == 0 ? new RelativePath.RelativeFile(string2) : new RelativePath.RelativeFile(RelativePath.RelativeDirectory.forPackage(string), string2);
        return this.getFileForOutput(location, relativeFile, fileObject);
    }

    /*
     * Enabled aggressive block sorting
     */
    private JavaFileObject getFileForOutput(JavaFileManager.Location location, RelativePath.RelativeFile relativeFile, FileObject fileObject) throws IOException {
        Serializable serializable;
        File file;
        block7: {
            if (location == StandardLocation.CLASS_OUTPUT) {
                if (this.getClassOutDir() != null) {
                    file = this.getClassOutDir();
                    break block7;
                } else {
                    File file2 = null;
                    if (fileObject != null && fileObject instanceof RegularFileObject) {
                        file2 = ((RegularFileObject)fileObject).file.getParentFile();
                    }
                    return new RegularFileObject(this, new File(file2, relativeFile.basename()));
                }
            }
            if (location == StandardLocation.SOURCE_OUTPUT) {
                file = this.getSourceOutDir() != null ? this.getSourceOutDir() : this.getClassOutDir();
            } else {
                serializable = this.paths.getPathForLocation(location);
                file = null;
                Iterator iterator = serializable.iterator();
                if (iterator.hasNext()) {
                    File file3;
                    file = file3 = (File)iterator.next();
                }
            }
        }
        serializable = relativeFile.getFile(file);
        return new RegularFileObject(this, (File)serializable);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> iterable) {
        ArrayList<RegularFileObject> arrayList = iterable instanceof Collection ? new ArrayList(((Collection)iterable).size()) : new ArrayList<RegularFileObject>();
        for (File file : iterable) {
            arrayList.add(new RegularFileObject(this, JavacFileManager.nullCheck(file)));
        }
        return arrayList;
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... fileArray) {
        return this.getJavaFileObjectsFromFiles(Arrays.asList((Object[])JavacFileManager.nullCheck(fileArray)));
    }

    @Override
    public void setLocation(JavaFileManager.Location location, Iterable<? extends File> iterable) throws IOException {
        File file;
        JavacFileManager.nullCheck(location);
        this.paths.lazy();
        File file2 = file = location.isOutputLocation() ? this.getOutputDirectory(iterable) : null;
        if (location == StandardLocation.CLASS_OUTPUT) {
            this.classOutDir = this.getOutputLocation(file, OptionName.D);
        } else if (location == StandardLocation.SOURCE_OUTPUT) {
            this.sourceOutDir = this.getOutputLocation(file, OptionName.S);
        } else {
            this.paths.setPathForLocation(location, iterable);
        }
    }

    private File getOutputDirectory(Iterable<? extends File> iterable) throws IOException {
        if (iterable == null) {
            return null;
        }
        Iterator<? extends File> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("empty path for directory");
        }
        File file = iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalArgumentException("path too long for directory");
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file + ": does not exist");
        }
        if (!file.isDirectory()) {
            throw new IOException(file + ": not a directory");
        }
        return file;
    }

    private File getOutputLocation(File file, OptionName optionName) {
        if (file != null) {
            return file;
        }
        String string = this.options.get(optionName);
        if (string == null) {
            return null;
        }
        return new File(string);
    }

    @Override
    public Iterable<? extends File> getLocation(JavaFileManager.Location location) {
        JavacFileManager.nullCheck(location);
        this.paths.lazy();
        if (location == StandardLocation.CLASS_OUTPUT) {
            return this.getClassOutDir() == null ? null : List.of(this.getClassOutDir());
        }
        if (location == StandardLocation.SOURCE_OUTPUT) {
            return this.getSourceOutDir() == null ? null : List.of(this.getSourceOutDir());
        }
        return this.paths.getPathForLocation(location);
    }

    private File getClassOutDir() {
        if (this.classOutDir == this.uninited) {
            this.classOutDir = this.getOutputLocation(null, OptionName.D);
        }
        return this.classOutDir;
    }

    private File getSourceOutDir() {
        if (this.sourceOutDir == this.uninited) {
            this.sourceOutDir = this.getOutputLocation(null, OptionName.S);
        }
        return this.sourceOutDir;
    }

    protected static boolean isRelativeUri(URI uRI) {
        if (uRI.isAbsolute()) {
            return false;
        }
        String string = uRI.normalize().getPath();
        if (string.length() == 0) {
            return false;
        }
        char c = string.charAt(0);
        return c != '.' && c != '/';
    }

    protected static boolean isRelativeUri(String string) {
        try {
            return JavacFileManager.isRelativeUri(new URI(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    public static String getRelativeName(File file) {
        String string;
        if (!file.isAbsolute() && JavacFileManager.isRelativeUri(string = file.getPath().replace(File.separatorChar, '/'))) {
            return string;
        }
        throw new IllegalArgumentException("Invalid relative path: " + file);
    }

    public static String getMessage(IOException iOException) {
        String string = iOException.getLocalizedMessage();
        if (string != null) {
            return string;
        }
        string = iOException.getMessage();
        if (string != null) {
            return string;
        }
        return iOException.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MissingArchive
    implements Archive {
        final File zipFileName;

        public MissingArchive(File file) {
            this.zipFileName = file;
        }

        @Override
        public boolean contains(RelativePath relativePath) {
            return false;
        }

        @Override
        public void close() {
        }

        @Override
        public JavaFileObject getFileObject(RelativePath.RelativeDirectory relativeDirectory, String string) {
            return null;
        }

        @Override
        public List<String> getFiles(RelativePath.RelativeDirectory relativeDirectory) {
            return List.nil();
        }

        @Override
        public Set<RelativePath.RelativeDirectory> getSubdirectories() {
            return Collections.emptySet();
        }

        public String toString() {
            return "MissingArchive[" + this.zipFileName + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Archive {
        public void close() throws IOException;

        public boolean contains(RelativePath var1);

        public JavaFileObject getFileObject(RelativePath.RelativeDirectory var1, String var2);

        public List<String> getFiles(RelativePath.RelativeDirectory var1);

        public Set<RelativePath.RelativeDirectory> getSubdirectories();
    }
}

