#ifndef IIIMPROTOCOL_HH_
#define IIIMPROTOCOL_HH_
#include <map>
#include "basictype.hh"
#include "IMProtocol.hh"
#include "IMUtil.hh"

class IIIMP_IMState;
class IIIMPTrans;

class IIIMProtocol : public IMProtocol
{
    IMSocketListen *pimsl;

    typedef map<IIIMPTrans*, IIIMP_IMState*> IIIMPClientMap;

    bool restart(
	IMSocketAddressVec &addrvec
    );

  public:
    virtual bool receive_and_dispatch(
	IMState *pims,
	int flags = SYNC
    );
    virtual IMState* accept(
	int flags = SYNC
    );

    bool set_server_listen_address(
	IMSocketAddressVec &addrvec
    );
    IIIMProtocol(
	IMAccept *pima
    );
    virtual ~IIIMProtocol();
};

#endif /* not IIIMPROTOCOL_HH_ */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
