/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_LIBWRAP
#include <syslog.h>
int allow_severity = LOG_DEBUG;
int deny_severity = LOG_WARNING;
#include <tcpd.h>
#endif

#ifdef HAVE_PAM
#include <security/pam_appl.h>
#endif

#include <stdlib.h>
#include <string.h>
#include "iwrap.h"

int permit_access(
    const char *cmdname,
    int h
)
{
#ifdef HAVE_LIBWRAP
    struct request_info req;

    request_init(&req, RQ_DAEMON, cmdname, RQ_FILE, h, 0);
    fromhost(&req);

    if (!hosts_access(&req)) return 0;
#endif

    return 1;
}

#ifdef HAVE_PAM
static int
local_conv_for_pam(
    int num_msg,
    const struct pam_message **msg,
    struct pam_response **resp,
    void *appdata_ptr
)
{
/* When PAM would like to make a conversation, this function
   will silence it :-P. */
    int i;
    int style;
    struct pam_response *rs;

    rs = (struct pam_response*) malloc(num_msg * sizeof(struct pam_response));
    if (!rs) return PAM_CONV_ERR;
    for (i = 0;i < num_msg;i++)	{
	style = msg[i]->msg_style;
	if (style == PAM_PROMPT_ECHO_OFF) {
	    rs[i].resp_retcode = 0;
	    rs[i].resp = strdup((char*) appdata_ptr);
	} else {
	    rs[i].resp_retcode = 0;
	    rs[i].resp = NULL;
	}
    }
    *resp = rs;

    return PAM_SUCCESS;
}
#endif /* HAVE_PAM */

int
authenticate_with_pam(
    const char *user,
    const char *password,
    const char *command_name,
    const char *hostname
)
{
#ifdef HAVE_PAM
    struct pam_conv cv;
    pam_handle_t *ph = NULL;
    int ret, flag;

    cv.conv = local_conv_for_pam;
    cv.appdata_ptr = (void*) password;
    ret = pam_start(command_name, user, &cv, &ph);
    if (ret != PAM_SUCCESS) goto fail;

    if (hostname) {
	ret = pam_set_item(ph, PAM_RHOST, hostname);
	if (ret != PAM_SUCCESS) goto fail;
    }

    /* Account checking. */
    ret = pam_acct_mgmt(ph, PAM_SILENT);
    if (ret != PAM_SUCCESS) goto fail;

    /* Password checking. */
    if (password) {
	ret = pam_set_item(ph, PAM_AUTHTOK, password);
	/* 
	   Don't check the return value for the PAM not supporting
	   PAM_AUTHTOK.
	   if (ret != PAM_SUCCESS) goto fail;
	*/
	ret = pam_authenticate(ph, PAM_SILENT);
	if (ret != PAM_SUCCESS) goto fail;
    }

success:
    pam_end(ph, ret);
    return 1;
fail:
    pam_end(ph, ret);
    return 0;
#else /* not HAVE_PAM */
    return 0;
#endif /* not HAVE_PAM */
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
