/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef resourcedb_hh
#define resourcedb_hh

#include "IMArg.h"

typedef struct _RmDatabase {
    char *if_name;
    char *conv_keys;
    char *port_number;
    Bool support_ximp40;
    Bool support_iiimp;
    Bool use_htt_props;
    char *fontset;
    char * preedit_move;
    unsigned long background;
    unsigned long foreground;
    char * root_geom;
    char *root_title;
    Bool has_root_title;
    char *root_layout;
    char *root_position;
    char *root_place;
    char *root_display;
    char * root_status_geom;
    char *status_place;
    char *status_position;
    int status_max_width;	
    int lookup_rows;
    int lookup_columns;
    char *lookup_place;
    char *lookup_position;
    char *lookup_window;
    char *lookup_label;
    char *lookup_title;
    Bool has_lookup_title;
    char *lookup_policy;
    char *hotkey_string;
/* hidden resources  */
    Bool has_decoration;
    Bool preedit_usearrow;
    Bool   use_default_colors;	
    Bool disable_status_area;
    char * lookup_bg_str;
    char * lookup_fg_str;
} RmDatabase;

class ResourceDB {
public:
  ResourceDB(Widget);
  ~ResourceDB();

  enum RDB_NAME {
    RDB_CONV_ON_KEY = 2,
    RDB_IF_NAME = 3,
    RDB_DISABLE_STATUS_AREA = 4
  };
  int getValues(IMArg*, unsigned int);
private:
  RmDatabase rdb;
  
};
#endif
