#include <stdio.h>

#include "le.h"
#include "encode.h"

unsigned char English_Status_UTF[] = {
	'[', ' ', 'E', 'n', 'g', 'l', 'i', 's', 'h', ' ', ']', 0x0
};

extern int        	gEngine_Num;
extern IMEEngineRec 	*gEngine_Info[MAX_ENGINE_NUM];
extern IMEModeList 	*modeList[MAX_ENGINE_NUM];

void ime_buffer_free(IMEBuffer ime_buffer);

/* ============================================================== */
/*                   IME buffer for every session                 */
/* ============================================================== */
IMEBufferRec *ime_buffer_malloc()
{
	int i;
	IMEBuffer ime_buffer;

	ime_buffer = (IMEBufferRec *)calloc(1, sizeof(IMEBufferRec));

	ime_buffer->inputkey_buf = (char *)calloc(MAX_INPUT_KEY_NUM, sizeof(char));	
	ime_buffer->preedit_buf = (unsigned char *)calloc(MAX_PREEDIT_CHAR_NUM, sizeof(char));
	ime_buffer->status_buf = (unsigned char *)calloc(MAX_STATUS_CHAR_NUM, sizeof(char));
	ime_buffer->commit_buf = (unsigned char *)calloc(MAX_COMMIT_CHAR_NUM, sizeof(char));

	ime_buffer->lookup_buf = (unsigned char **)calloc(MAX_CANDIDATES_NUM, sizeof(unsigned char *));
	ime_buffer->candidates_buf = (unsigned char **)calloc(MAX_CANDIDATES_NUM, sizeof(unsigned char *));
	ime_buffer->additions_buf = (unsigned char **)calloc(MAX_CANDIDATES_NUM, sizeof(unsigned char *));

	if (   	(ime_buffer == NULL) ||
		(ime_buffer->inputkey_buf == NULL) ||
		(ime_buffer->preedit_buf == NULL) ||
		(ime_buffer->status_buf == NULL) ||
		(ime_buffer->commit_buf == NULL) ||
		(ime_buffer->lookup_buf == NULL) ||
		(ime_buffer->candidates_buf == NULL) ||
		(ime_buffer->additions_buf == NULL) )
		goto Error;

	for (i =0; i<MAX_CANDIDATES_NUM; i++) {
		ime_buffer->lookup_buf[i] = (unsigned char *)calloc(MAX_CANDIDATE_CHAR_NUM, sizeof(char));
		ime_buffer->candidates_buf[i] = (unsigned char *)calloc(MAX_CANDIDATE_CHAR_NUM, sizeof(char));
		ime_buffer->additions_buf[i] = (unsigned char *)calloc(MAX_CANDIDATE_CHAR_NUM, sizeof(char));

		if ( 	(ime_buffer->lookup_buf[i] == NULL) ||
			(ime_buffer->candidates_buf[i] == NULL) ||
			(ime_buffer->additions_buf[i] == NULL) )
			goto Error;
	}

	return(ime_buffer);

Error:
	ime_buffer_free(ime_buffer);
	return(NULL);
}

void ime_buffer_free(IMEBuffer ime_buffer)
{
	int i;

	if (ime_buffer->inputkey_buf) free(ime_buffer->inputkey_buf);
	if (ime_buffer->preedit_buf)  free(ime_buffer->preedit_buf);
	if (ime_buffer->status_buf)   free(ime_buffer->status_buf);
	if (ime_buffer->commit_buf)   free(ime_buffer->commit_buf);

	for (i =0; i<MAX_CANDIDATES_NUM; i++) {
		if (ime_buffer->lookup_buf[i])
			free(ime_buffer->lookup_buf[i]);
		if (ime_buffer->candidates_buf[i])
			free(ime_buffer->candidates_buf[i]);
		if (ime_buffer->additions_buf[i])
			free(ime_buffer->additions_buf[i]);
	}
	
	if (ime_buffer->lookup_buf)
		free(ime_buffer->lookup_buf);
	if (ime_buffer->candidates_buf)
		free(ime_buffer->candidates_buf);
	if (ime_buffer->additions_buf)
		free(ime_buffer->additions_buf);

	free(ime_buffer);
}

/* ============================================================== */
/*           Change Language Engine Status Information            */
/* ============================================================== */
/* clear input method buffer */
void le_clear_ime_buffer(iml_session_t *s, IMEBuffer ime_buffer)
{
	ime_buffer->lookup_num = 0;
	iml_lookup_enddraw(s);

	ime_buffer->inputkey_len = 0;
	ime_buffer->preedit_len = 0;
	iml_preedit_enddraw(s);
}

/* output input method buffer to system */
void le_output_ime_buffer(iml_session_t *s, IMEBuffer ime_buffer)
{

	int encode = ime_buffer->encode;
	int status = ime_buffer->return_status;
	int preedit_len = ime_buffer->preedit_len;
	int commit_len = ime_buffer->commit_len;
	int status_len = ime_buffer->status_len;
	int lookup_num = ime_buffer->lookup_num;
	int lookup_label_type = ime_buffer->lookup_label_type;
	int preedit_caretpos = ime_buffer->preedit_caretpos;
	unsigned char *preedit_buf = ime_buffer->preedit_buf;
	unsigned char *commit_buf  = ime_buffer->commit_buf;
	unsigned char *status_buf  = ime_buffer->status_buf;
	unsigned char **lookup_buf = ime_buffer->lookup_buf;

	if (status & IME_STATUS_AREA)
		encode_draw_status(s, encode, status_buf);

	if (status & IME_PREEDIT_AREA) {
		log_f("preedit_len:%d\n", preedit_len);
		preedit_buf[preedit_len] = 0;
		if (preedit_len <= 0)
			iml_preedit_enddraw(s);
		else
			encode_draw_preedit(s, encode, preedit_buf, preedit_caretpos);
	}

	if (status & IME_LOOKUP_AREA) {
		log_f("lookup_num:%d\n", lookup_num);
		if (lookup_num <= 0)
			iml_lookup_enddraw(s);
		else
			encode_draw_candidates(s, encode, lookup_buf, lookup_num, lookup_label_type);
	}

	if ((status & IME_COMMIT) && (commit_len>0)) {
		commit_buf[commit_len] = 0;
		log_f("commit_buf:%s\n", commit_buf);
		encode_commit(s, encode, commit_buf);
	}
}

void le_status_draw(iml_session_t *s)
{
	unsigned char status_str[256];
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
	int engine_id = session_data->paletteaux_status.engine_id;
	int on = session_data->paletteaux_status.on;

  memset((char *)&status_str, '\0', sizeof(status_str));

	if (!on || engine_id == 0xff)
		encode_draw_status(s, ENCODE_UTF8, English_Status_UTF);
	else
	{
    /*
		sprintf((char *)status_str, "[ %s ] [ %s ]", modeList[engine_id]->locale_name, modeList[engine_id]->engine_name);
    */
		sprintf((char *)status_str, "[ %s ] [ %s ]", modeList[engine_id]->nlocale_name, modeList[engine_id]->nlayout_name);
		encode_draw_status(s, gEngine_Info[engine_id]->core.baseinfo.encode_id, status_str);
	}
}

void le_switch_engine(iml_session_t *s, int engine_id)
{
	int ret;
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

	if (engine_id >= gEngine_Num)  
		engine_id = 0xff;

	if (engine_id != 0xff && gEngine_Info[engine_id]->core.baseinfo.status == ENGINE_NOT_INSTALLED)
		engine_id = 0xff;

	if (engine_id != 0xff) {
       		ret = gEngine_Info[engine_id]->so_methods->IME_Open(
					&gEngine_Info[engine_id]->core,
                                  	session_data->ime_buffer);
		
		log_f("IME_Open return :%d\n", ret);
		if (ret == -1)
			engine_id = 0xff;
	}

	session_data->paletteaux_status.engine_id = engine_id;
	le_status_draw(s);
}


