/* $Id: comp-misc.c,v 1.1.1.1 2002/08/31 04:18:04 himi Exp $ */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#if defined(lint) && defined(HAVE_NOTE_H)
#include <note.h>
#endif /* lint && HAVE_NOTE_H */

#include <iiimp-data.h>

#include "iiimp-dataP.h"
#include "print-misc.h"


IIIMP_card16_list *
iiimp_card16_list_new(
    IIIMP_data_s *		data_s,
    int				count,
    const IIIMP_card16 *	ptr)
{
    IIIMP_card16_list *	data;
    size_t		nbyte;

    if (0 == count) {
	data_s->status = IIIMP_DATA_NO_ERROR;
	return NULL;
    }

    data = (IIIMP_card16_list *)malloc(sizeof (IIIMP_card16_list));
    if (NULL == data) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    nbyte = (2 * count);

    data->nbyte = nbyte;
    data->count = count;

    nbyte = ((sizeof (IIIMP_card16)) * count);

    if (0 == count) {
	data->ptr = NULL;
    } else {
	data->ptr = (IIIMP_card16 *)malloc(nbyte);
	if (NULL == data->ptr) {
	    free(data);
	    data_s->status = IIIMP_DATA_MALLOC_ERROR;
	    return NULL;
	}
    }

    if (NULL != ptr) {
	(void)memcpy(data->ptr, ptr, nbyte);
    }

    return data;
}


void
iiimp_card16_list_delete(IIIMP_data_s * data_s, IIIMP_card16_list * data)
{
#if defined(lint) && defined(HAVE_NOTE_H)
    NOTE(ARGUNUSED(data_s))
#endif /* lint && HAVE_NOTE_H */
    if (NULL == data) return;
    free(data->ptr);
    free(data);
    return;
}


void
iiimp_card16_list_pack(
    IIIMP_data_s *	data_s,
    IIIMP_card16_list *	m,
    size_t *		nbyte,
    uchar_t **		ptr)
{
    uchar_t *	p;
    size_t	rest;
    int		i;

    if (NULL == m) return;

    rest = *nbyte;
    p = *ptr;

    for (i = 0; i < m->count; i++) {
	PUTU16(*(m->ptr + i), rest, p, data_s->byte_swap);
    }

    *nbyte = rest;
    *ptr = p;

    return;
}


IIIMP_card16_list *
iiimp_card16_list_unpack(
    IIIMP_data_s *	data_s,
    size_t *		nbyte,
    const uchar_t **	ptr,
    size_t		nbyte_max)
{
    IIIMP_card16_list *	data;
    const uchar_t *	p;
    size_t		rest;
    int			data_count;
    int			i;

    if (0 == nbyte_max) {
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    rest = nbyte_max;
    p = *ptr;

    if ((*nbyte < rest) || (0 != (nbyte_max & 0x01))) {
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    data_count = (nbyte_max / 2);

    data = (IIIMP_card16_list *)malloc(sizeof (IIIMP_card16_list));
    if (NULL == data) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    data->nbyte = (2 * data_count);
    data->count = data_count;

    data->ptr = (IIIMP_card16 *)malloc(nbyte_max);
    if (NULL == data->ptr) {
	iiimp_card16_list_delete(data_s, data);
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    for (i = 0; i < data_count; i++) {
	GETU16(*(data->ptr + i), rest, p, data_s->byte_swap);
    }

    *nbyte -= (nbyte_max - rest);
    *ptr += nbyte_max;

    return data;
}


void
iiimp_card16_list_print(
    IIIMP_data_s *	data_s,
    IIIMP_card16_list *	m)
{
    int	i;
    int	n;

    if (NULL == m) return;

    for (i = 0; i < m->count;) {
	(void)fprintf(data_s->print_fp, "%8d", i);
	for (n = 0; (n < 8) && (i < m->count); i++, n++) {
	    (void)fprintf(data_s->print_fp, " %04x", *(m->ptr + i));
	}
	(void)fputc('\n', data_s->print_fp);
    }
}


IIIMP_card32_list *
iiimp_card32_list_new(
    IIIMP_data_s *		data_s,
    int				count,
    const IIIMP_card32 *	ptr)
{
    IIIMP_card32_list *	data;
    size_t		nbyte;

    if (0 == count) {
	data_s->status = IIIMP_DATA_NO_ERROR;
	return NULL;
    }

    data = (IIIMP_card32_list *)malloc(sizeof (IIIMP_card32_list));
    if (NULL == data) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    nbyte = (4 * count);

    data->nbyte = (nbyte + PAD(nbyte));
    data->count = count;

    nbyte = ((sizeof (IIIMP_card32)) * count);

    if (0 == count) {
	data->ptr = NULL;
    } else {
	data->ptr = (IIIMP_card32 *)malloc(nbyte);
	if (NULL == data->ptr) {
	    free(data);
	    data_s->status = IIIMP_DATA_MALLOC_ERROR;
	    return NULL;
	}
    }

    if (NULL != ptr) {
	(void)memcpy(data->ptr, ptr, nbyte);
    }

    return data;
}


void
iiimp_card32_list_delete(IIIMP_data_s * data_s, IIIMP_card32_list * data)
{
#if defined(lint) && defined(HAVE_NOTE_H)
    NOTE(ARGUNUSED(data_s))
#endif /* lint && HAVE_NOTE_H */
    if (NULL == data) return;
    free(data->ptr);
    free(data);
    return;
}


void
iiimp_card32_list_pack(
    IIIMP_data_s *	data_s,
    IIIMP_card32_list *	m,
    size_t *		nbyte,
    uchar_t **		ptr)
{
    uchar_t *	p;
    size_t	rest;
    int		i;

    if (NULL == m) return;

    rest = *nbyte;
    p = *ptr;

    for (i = 0; i < m->count; i++) {
	PUTU32(*(m->ptr + i), rest, p, data_s->byte_swap);
    }

    *nbyte = rest;
    *ptr = p;

    return;
}


IIIMP_card32_list *
iiimp_card32_list_unpack(
    IIIMP_data_s *	data_s,
    size_t *		nbyte,
    const uchar_t **	ptr,
    size_t		nbyte_max)
{
    IIIMP_card32_list *	data;
    const uchar_t *	p;
    size_t		rest;
    int			data_count;
    int			i;

    if (0 == nbyte_max) {
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    rest = nbyte_max;
    p = *ptr;

    if ((*nbyte < rest) || (0 != (nbyte_max & 0x03))) {
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    data_count = (nbyte_max / 4);

    data = (IIIMP_card32_list *)malloc(sizeof (IIIMP_card32_list));
    if (NULL == data) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    data->count = data_count;

    data->ptr = (IIIMP_card32 *)malloc(nbyte_max);
    if (NULL == data->ptr) {
	iiimp_card32_list_delete(data_s, data);
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    for (i = 0; i < data_count; i++) {
	GETU32(*(data->ptr + i), rest, p, data_s->byte_swap);
    }

    *nbyte -= (nbyte_max - rest);
    *ptr += nbyte_max;

    return data;
}


void
iiimp_card32_list_print(
    IIIMP_data_s *	data_s,
    IIIMP_card32_list *	m)
{
    int	i;
    int	n;

    if (NULL == m) return;

    for (i = 0; i < m->count;) {
	(void)fprintf(data_s->print_fp, "%8d", i);
	for (n = 0; (n < 8) && (i < m->count); i++, n++) {
	    (void)fprintf(data_s->print_fp, " %08x", *(m->ptr + i));
	}
	(void)fputc('\n', data_s->print_fp);
    }
}


void
iiimp_byte_stream_print(
    IIIMP_data_s *	data_s,
    IIIMP_byte_stream *	m)
{
    int	i;
    int	n;

    if (NULL == m) return;

    for (i = 0; i < m->nbyte;) {
	(void)fprintf(data_s->print_fp, "%8d", i);
	for (n = 0; (n < 16) && (i < m->nbyte); i++, n++) {
	    (void)fprintf(data_s->print_fp, " %02x", *(m->ptr + i));
	}
	(void)fputc('\n', data_s->print_fp);
    }
}


void
iiimp_character_subsets_print(
    IIIMP_data_s *	data_s,
    IIIMP_card32 *	m)
{
    if (NULL == m) return;

    (void)fprintf(data_s->print_fp, "%s", character_subsets_string_get(*m));
}


void
iiimp_character_subsets_list_print(
    IIIMP_data_s *	data_s,
    IIIMP_card32_list *	m)
{
    int	i;

    if ((NULL == m) || (m->count <= 0)) return;

    iiimp_character_subsets_print(data_s, m->ptr);

    for (i = 1; i < m->count; i++) {
	(void)fputc(' ', data_s->print_fp);
	iiimp_character_subsets_print(data_s, m->ptr + i);
    }
}


IIIMP_status
iiimp_card16_list_create(
    IIIMP_data_s *		data_s,
    IIIMP_card16_list **	ptr_ret,
    int				count,
    const IIIMP_card16 *	ptr)
{
    *ptr_ret = iiimp_card16_list_new(data_s, count, ptr);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_card32_list_create(
    IIIMP_data_s *		data_s,
    IIIMP_card32_list **	ptr_ret,
    int				count,
    const IIIMP_card32 *	ptr)
{
    *ptr_ret = iiimp_card32_list_new(data_s, count, ptr);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_string_create(
    IIIMP_data_s *		data_s,
    IIIMP_string **		ptr_ret,
    size_t			len,
    const IIIMP_card16 *	ptr)
{
    *ptr_ret = iiimp_string_new(data_s, len, ptr);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_feedback_attr_list_create(
    IIIMP_data_s *		data_s,
    IIIMP_feedback_attr_list **	ptr_ret,
    int				count,
    const IIIMP_feedback_attr *	ptr)
{
    *ptr_ret = iiimp_feedback_attr_list_new(data_s, count, ptr);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_char_with_feedback_create(
    IIIMP_data_s *		data_s,
    IIIMP_char_with_feedback **	ptr_ret,
    IIIMP_card16		code,
    IIIMP_feedback_attr_list *	feedback_attr)
{
    *ptr_ret = iiimp_char_with_feedback_new(data_s, code, feedback_attr);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_operation_create(
    IIIMP_data_s *	data_s,
    IIIMP_operation **	ptr_ret,
    IIIMP_string *	id,
    size_t		value_nbyte,
    uchar_t *		value)
{
    *ptr_ret = iiimp_operation_new(data_s, id, value_nbyte, value);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_annotation_value_text_create(
    IIIMP_data_s *		data_s,
    IIIMP_annotation_value **	ptr_ret,
    IIIMP_int32			start_index,
    IIIMP_int32			end_index,
    IIIMP_text *		value)
{
    *ptr_ret = iiimp_annotation_value_text_new(data_s, start_index, end_index,
					       value);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_annotation_value_string_create(
    IIIMP_data_s *		data_s,
    IIIMP_annotation_value **	ptr_ret,
    IIIMP_int32			start_index,
    IIIMP_int32			end_index,
    IIIMP_string *		value)
{
    *ptr_ret = iiimp_annotation_value_string_new(data_s, start_index, end_index,
						 value);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_annotation_create(
    IIIMP_data_s *		data_s,
    IIIMP_annotation **		ptr_ret,
    IIIMP_card32		id,
    IIIMP_annotation_value *	value)
{
    *ptr_ret = iiimp_annotation_new(data_s, id, value);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_text_create(
    IIIMP_data_s *		data_s,
    IIIMP_text **		ptr_ret,
    IIIMP_char_with_feedback *	cwf,
    IIIMP_annotation *		anno)
{
    *ptr_ret = iiimp_text_new(data_s, cwf, anno);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_client_descriptor_create(
    IIIMP_data_s *		data_s,
    IIIMP_client_descriptor **	ptr_ret,
    IIIMP_string *		type,
    IIIMP_string *		os_name,
    IIIMP_string *		arch,
    IIIMP_string *		version,
    IIIMP_string *		X_display_name,
    IIIMP_string *		X_server_vendor)
{
    *ptr_ret = iiimp_client_descriptor_new(data_s,
					   type, os_name, arch, version,
					   X_display_name, X_server_vendor);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_object_descriptor_create(
    IIIMP_data_s *		data_s,
    IIIMP_object_descriptor **	ptr_ret,
    IIIMP_card16		category,
    IIIMP_card32		object_size,
    IIIMP_card16		id_pre,
    IIIMP_card16		id_dyn,
    IIIMP_string *		rdun,
    IIIMP_string *		hrn,
    IIIMP_string *		signature,
    IIIMP_string *		user)
{
    *ptr_ret = iiimp_object_descriptor_new(data_s, category, object_size,
					   id_pre, id_dyn, rdun, hrn,
					   signature, user);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_ccdef_create(
    IIIMP_data_s *	data_s,
    IIIMP_ccdef **	ptr_ret,
    IIIMP_string *	contents)
{
    *ptr_ret = iiimp_ccdef_new(data_s, contents);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_language_create(
    IIIMP_data_s *	data_s,
    IIIMP_language **	ptr_ret,
    IIIMP_string *	hrn,
    IIIMP_string *	id)
{
    *ptr_ret = iiimp_language_new(data_s, hrn, id);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_jarfile_object_create(
    IIIMP_data_s *		data_s,
    IIIMP_jarfile_object **	ptr_ret,
    IIIMP_string *		class_names,
    size_t			value_nbyte,
    uchar_t *			value)
{
    *ptr_ret = iiimp_jarfile_object_new(data_s, class_names, value_nbyte,
					value);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_inputmethod_descriptor_create(
    IIIMP_data_s *			data_s,
    IIIMP_inputmethod_descriptor **	ptr_ret,
    IIIMP_card16			id,
    IIIMP_string *			rdun,
    IIIMP_string *			hrn,
    IIIMP_language *			language)
{
    *ptr_ret = iiimp_inputmethod_descriptor_new(data_s, id, rdun, hrn,
						language);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_binaryfile_object_create(
    IIIMP_data_s *		data_s,
    IIIMP_binaryfile_object **	ptr_ret,
    IIIMP_string *		object)
{
    *ptr_ret = iiimp_binaryfile_object_new(data_s, object);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_imattribute_inputmethod_descriptor_create(
    IIIMP_data_s *			data_s,
    IIIMP_imattribute **		ptr_ret,
    IIIMP_card16			id,
    IIIMP_card16			id_dyn,
    IIIMP_inputmethod_descriptor *	value)
{
    *ptr_ret = iiimp_imattribute_inputmethod_descriptor_new(data_s, id, id_dyn,
							    value);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_imattribute_object_descriptor_create(
    IIIMP_data_s *		data_s,
    IIIMP_imattribute **	ptr_ret,
    IIIMP_card16		id,
    IIIMP_card16		id_dyn,
    IIIMP_object_descriptor *	value)
{
    *ptr_ret = iiimp_imattribute_object_descriptor_new(data_s, id, id_dyn,
						       value);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_imattribute_client_descriptor_create(
    IIIMP_data_s *		data_s,
    IIIMP_imattribute **	ptr_ret,
    IIIMP_card16		id,
    IIIMP_card16		id_dyn,
    IIIMP_client_descriptor *	value)
{
    *ptr_ret = iiimp_imattribute_client_descriptor_new(data_s, id, id_dyn,
						       value);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_imattribute_ccdef_create(
    IIIMP_data_s *		data_s,
    IIIMP_imattribute **	ptr_ret,
    IIIMP_card16		id,
    IIIMP_card16		id_dyn,
    IIIMP_ccdef *		value)
{
    *ptr_ret = iiimp_imattribute_ccdef_new(data_s, id, id_dyn, value);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_imattribute_jar_gui_object_create(
    IIIMP_data_s *		data_s,
    IIIMP_imattribute **	ptr_ret,
    IIIMP_card16		id,
    IIIMP_card16		id_dyn,
    IIIMP_jarfile_object *	value)
{
    *ptr_ret = iiimp_imattribute_jar_gui_object_new(data_s, id, id_dyn, value);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_imattribute_jar_light_weight_engine_object_create(
    IIIMP_data_s *		data_s,
    IIIMP_imattribute **	ptr_ret,
    IIIMP_card16		id,
    IIIMP_card16		id_dyn,
    IIIMP_jarfile_object *	value)
{
    *ptr_ret = iiimp_imattribute_jar_light_weight_engine_object_new(data_s, id,
								    id_dyn,
								    value);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_imattribute_binary_gui_object_create(
    IIIMP_data_s *		data_s,
    IIIMP_imattribute **	ptr_ret,
    IIIMP_card16		id,
    IIIMP_card16		id_dyn,
    IIIMP_binaryfile_object *	value)
{
    *ptr_ret = iiimp_imattribute_binary_gui_object_new(data_s, id, id_dyn,
						       value);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_imattribute_binary_light_weight_engine_create(
    IIIMP_data_s *		data_s,
    IIIMP_imattribute **	ptr_ret,
    IIIMP_card16		id,
    IIIMP_card16		id_dyn,
    IIIMP_binaryfile_object *	value)
{
    *ptr_ret = iiimp_imattribute_binary_light_weight_engine_new(data_s, id,
								id_dyn, value);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_imattribute_script_gui_object_create(
    IIIMP_data_s *		data_s,
    IIIMP_imattribute **	ptr_ret,
    IIIMP_card16		id,
    IIIMP_card16		id_dyn,
    IIIMP_binaryfile_object *	value)
{
    *ptr_ret = iiimp_imattribute_script_gui_object_new(data_s, id, id_dyn,
						       value);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_imattribute_script_light_weight_engine_create(
    IIIMP_data_s *		data_s,
    IIIMP_imattribute **	ptr_ret,
    IIIMP_card16		id,
    IIIMP_card16		id_dyn,
    IIIMP_binaryfile_object *	value)
{
    *ptr_ret = iiimp_imattribute_script_light_weight_engine_new(data_s, id,
								id_dyn, value);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_icattribute_input_language_create(
    IIIMP_data_s *		data_s,
    IIIMP_icattribute **	ptr_ret,
    IIIMP_string *		value)
{
    *ptr_ret = iiimp_icattribute_input_language_new(data_s, value);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_icattribute_character_subsets_create(
    IIIMP_data_s *		data_s,
    IIIMP_icattribute **	ptr_ret,
    IIIMP_card32_list *		value)
{
    *ptr_ret = iiimp_icattribute_character_subsets_new(data_s, value);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_icattribute_input_method_name_create(
    IIIMP_data_s *		data_s,
    IIIMP_icattribute **	ptr_ret,
    IIIMP_string *		value)
{
    *ptr_ret = iiimp_icattribute_input_method_name_new(data_s, value);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_icattribute_input_method_create(
    IIIMP_data_s *		data_s,
    IIIMP_icattribute **	ptr_ret,
    IIIMP_card16		value)
{
    *ptr_ret = iiimp_icattribute_input_method_new(data_s, value);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_keyevent_list_create(
    IIIMP_data_s *		data_s,
    IIIMP_keyevent_list **	ptr_ret,
    int				count,
    IIIMP_keyevent *		k)
{
    *ptr_ret = iiimp_keyevent_list_new(data_s, count, k);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_contents_string_create(
    IIIMP_data_s *	data_s,
    IIIMP_contents **	ptr_ret,
    IIIMP_string *	value)
{
    *ptr_ret = iiimp_contents_string_new(data_s, value);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_contents_text_create(
    IIIMP_data_s *	data_s,
    IIIMP_contents **	ptr_ret,
    IIIMP_text *	value)
{
    *ptr_ret = iiimp_contents_text_new(data_s, value);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


IIIMP_status
iiimp_contents_keyevent_list_create(
    IIIMP_data_s *		data_s,
    IIIMP_contents **		ptr_ret,
    IIIMP_keyevent_list *	value)
{
    *ptr_ret = iiimp_contents_keyevent_list_new(data_s, value);
    return ((NULL == *ptr_ret) ? data_s->status : IIIMP_DATA_NO_ERROR);
}


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
