/* $Id: print-misc.c,v 1.1.1.1 2002/08/31 04:18:07 himi Exp $ */


#include <iiimp-data.h>
#include <iiimp-opcode.h>

#include "print-misc.h"


typedef struct {
    int	id;
    char *	string;
} id_string_pair;

static id_string_pair opcode_string[] = {
	{0,				"IM_NOP (0)"},

	{IM_CONNECT,			"IM_CONNECT"},
	{IM_CONNECT_REPLY,		"IM_CONNECT_REPLY"},
	{IM_DISCONNECT,			"IM_DISCONNECT"},
	{IM_DISCONNECT_REPLY	,	"IM_DISCONNECT_REPLY"},
	{IM_REGISTER_TRIGGER_KEYS,	"IM_REGISTER_TRIGGER_KEYS"},
	{IM_TRIGGER_NOTIFY,		"IM_TRIGGER_NOTIFY"},
	{IM_TRIGGER_NOTIFY_REPLY,	"IM_TRIGGER_NOTIFY_REPLY"},
	{IM_SETIMVALUES,		"IM_SETIMVALUES"},
	{IM_SETIMVALUES_REPLY,		"IM_SETIMVALUES_REPLY"},
	{IM_GETIMVALUES,		"IM_GETIMVALUES"},
	{IM_GETIMVALUES_REPLY,		"IM_GETIMVALUES_REPLY"},

	{IM_FORWARD_EVENT,		"IM_FORWARD_EVENT"},
	{IM_FORWARD_EVENT_REPLY,	"IM_FORWARD_EVENT_REPLY"},
	{IM_COMMIT_STRING,		"IM_COMMIT_STRING"},
	{IM_FORWARD_EVENT_WITH_OPERATIONS,
					"IM_FORWARD_EVENT_WITH_OPERATIONS"},
	{IM_FORWARD_EVENT_WITH_OPERATIONS_REPLY,
					"IM_FORWARD_EVENT_WITH_OPERATIONS_REPLY"},

	{17,				"IM_NOP (17)"},
	{18,				"IM_NOP (18)"},
	{19,				"IM_NOP (19)"},

	{IM_CREATEIC,			"IM_CREATEIC"},
	{IM_CREATEIC_REPLY,		"IM_CREATEIC_REPLY"},
	{IM_DESTROYIC,			"IM_DESTROYIC"},
	{IM_DESTROYIC_REPLY,		"IM_DESTROYIC_REPLY"},
	{IM_SETICVALUES,		"IM_SETICVALUES"},
	{IM_SETICVALUES_REPLY,		"IM_SETICVALUES_REPLY"},
	{IM_GETICVALUES,		"IM_GETICVALUES"},
	{IM_GETICVALUES_REPLY,		"IM_GETICVALUES_REPLY"},
	{IM_SETICFOCUS,			"IM_SETICFOCUS"},
	{IM_SETICFOCUS_REPLY,		"IM_SETICFOCUS_REPLY"},
	{IM_UNSETICFOCUS,		"IM_UNSETICFOCUS"},
	{IM_UNSETICFOCUS_REPLY,		"IM_UNSETICFOCUS_REPLY"},
	{IM_RESETIC,			"IM_RESETIC"},
	{IM_RESETIC_REPLY,		"IM_RESETIC_REPLY"},

	{34,				"IM_NOP (34)"},
	{35,				"IM_NOP (35)"},
	{36,				"IM_NOP (36)"},
	{37,				"IM_NOP (37)"},
	{38,				"IM_NOP (38)"},
	{39,				"IM_NOP (39)"},

	{IM_PREEDIT_START,		"IM_PREEDIT_START"},
	{IM_PREEDIT_START_REPLY,	"IM_PREEDIT_START_REPLY"},
	{IM_PREEDIT_DRAW,		"IM_PREEDIT_DRAW"},
	{IM_PREEDIT_DRAW_REPLY,		"IM_PREEDIT_DRAW_REPLY"},
	{44,				"IM_NOP (44)"},
	{45,				"IM_NOP (45)"},
	{IM_PREEDIT_DONE,		"IM_PREEDIT_DONE"},
	{IM_PREEDIT_DONE_REPLY,		"IM_PREEDIT_DONE_REPLY"},

	{48,				"IM_NOP (48)"},
	{49,				"IM_NOP (49)"},

	{IM_STATUS_START,		"IM_STATUS_START"},
	{IM_STATUS_START_REPLY,		"IM_STATUS_START_REPLY"},
	{IM_STATUS_DRAW,		"IM_STATUS_DRAW"},
	{IM_STATUS_DRAW_REPLY,		"IM_STATUS_DRAW_REPLY"},
	{IM_STATUS_DONE,		"IM_STATUS_DONE"},
	{IM_STATUS_DONE_REPLY,		"IM_STATUS_DONE_REPLY"},

	{56,				"IM_NOP (56)"},
	{57,				"IM_NOP (57)"},
	{58,				"IM_NOP (58)"},
	{59,				"IM_NOP (59)"},
	{60,				"IM_NOP (60)"},
	{61,				"IM_NOP (61)"},
	{62,				"IM_NOP (62)"},
	{63,				"IM_NOP (63)"},
	{64,				"IM_NOP (64)"},
	{65,				"IM_NOP (65)"},
	{66,				"IM_NOP (66)"},
	{67,				"IM_NOP (67)"},
	{68,				"IM_NOP (68)"},
	{69,				"IM_NOP (69)"},

	{IM_LOOKUP_CHOICE_START,	"IM_LOOKUP_CHOICE_START"},
	{IM_LOOKUP_CHOICE_START_REPLY,
					"IM_LOOKUP_CHOICE_START_REPLY"},
	{IM_LOOKUP_CHOICE_DRAW,		"IM_LOOKUP_CHOICE_DRAW"},
	{IM_LOOKUP_CHOICE_DRAW_REPLY,	"IM_LOOKUP_CHOICE_DRAW_REPLY"},
	{IM_LOOKUP_CHOICE_DONE,		"IM_LOOKUP_CHOICE_DONE"},
	{IM_LOOKUP_CHOICE_DONE_REPLY,	"IM_LOOKUP_CHOICE_DONE_REPLY"},
	{IM_LOOKUP_CHOICE_PROCESS,	"IM_LOOKUP_CHOICE_PROCESS"},
	{IM_LOOKUP_CHOICE_PROCESS_REPLY,"IM_LOOKUP_CHOICE_PROCESS_REPLY"},

	{78,				"IM_NOP (78)"},
	{79,				"IM_NOP (79)"},
	{80,				"IM_NOP (80)"},
	{81,				"IM_NOP (81)"},
	{82,				"IM_NOP (82)"},
	{83,				"IM_NOP (83)"},
	{84,				"IM_NOP (84)"},
	{85,				"IM_NOP (85)"},
	{86,				"IM_NOP (86)"},
	{87,				"IM_NOP (87)"},
	{88,				"IM_NOP (88)"},
	{89,				"IM_NOP (89)"},

	{IM_AUX_START,			"IM_AUX_START"},
	{IM_AUX_START_REPLY,		"IM_AUX_START_REPLY"},
	{IM_AUX_DRAW,			"IM_AUX_DRAW"},
	{IM_AUX_DRAW_REPLY,		"IM_AUX_DRAW_REPLY"},
	{IM_AUX_DONE,			"IM_AUX_DONE"},
	{IM_AUX_DONE_REPLY,		"IM_AUX_DONE_REPLY"},
	{IM_AUX_SETVALUES,		"IM_AUX_SETVALUES"},
	{IM_AUX_SETVALUES_REPLY,	"IM_AUX_SETVALUES_REPLY"},

	{98,				"IM_NOP (98)"},
	{99,				"IM_NOP (99)"},
	{100,				"IM_NOP (100)"},
	{101,				"IM_NOP (101)"},
	{102,				"IM_NOP (102)"},
	{103,				"IM_NOP (103)"},
	{104,				"IM_NOP (104)"},
	{105,				"IM_NOP (105)"},
	{106,				"IM_NOP (106)"},
	{107,				"IM_NOP (107)"},
	{108,				"IM_NOP (108)"},
	{109,				"IM_NOP (109)"},
	{110,				"IM_NOP (110)"},
	{111,				"IM_NOP (111)"},
	{112,				"IM_NOP (112)"},
	{113,				"IM_NOP (113)"},
	{114,				"IM_NOP (114)"},
	{115,				"IM_NOP (115)"},
	{116,				"IM_NOP (116)"},
	{117,				"IM_NOP (117)"},
	{118,				"IM_NOP (118)"},
	{119,				"IM_NOP (119)"},
	{120,				"IM_NOP (120)"},
	{121,				"IM_NOP (121)"},
	{122,				"IM_NOP (122)"},
	{123,				"IM_NOP (123)"},
	{124,				"IM_NOP (124)"},
	{125,				"IM_NOP (125)"},
	{126,				"IM_NOP (126)"},
	{127,				"IM_NOP (127)"},
};


#define FEEDBACK_NUM (3)
static char *	feedback_string[] = {
	"Normal",
	"Reverse",
	"Underline",
	"Undefined"
};


#define OBJECT_DESCRIPTOR_CATEGORY_NUM	(5)
static char *	object_descriptor_category_string[] = {
	"GUI",
	"LWE",
	"Syntax Rule",
	"IM Manager rule",
	"Preloading LWE",
	"unknown"
};

static id_string_pair annotation_id_string[] = {
	{IIIMP_ANNOTATION_TEXT_INPUT_BEFORE_CONVERSION,
						"text input before conversion"},
	{IIIMP_ANNOTATION_READING_OF_THE_TEXT,	"reading of the text"},
	{IIIMP_ANNOTATION_TYPE_OF_SPEECH,	"type of speech"},
	{IIIMP_ANNOTATION_TYPE_OF_CLAUSE,	"type of clause"},
	{0x00,					"invalid"}
};

static id_string_pair	imattribute_id_string[] = {
	{IIIMP_IMATTRIBUTE_INPUT_METHOD_LIST,
					"Input Method List"},
	{IIIMP_IMATTRIBUTE_OBJECT_DESCRIPTOR_LIST,
					"Object Descriptor List"},
	{IIIMP_IMATTRIBUTE_CLIENT_DESCRIPTOR,
					"Client Descriptor"},
	{IIIMP_IMATTRIBUTE_CHARACTER_CONVERSION_DEFINITION_RULE,
					"Character Conversion Definition Rule"},
	{IIIMP_IMATTRIBUTE_JAR_GUI_OBJECT,
					"Jar GUI Object"},
	{IIIMP_IMATTRIBUTE_JAR_LIGHT_WEIGHT_ENGINE_OBJECT,
					"Jar Light Weight Engine Object"},
	{IIIMP_IMATTRIBUTE_BINARY_GUI_OBJECT,
					"Binary GUI Object"},
	{IIIMP_IMATTRIBUTE_BINARY_LIGHT_WEIGHT_ENGINE_OBJECT,
					"Binary Light Weight Engine Object"},
	{IIIMP_IMATTRIBUTE_SCRIPT_GUI_OBJECT,
					"SCRIPT GUI Object"},
	{IIIMP_IMATTRIBUTE_SCRIPT_LIGHT_WEIGHT_ENGINE_OBJECT,
					"SCRIPT Light Weight Engine Object"},
	{0x0000,			"undefined"},
};

static id_string_pair	icattribute_id_string[] = {
	{IIIMP_ICATTRIBUTE_INPUT_LANGUAGE,	"Input Language"},
	{IIIMP_ICATTRIBUTE_CHARACTER_SUBSETS,	"Character Subsets"},
	{IIIMP_ICATTRIBUTE_INPUT_METHOD_NAME,	"Input Method Name"},
	{IIIMP_ICATTRIBUTE_INPUT_METHOD,	"Input Method"},
	{0x00,					"undefined"}
};

static id_string_pair lookup_choice_master_string[] = {
	{IM_LOOKUP_CHOICE_START_SERVER_IS_MASTER, "ServerIsMaster"},
	{IM_LOOKUP_CHOICE_START_CLIENT_IS_MASTER, "ClientIsMaster"},
	{IM_LOOKUP_CHOICE_START_UNKNOWN_IS_MASTER,"UnknownIsMaster"}
};


static id_string_pair lookup_choice_direction_string[] = {
	{IM_LOOKUP_CHOICE_START_DRAWING_UP_HORIZONTALLY,	"Horizontal "},
	{IM_LOOKUP_CHOICE_START_DRAWING_UP_VERTICALLY,		"Vertical "},
	{-1,							"Unknown "}
};

static id_string_pair lookup_choice_label_owner_string[] = {
	{IM_LOOKUP_CHOICE_START_SERVER_OWNS_LABEL,	"ServerOwnsLabel"},
	{IM_LOOKUP_CHOICE_START_CLIENT_OWNS_LABEL,	"ClientOwnsLabel"},
	{-1,						"UnknownOwnsLabel"}
};

static id_string_pair lookup_choice_process_page_string[] = {
	{IM_LOOKUP_CHOICE_PROCESS_PAGE_NEXT_PAGE,	"NEXT_PAGE"},
	{IM_LOOKUP_CHOICE_PROCESS_PAGE_PREV_PAGE,	"PREV_PAGE"},
	{IM_LOOKUP_CHOICE_PROCESS_PAGE_FIRST_PAGE,	"FIRST_PAGE"},
	{IM_LOOKUP_CHOICE_PROCESS_PAGE_LAST_PAGE,	"LAST_PAGE"},
	{0,						"NO_PAGE"}
};


#define CHARACTER_SUBSETS_STRING_NUM	(73)
static char *	character_subsets_string[] = {
	"undefined(0)",
	"BASIC_LATIN",
	"LATIN_1_SUPPLEMENT",
	"LATIN_EXTENDED_A",
	"LATIN_EXTENDED_B",
	"IPA_EXTENTIONS",
	"SPACING_MODIFIER_LETTERS",
	"COMBINING_DIACRITICAL_MARKS",
	"GREEK",
	"CYRILLIC",
	"ARMENIAN",
	"HEBREW",
	"ARABIC",
	"DEVANAGARI",
	"BENGALI",
	"GURMUKHI",
	"GUJARATI",
	"ORIYA",
	"TAMIL",
	"TELUGU",
	"KANNADA",
	"MALAYALAM",
	"THAI",
	"LAO",
	"TIBETAN",
	"GEORGIAN",
	"HANGUL_JAMO",
	"LATIN_EXTENDED_ADDITIONAL",
	"GREEK_EXTENDED",
	"GENERAL_PUNCTUATION",
	"SUPERSCRIPTS_AND_SUBSCRIPTS",
	"CURRENCY_SYMBOLS",
	"COMBINING_MARKS_FOR_SYMBOLS",
	"LETTERLIKE_SYMBOLS",
	"NUMBER_FORMS",
	"ARROWS",
	"MATHEMATICAL_OPERATORS",
	"MISCELLANEOUS_TECHNICAL",
	"CONTROL_PICTURES",
	"OPTICAL_CHARACTER_RECOGNITION",
	"ENCLOSED_ALPHANUMERICS",
	"BOX_DRAWING",
	"BLOCK_ELEMENTS",
	"GEOMETRIC_SHAPES",
	"MISCELLANEOUS_SYMBOLS",
	"DINGBATS",
	"CJK_SYMBOLS_AND_PUNCTUATION",
	"HIRAGANA",
	"KATAKANA",
	"BOPOMOFO",
	"HANGUL_COMPATIBILITY_JAMO",
	"KANBUN",
	"ENCLOSED_CJK_LETTERS_AND_MONTHS",
	"CJK_COMPATIBILITY",
	"CJK_UNIFIED_IDEOGRAPHS",
	"HANGUL_SYLLABLES",
	"SURROGATES_AREA",
	"PRIVATE_USE_AREA",
	"CJK_COMPATIBILITY_IDEOGRAPHS",
	"ALPHABETIC_PRESENTATION_FORMS",
	"ARABIC_PRESENTATION_FORMS_A",
	"COMBINING_HALF_MARKS",
	"CJK_COMPATIBILITY_FORMS",
	"SMALL_FORM_VARIANTS",
	"ARABIC_PRESENTATION_FORMS_B",
	"HALFWIDTH_AND_FULLWIDTH_FORMS",
	"SPECIALS",
	"LATIN",
	"LATIN_DIGITS",
	"TRADITIONAL_HANZI",
	"SIMPLIFIED_HANZI",
	"KANJI",
	"HANJA",
	"HALFWIDTH_KATAKANA",
};


const char *
opcode_string_get(int num)
{
    return opcode_string[0x7f & num].string;
}


const char *
feedback_string_get(int num)
{
    if ((num < 0) || (FEEDBACK_NUM < num)) {
	num = FEEDBACK_NUM;
    }
    return feedback_string[num];
}


const char *
object_descriptor_category_string_get(int num)
{
    if ((num < 0) || (OBJECT_DESCRIPTOR_CATEGORY_NUM < num)) {
	num = OBJECT_DESCRIPTOR_CATEGORY_NUM;
    }
    return object_descriptor_category_string[num];
}


static const char *
id_string_pair_search(id_string_pair * p, int key, int key_stop)
{
    for (; (key != p->id) && (key_stop != p->id); p++) {}
    return p->string;
}


const char *
annotation_id_string_get(int num)
{
    return id_string_pair_search(annotation_id_string, num, 0);
}


const char *
imattribute_id_string_get(int num)
{
    return id_string_pair_search(imattribute_id_string, num, 0);
}


const char *
icattribute_id_string_get(int num)
{
    return id_string_pair_search(icattribute_id_string, num, 0);
}


const char *
lookup_choice_master_string_get(int num)
{
    return id_string_pair_search(lookup_choice_master_string, num, 0);
}


const char *
lookup_choice_direction_string_get(int num)
{
    return id_string_pair_search(lookup_choice_direction_string, num, -1);
}


const char *
lookup_choice_label_owner_string_get(int num)
{
    return id_string_pair_search(lookup_choice_label_owner_string, num, -1);
}


const char *
lookup_choice_process_page_string_get(int num)
{
    return id_string_pair_search(lookup_choice_process_page_string, num, 0);
}


const char *
character_subsets_string_get(int num)
{
    if ((num < 0) || (CHARACTER_SUBSETS_STRING_NUM < num)) {
	num = 0;
    }
    return character_subsets_string[num];
}


const char *
iiimp_opcode_string(int num)
{
    return opcode_string[0x7f & num].string;
}


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
