/*
 * Copyright 1998 by Sun Microsystems, Inc., 901 San Antonio Road,
 * Palo Alto, California, 94303, U.S.A. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered
 * into with Sun.
 */

#ifndef SUNIMPROT_H
#define SUNIMPROT_H

#ifndef Private
#define Private static
#define Public	/**/
#endif	/* Private */

/*
 * This is for public_status in iml_session_t/status in IC. Used by
 * IML_SET_STATUS/IML_GET_STATUS
 */
typedef int iml_status_t;

#define IMLSTATUS_Henkan_Mode                 0x00000001
#define IMLSTATUS_Mode_switch                 0x00000002
#define IMLSTATUS_Backfront                   0x00000004	/* if 1, backend */
#define IMLSTATUS_Backfront_Recommendation    0x00000008	/* if 1, backend */

/* ------------------------------------------------------------ */

/*
 * IML to IMM opcode
 */
typedef unsigned int IMM_Opcode;

#define IMM_NOP                  0	/* Nop */

#define IMM_RESET                1	/* Reset the IC */

#define IMM_COMMIT               2	/* Returning a committed
					 * string */

#define IMM_SET_STATUS           3	/* iml status i.e.ConvOn/off
					 * kana etc.. */

#define IMM_PREEDIT_START        4	/* Call the preedit_start
					 * callback */

#define IMM_PREEDIT_DRAW         5	/* Call the preedit_draw
					 * callback */

#define IMM_PREEDIT_CARET        6	/* Call the preedit_caret
					 * callback */

#define IMM_PREEDIT_DONE         7	/* Call the preedit_done call
					 * back */

#define IMM_LOOKUP_START         8	/* Call the lookup_start
					 * callback */

#define IMM_LOOKUP_DRAW          9	/* Call the lookup_draw
					 * callback */

#define IMM_LOOKUP_PROCESS      10	/* Call the lookup_process
					 * callback */

#define IMM_LOOKUP_DONE         11	/* Call the lookup_done
					 * callback */

#define IMM_KEY_INFO            12	/* Return the key that
					 * corresponds to */
/* specified function */
/* operand : keymaps_t */
#define IMM_PUT_QUEUE           13	/* Put the string back to X
					 * queue */

#define IMM_STATUS_START        14	/* Call the status_start
					 * callback */

#define IMM_STATUS_DRAW         15	/* Call the status_draw
					 * callback */

#define IMM_STATUS_DONE         16	/* Call the status_done
					 * callback */

#define IMM_KEYPRESS            17	/* Return X event to the
					 * client */

#define IMM_RESET_RETURN        18	/* same as commit */

#define IMM_AUX_START_2		20	/* Call the aux_start
					 * callback */

#define IMM_AUX_DRAW_2		21	/* Call the aux_draw callback */

#define IMM_AUX_DONE_2		22	/* Call the aux_done callback */

#define IMM_OBJECTDOWNLOADING	23	/* Call the aux_done callback */

#define MAX_IMM_OPCODE          24	/* maximam opcode value */

#define IMM_CB_RESULT_REQUIRED  0x10000000

/*
 * iml_inst structure
 */
typedef struct _iml_inst {
    struct _iml_inst *next;
    int size_of_operand;
    IMM_Opcode opcode;
    char *operand;
}   iml_inst;

#endif /* SUNIMPROT_H */
