/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>
#include <glib.h>
#include <signal.h>
#include <wait.h>
#include <sys/types.h>

#include <gdk/gdk.h>
#include <gtk/gtk.h>

#include "imlabel.h"

#include "pixmap.h"
#include "hzinput.h"

GtkWidget     *pcaux_main_window = NULL;
ImLabel       *pcaux_preedit_area = NULL;
GtkLabel      *pcaux_candidate_area = NULL;

int            mouse_draging = 0;
int            pcaux_main_window_drag_x = 0;
int            pcaux_main_window_drag_y = 0;
int            pcaux_main_window_pos_x = 0;
int            pcaux_main_window_pos_y = 0;

int            main_window_showing = 1;
int            NullPreedit = 0;
int            NullCandidate = 0;

static int PCAUX_RGB_COLORS[256] = {
    0x000000, 0x000080, 0x000080, 0x000080, 0x000080, 0x008000, 0x008000,
    0x0000FF, 0x800000,
    0x000000, 0x008000, 0x000080, 0x000080
};

extern GdkFilterReturn xaux_ext_event_handler(GdkXEvent *gdk_xevent, GdkEvent *event, gpointer user_data);

static int
isSameDecoration(IMCharDecoration a, IMCharDecoration b)
{
    return (PCAUX_RGB_COLORS[a.fgcolor_idx] == PCAUX_RGB_COLORS[b.fgcolor_idx] &&
            PCAUX_RGB_COLORS[a.bgcolor_idx] == PCAUX_RGB_COLORS[b.bgcolor_idx] &&
            a.underline == b.underline)?1:0;
}

static char*
WriteDstStr(char* dst, const char* src)
{
    if (dst && src)
        while (*src) *dst++ = *src++;
    return dst;
}

static char*
WriteDstColor(char* dst, int color)
{
    *dst++ = '#';
    sprintf(dst, "%02X%02X%02X", (color>>16) & 0xFF, (color>>8) & 0xFF, color & 0xFF);
    return (dst + 6);
    //return WriteDstStr(dst, "blue");
}

static char*
PopupDecoration(char* dst, IMCharDecoration deco)
{
    if (deco.fgcolor_idx != 0 || deco.bgcolor_idx != 0 || deco.underline != 0)
        return WriteDstStr(dst, "</span>");
    return dst;
}

static char*
writeMark(char *dst, int markType)
{
    dst = WriteDstStr(dst, "<span foreground=\"");
    dst = WriteDstColor(dst, PCAUX_RGB_COLORS[CA_COLOR_LKP_MARK]);
    dst = WriteDstStr(dst, "\">");
    *dst++ = (char)markType;
    *dst++ = '.';
    dst = WriteDstStr(dst, "</span>");
}

static char*
PushDecoration(char* dst, IMCharDecoration deco)
{
    static const char* str_span_start = "<span";
    static const char* str_array_uline[] = {
        "none", "single", "double", "low",
        "none", "none", "none", "none"
    };

    int sspan = 0;

    if (deco.fgcolor_idx == 0 && deco.bgcolor_idx == 0 && deco.underline == 0)
        return dst;

    if (deco.fgcolor_idx != 0) {
        if (sspan == 0) {
            sspan = 1;
            dst = WriteDstStr(dst, str_span_start);
        }
        dst = WriteDstStr(dst, " foreground=\"");
        dst = WriteDstColor(dst, PCAUX_RGB_COLORS[deco.fgcolor_idx]);
        dst = WriteDstStr(dst, "\"");
    }
    if (deco.bgcolor_idx != 0) {
        if (sspan == 0) {
            sspan = 1;
            dst = WriteDstStr(dst, str_span_start);
        }
        dst = WriteDstStr(dst, " background=\"");
        dst = WriteDstColor(dst, PCAUX_RGB_COLORS[deco.bgcolor_idx]);
        dst = WriteDstStr(dst, "\"");
    }
    if (deco.underline != 0) {
        if (sspan == 0) {
            sspan = 1;
            dst = WriteDstStr(dst, str_span_start);
        }
        dst = WriteDstStr(dst, " underline=\"");
        dst = WriteDstStr(dst, str_array_uline[deco.underline]);
        dst = WriteDstStr(dst, "\"");
    }

    if (sspan)
        *dst++ = '>';

    return dst;
}

static char *
parseDeco(const char* str, int deco_len, IMCharDecoration* decoration, char*dst)
{
    int i, same;
    const char *pnext;
    IMCharDecoration cur_deco, zero_deco;

    if (str) {
        memset(&cur_deco, 0, sizeof(IMCharDecoration));
        memset(&zero_deco, 0, sizeof(IMCharDecoration));

        for (i=0; *str && i < deco_len && decoration; ++i) {
            decoration[i].bgcolor_idx = 0;
            same = isSameDecoration(cur_deco, decoration[i]);
            if (!same) {
                dst = PopupDecoration(dst, cur_deco);
                dst = PushDecoration(dst, decoration[i]);
                cur_deco = decoration[i];
            }

            //FIXME, maybe we need to esacpe '<', '&'...
            pnext = g_utf8_offset_to_pointer(str, 1);
            while (str != pnext)
                *dst++ = *str++;
        }
        dst = PopupDecoration(dst, cur_deco);

        //FIXME, maybe we need to esacpe '<', '&'...
        while (*str)  *dst++ = *str++;
    }
    *dst = 0;

    return dst;
}

void PCAuxShow(void)
{
    if (pcaux_main_window && main_window_showing == 0)
        gtk_widget_show_all(pcaux_main_window);
    main_window_showing = 1;
}

void PCAuxHide(void)
{
    if (pcaux_main_window && main_window_showing)
        gtk_widget_hide(pcaux_main_window);
    main_window_showing = 0;
}


static void ShowHideMainWindow(void)
{
    int toShow = (!NullPreedit || !NullCandidate)?1:0;
    if (toShow != main_window_showing) {
        if (toShow)
            gtk_widget_show_all(pcaux_main_window);
        else
            gtk_widget_hide(pcaux_main_window);
        main_window_showing = toShow;
    }
}

void setPreeditText(const char*str, int deco_len, IMCharDecoration* decoration)
{
    char *markup_str = (char*)malloc(256*1024);

    DEBUG_printf("====> set Preedit text:%s\n", (str)?str:"");
    DEBUG_printf("      %d decorations:", deco_len);
    if (decoration) {
        int i;
        for (i=0; i < deco_len; ++i) {
            DEBUG_printf("[%d-%d-%d] ", decoration[i].fgcolor_idx, decoration[i].bgcolor_idx, decoration[i].underline);
        }
    }
    DEBUG_printf("\n");

    parseDeco(str, deco_len, decoration, markup_str);
    DEBUG_printf("    ---->markup_str:%s\n", markup_str);
    im_label_set_text(pcaux_preedit_area, markup_str);

    NullPreedit = (*markup_str == 0)?1:0;
    ShowHideMainWindow();

    free(markup_str);
}

void setIMLabelCaret(int caret)
{
    im_label_set_caret_index(pcaux_preedit_area, caret);
}

//At least, nCandi != 0 ==> str != NULL, deco_ptrs != NULL, deco_lens != NULL
void setCandidateStrings(int nCandi, int markType, const char**str, int *deco_lens, IMCharDecoration** deco_ptrs)
{
    int  i, markChar;
    char *dst;
    char *markup_str = (char*)malloc(256*1024);
    char *label_str = NUMERIC_LABEL_LIST_STR;

    switch (markType) {
        case NUMERIC0_LABEL:
		label_str = NUMERIC0_LABEL_LIST_STR;
		break; 
        case NUMERIC_LABEL:
		label_str = NUMERIC_LABEL_LIST_STR;
		break; 
        case LOWER_LABEL:
		label_str = LOWER_LABEL_LIST_STR;
		break; 
        case UPPER_LABEL:
		label_str = UPPER_LABEL_LIST_STR;
		break; 
    }

    DEBUG_printf("====> set Candidate text: %d candidates\n", nCandi);

    for (i=0; i < nCandi; ++i)
        DEBUG_printf("     [%s] --> %d deco\n", (str && str[i])?str[i]:"XXX", (deco_lens)?deco_lens[i]:0);

    dst = markup_str;
    for (i=0; i < nCandi; ++i) {
        markChar = *((char *)label_str + i);
        dst = writeMark(dst, markChar);
        dst = parseDeco(str[i], deco_lens[i], deco_ptrs[i], dst);
        *dst++ = ' ';
    }
    *dst = 0;
    DEBUG_printf("    ---->markup_str:%s\n", markup_str);
    gtk_label_set_markup(pcaux_candidate_area, markup_str);

    NullCandidate = (markup_str[0] == 0)?1:0;
    ShowHideMainWindow();

    free(markup_str);
}

void main_window_set_position_follow_cursor (gint pos_x, gint pos_y)
{
    GtkRequisition ws;

    gtk_widget_size_request (pcaux_main_window, &ws);

    if (pos_x + ws.width > gdk_screen_width ())
        pos_x = gdk_screen_width () - ws.width;
    if (pos_x <= 0) pos_x = 1;

    if (pos_y + ws.height > gdk_screen_height ())
        pos_y -= ws.height + 36;
    if (pos_y + ws.height > gdk_screen_height ())
        pos_y = gdk_screen_height () - ws.height;
    if (pos_y <= 0) pos_y = 1;

    if (pcaux_main_window_pos_x != pos_x || pcaux_main_window_pos_y != pos_y) {
        gtk_window_move (GTK_WINDOW (pcaux_main_window), pos_x, pos_y);
        pcaux_main_window_pos_x = pos_x;
        pcaux_main_window_pos_y = pos_y;
    }
}

void main_window_set_position (gint pos_x, gint pos_y)
{
    GtkRequisition ws;

    gtk_widget_size_request (pcaux_main_window, &ws);

    if (pos_x + ws.width > gdk_screen_width ())
        pos_x = gdk_screen_width () - ws.width;
    if (pos_x <= 0) pos_x = 1;

    if (pos_y + ws.height > gdk_screen_height ())
        pos_y = gdk_screen_height () - ws.height;
    if (pos_y <= 0) pos_y = 1;

    if (pcaux_main_window_pos_x != pos_x || pcaux_main_window_pos_y != pos_y) {
        gtk_window_move (GTK_WINDOW (pcaux_main_window), pos_x, pos_y);
        pcaux_main_window_pos_x = pos_x;
        pcaux_main_window_pos_y = pos_y;
    }
}

static gboolean OnMouseMove (GtkWidget *window, GdkEventMotion *event, gpointer user_data)
{
    gint pos_x, pos_y;
    if ((event->state & (GDK_BUTTON1_MASK | GDK_BUTTON2_MASK | GDK_BUTTON3_MASK)) != 0 && mouse_draging) {
        gtk_window_get_position (GTK_WINDOW (window), &pos_x, &pos_y);
        main_window_set_position(pos_x + ((gint) event->x_root - pcaux_main_window_drag_x),
                                 pos_y + ((gint) event->y_root - pcaux_main_window_drag_y));

        pcaux_main_window_drag_x = (gint) event->x_root;
        pcaux_main_window_drag_y = (gint) event->y_root;

        return TRUE;
    }
    return FALSE;
}

static gboolean OnMouseClick(GtkWidget *window, GdkEventButton *event, gpointer user_data)
{
    int click_type = GPOINTER_TO_INT (user_data);
    static gulong motion_handler;
    GdkCursor *cursor;

    if (click_type == 0 && event->button <= 1 && !mouse_draging) {

        mouse_draging = TRUE;

        // Connection pointer motion handler to this window.
        motion_handler = g_signal_connect (G_OBJECT (window),
                                           "motion-notify-event",
                                           G_CALLBACK (OnMouseMove),
                                           NULL);

        pcaux_main_window_drag_x = (gint) event->x_root;
        pcaux_main_window_drag_y = (gint) event->y_root;
        cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);

        // Grab the cursor to prevent losing events.
        gdk_pointer_grab (window->window, TRUE,
                          (GdkEventMask) (GDK_BUTTON_RELEASE_MASK | GDK_POINTER_MOTION_MASK),
                          NULL, cursor, event->time);
        gdk_cursor_unref (cursor);

        return TRUE;
    } else if (click_type == 1 && event->button <= 1) {
      if (!mouse_draging) return FALSE;

        g_signal_handler_disconnect (G_OBJECT (window), motion_handler);
        gdk_pointer_ungrab (event->time);
        mouse_draging = FALSE;

        PCAux_Change_LE_Position_Request(pcaux_main_window_pos_x, pcaux_main_window_pos_y);

        return TRUE;
    } else if (click_type == 1 && event->button > 1) {
        return TRUE;
    }
    return FALSE;
}

GtkWidget* create_pcaux_main_window()
{
    GtkWidget* box, *hbox, *label;
    GtkWidget* frame;
    GdkCursor* cursor;

    pcaux_main_window = gtk_window_new(GTK_WINDOW_POPUP);
    gtk_container_set_border_width(GTK_CONTAINER(pcaux_main_window), 0);
    //gtk_widget_set_size_request(GTK_WIDGET(pcaux_main_window), 180, -1);

    frame = gtk_frame_new(NULL);
    gtk_frame_set_shadow_type (GTK_FRAME(frame), GTK_SHADOW_OUT);
    gtk_container_add(GTK_CONTAINER(pcaux_main_window), GTK_WIDGET(frame));

    box = gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(frame), GTK_WIDGET(box));


    hbox = gtk_hbox_new(FALSE, 1);

    label = gtk_label_new(" ");
    gtk_box_pack_start(GTK_BOX(hbox), GTK_WIDGET(label), FALSE, FALSE, 0);

    pcaux_preedit_area = (ImLabel*)im_label_new("");
    im_label_set_markup(pcaux_preedit_area, "<span color=\"blue\">五一</span>huang'jin'zhou ");
    im_label_set_caret_index(pcaux_preedit_area, 16);
    gtk_box_pack_start(GTK_BOX(hbox), GTK_WIDGET(pcaux_preedit_area), TRUE, TRUE, 0);

    label = gtk_label_new(" ");
    gtk_box_pack_start(GTK_BOX(hbox), GTK_WIDGET(label), FALSE, FALSE, 0);

    frame = gtk_frame_new(NULL);
    gtk_frame_set_shadow_type (GTK_FRAME(frame), GTK_SHADOW_NONE);
    gtk_container_add(GTK_CONTAINER(frame), GTK_WIDGET(hbox));
    gtk_box_pack_start(GTK_BOX(box), GTK_WIDGET(frame), TRUE, TRUE, 0);

    frame = gtk_hseparator_new();
    gtk_box_pack_start(GTK_BOX(box), GTK_WIDGET(frame), TRUE, TRUE, 0);


    hbox = gtk_hbox_new(FALSE, 1);

    label = gtk_label_new(" ");
    gtk_box_pack_start(GTK_BOX(hbox), GTK_WIDGET(label), FALSE, FALSE, 0);

    pcaux_candidate_area = (GtkLabel*)gtk_label_new(" ");
    gtk_label_set_markup(pcaux_candidate_area, "<span foreground=\"#009900\">1.黄金周</span> 2.黄金 3.黄 4.皇 5.晃 ");
    gtk_box_pack_start(GTK_BOX(hbox), GTK_WIDGET(pcaux_candidate_area), TRUE, TRUE, 0);

    label = gtk_label_new(" ");
    gtk_box_pack_start(GTK_BOX(hbox), GTK_WIDGET(label), FALSE, FALSE, 0);


    frame = gtk_frame_new(NULL);
    gtk_frame_set_shadow_type (GTK_FRAME(frame), GTK_SHADOW_NONE);
    gtk_container_add(GTK_CONTAINER(frame), GTK_WIDGET(hbox));
    gtk_box_pack_start(GTK_BOX(box), GTK_WIDGET(frame), TRUE, TRUE, 0);

    //gtk_label_set_selectable(pcaux_preedit_area, TRUE);
    gtk_misc_set_alignment(GTK_MISC(pcaux_preedit_area), 0, 0);
    gtk_misc_set_alignment(GTK_MISC(pcaux_candidate_area), 0, 0);

    gtk_window_set_resizable(GTK_WINDOW(pcaux_main_window), FALSE);
    gtk_widget_show_all(pcaux_main_window);
    gtk_widget_hide(pcaux_main_window);

    cursor = gdk_cursor_new_for_display(gtk_widget_get_display(pcaux_main_window), GDK_FLEUR);
    gdk_window_set_cursor(GTK_WIDGET(pcaux_main_window)->window, cursor);

    gtk_widget_add_events (pcaux_main_window,GDK_BUTTON_PRESS_MASK);
    gtk_widget_add_events (pcaux_main_window,GDK_BUTTON_RELEASE_MASK);
    gtk_widget_add_events (pcaux_main_window,GDK_POINTER_MOTION_MASK);

    g_signal_connect (G_OBJECT (pcaux_main_window),
                      "button-press-event",
                      G_CALLBACK (OnMouseClick),
                      GINT_TO_POINTER (0));

    g_signal_connect (G_OBJECT (pcaux_main_window),
                      "button-release-event",
                      G_CALLBACK (OnMouseClick),
                      GINT_TO_POINTER (1));

    return pcaux_main_window;
}

int main(int argc, char **argv)
{
    gtk_init(&argc, &argv);

    DEBUG_printf("Starting composite auxiliary window...\n");

    create_pcaux_main_window();

    //g_signal_connect(G_OBJECT(pcaux_main_window), "delete_event", G_CALLBACK(gtk_main_quit), NULL);

    gdk_window_add_filter(pcaux_main_window->window, xaux_ext_event_handler, 0);
    xaux_ext_register_classes(pcaux_main_window->window);

    DEBUG_printf("OK!\n");

    gtk_main();

    return 0;
}
