/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>

#define MAX_CHAR_LEN 	4

int convert_to_hex_code(char high_code, char low_code)
{
	unsigned char high, low;

	high = toupper(high_code);
	if (high >= '0' && high <= '9') {
		high = high - '0' + 0x8;
	} else if (high >= 'A' && high <= 'F') {
		high = high - 'A' + 0xa;
	}
	high <<= 4;

	low = toupper(low_code);
	if (low >= '0' && low <= '9') {
		low = low - '0' + 0x0;
	} else if (low >= 'A' && low <= 'F') {
		low = low - 'A' + 0xa;
	}

	return((high | low) & 0x00ff);
}

int convert_to_cns11643_code(unsigned char *qu_str, unsigned char *hex_str)
{
	int qu_code;
	int cur_pos = 0;

	qu_code = toupper(qu_str[0]);
	if (qu_code >= '2' && qu_code <= '7') {
		hex_str[cur_pos++] = 0x8e;
		hex_str[cur_pos++] = 0xa1 + (qu_code - '1');
	} else if (qu_code >= 'A' && qu_code <= 'F') {
		hex_str[cur_pos++] = 0x8e;
		hex_str[cur_pos++] = 0xaa + (qu_code - 'A');
	}
	hex_str[cur_pos++] = convert_to_hex_code(qu_str[1], qu_str[2]);
	hex_str[cur_pos++] = convert_to_hex_code(qu_str[3], qu_str[4]);
	hex_str[cur_pos] = 0;

	return(0);
}

int  main(int argc, char **argv)
{
    	char            *file_name; 
	char		line[256];
	unsigned char	value1[256], value2[256], hex_str[5];
    
	register char 	*ptr;
	FILE 		*fd;
	int 		i;

	if (argc != 2) {
		printf("usage: %s file_name\n", argv[0]);
		exit(0);
	}

    	/* read profile from file to memory buffer  */ 
	file_name = argv[1];

	fd = fopen(file_name, "r");
	if (! fd)
		return -1;

	while (fgets(line, 255, fd) != NULL) {
		ptr = line;

		/* skip space */
		while (*ptr == ' ' || *ptr == '\t') ptr++;

		/* check null line or comment line */
		if ((*ptr == '\0') || (*ptr == '\n') || (*ptr == '#'))
			continue;

/*
		sscanf(ptr, "%s %s", &value1, &value2);
*/
		memset(value1, 0, 256);
		memset(value2, 0, 256);
		for (i=0; i<5; i++) {
			value1[i] = *ptr++;
		}
		value1[5] ='\0';

		/* skip space */
		while (*ptr==' ' || *ptr=='\t') ptr++;

		if (*ptr && *ptr != '\n') {
			for (i=0; i<MAX_CHAR_LEN; i++) {
				if (*ptr == 0 || *ptr==' ' || *ptr=='\t' || *ptr=='\n') {
					value2[i] = 0;
					break;
				}
				value2[i] = tolower(*ptr++);
			}

			convert_to_cns11643_code(value1, hex_str);
			printf("%s\t%s\n", value2, hex_str);
		}
	}
	
	fclose(fd);

    	return 0;
}

