#include <stdio.h>
#include <stdlib.h>
#include <EIMIL.h>

static int
print_event(
    EIMIL_handle eh,
    EIMIL_event *pev
)
{
    fprintf(stderr, "Event:%s", pev->type);
    if (pev->pv_val)
	fprintf(stderr, " VAL[%d]", pev->pv_val->v.number);
    else
	fprintf(stderr, " VAL[nil]");

    if (pev->pv_mod)
	fprintf(stderr, " MOD[%d]", pev->pv_mod->v.number);
    else
	fprintf(stderr, " MOD[nil]");

    if (pev->pv_char)
	fprintf(stderr, " CH[%c:%X]", pev->pv_char->v.ch, pev->pv_char->v.ch);
    else
	fprintf(stderr, " CH[nil]");

    if (pev->pv_mtext) {
	UTF8 *pstr;

	pstr = EIMIL_convert_UTF32_to_UTF8(pev->pv_mtext->v.mtext.ustr);
	fprintf(stderr, " MTEXT[%s]\n", pstr);
	free(pstr);
    } else {
	fprintf(stderr, " MTEXT[nil]\n");
    }

    return 1;
}

int
main(
    int argc,
    char **argv
)
{
    char buf[1024];
    unsigned char *pfn;
    EIMIL_handle eh, eh2;

    getcwd(buf, sizeof(buf));

    EIMIL_initialize();

    EIMIL_register_class("org.OpenI18N.test", buf);
    pfn = EIMIL_find_file("org.OpenI18N.test", "arithtest.xml");

    if (!EIMIL_parse_file(&eh, pfn)) goto error;
    EIMIL_register_handler(eh, print_event, NULL, NULL);

    /* test1: i + 2 */
    if (!EIMIL_send_event(eh, NULL)) goto error;
    if (!EIMIL_send_event(eh, NULL)) goto error;
    if (!EIMIL_send_event(eh, NULL)) goto error;
    if (!EIMIL_send_event(eh, NULL)) goto error;
    if (!EIMIL_send_event(eh, NULL)) goto error;
    if (!EIMIL_send_event(eh, NULL)) goto error;
    if (!EIMIL_send_event(eh, NULL)) goto error;
    if (!EIMIL_send_event(eh, NULL)) goto error;
    if (!EIMIL_send_event(eh, NULL)) goto error;

    return 0;

error:
    EIMIL_get_errormsg(eh, &pfn);
    fprintf(stderr, "%s\n", pfn);
    return 255;
}

