#include <config.h>
#include <stdio.h>
#include "IMProtocol.hh"
#include "IMState.hh"
#include "ICState.hh"

void
IMProtocol::add_imstate(
    IMState *pims
)
{
    immap[pims->get_im_id()] = pims;
}

void
IMProtocol::remove_imstate(
    IMState *pims
)
{
    immap.erase(pims->get_im_id());
}


bool
IMProtocol::dispatch(
    CARD16BIT im_id,
    CARD16BIT ic_id,
    void *message
)
{
    if (ic_id == INVALID_CONTEXT_ID) {
	IMState *pims = get_imstate(im_id);
	return pims->deliver(message);
    }
    ICState *pics = get_icstate(im_id, ic_id);

    if (!pics) {
	LOG_ERROR("Invalid im_id and ic_id (%d, %d)",
		  (int) im_id, (int) ic_id);
	return false;
    }

    return pics->deliver(message);
}

IMProtocol::IMProtocol(
    IMAccept *pima
)
{
    pimaccept = pima;
}

IMProtocol::~IMProtocol()
{
    destroy_all(immap);
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
