#ifndef SUNIMLOCK_H
#define SUNIMLOCK_H

#ifdef  sun
#   define SUNIM_LOCK(m) \
		((mutex_lock(&m) != 0) && \
		 (fprintf(stderr, "mutex_lock(): FAILED\n"), 0))
#elif   WIN32
#   define SUNIM_LOCK(m) \
		(((WaitForSingleObject(m, INFINITE) == WAIT_FAILED)) && \
		 printf("WaitForSingleObject(): FAILED\n"))
#else
#   define SUNIM_LOCK(m) \
		((pthread_mutex_lock(&m) != 0) && \
		 printf("pthread_mutex_lock(): FAILEDK\n"))
#endif

#ifdef  sun
#   define SUNIM_UNLOCK(m) \
		((mutex_unlock(&m) != 0) && \
		 (fprintf(stderr, "mutex_unlock(): FAILED\n"), 0))
#elif   WIN32
#   define SUNIM_UNLOCK(m) \
		((ReleaseMutex(m) == 0) && \
		 printf("ReleaseMutex(): FAILED\n"))
#else
#   define SUNIM_UNLOCK(m) \
		((pthread_mutex_unlock(&m) != 0) && \
		 printf("pthread_mutex_unlock(): FAILED\n"))
#endif
#endif
