/*
 * fop_test_case.c: iml file operation - LE for testing
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

#include "config.h"

/*
 * header files for SunIM library
 */
#include <syscfg.h>
#include "SunIM.h"
#include "SunIMMMan.h"
#include "SunIMProt.h"
#include "SunIMMthd.h"
#include "SunIMPriv.h"
#include "SunIMCore.h"
#include "SunIMPub.h"

#include "fop_test.h"

/*
 * define If method prototype
 */
static Bool	if_fop_test_OpenIF(iml_if_t *);
static Bool	if_fop_test_CloseIF(iml_if_t *);
static Bool	if_fop_test_GetIFValues(iml_if_t *, IMArgList, int);
static Bool	if_fop_test_SetIFValues(iml_if_t *, IMArgList, int);
static Bool	if_fop_test_OpenDesktop(iml_desktop_t *, IMArgList, int);
static Bool	if_fop_test_CloseDesktop(iml_desktop_t *);
static Bool	if_fop_test_CreateSC(iml_session_t*, IMArgList, int);
static Bool	if_fop_test_DestroySC(iml_session_t *);
static Bool	if_fop_test_GetSCValues(iml_session_t *, IMArgList, int);
static Bool	if_fop_test_SetSCValues(iml_session_t *, IMArgList, int);
static IMText *	if_fop_test_ResetSC(iml_session_t *);
static void	if_fop_test_SetSCFocus(iml_session_t *);
static void	if_fop_test_UnsetSCFocus(iml_session_t *);
static void	if_fop_test_SendEvent(iml_session_t *, IMInputEvent * ev);

/*
 * define if_methods_t
 */
static if_methods_t if_methods = {
    if_fop_test_OpenIF,
    if_fop_test_CloseIF,
    if_fop_test_GetIFValues,
    if_fop_test_SetIFValues,
    if_fop_test_OpenDesktop,
    if_fop_test_CloseDesktop,
    if_fop_test_CreateSC,
    if_fop_test_DestroySC,
    if_fop_test_GetSCValues,
    if_fop_test_SetSCValues,
    if_fop_test_ResetSC,
    if_fop_test_SetSCFocus,
    if_fop_test_UnsetSCFocus,
    if_fop_test_SendEvent
};

/*
 * define Human Readable Name as UTFCHAR for LE
 */
static UTFCHAR lename_string[] = {
    0x6551,
    0xfa51,
    0x9b52,
    0x1c69,
    0xfb67,
    0x0000
};

/*
 * define Human Readable Name as UTFCHAR for language
 */
static UTFCHAR jahrn_string[] = {
    0x65e5,
    0x672c,
    0x8a9e,
    0x0000
};

static IMLEName lename = {
    "fop_test",			/* LE id */
    lename_string		/* LE HRN */
};

static IMLocale locales[] = {
    {
        "ja",			/* locale id */
        jahrn_string		/* locale HRN */
    },
    {
	NULL,
	NULL
    }
};

#ifdef WIN32
#define EXPORT extern __declspec(dllexport)

EXPORT

#endif


void
if_GetIfInfo(
    IMArgList	args,
    int		num_args
)
{
    int i;

    for (i = 0; i < num_args; i++, args++) {
        switch (args->id) {
            case IF_VERSION:
                args->value = (IMArgVal) "1.2";
                break;
            case IF_METHOD_TABLE:
                args->value = (IMArgVal)(&if_methods);
                break;
            case IF_LE_NAME:
                args->value = (IMArgVal)(&lename);
                break;
            case IF_SUPPORTED_LOCALES:
                args->value = (IMArgVal)(&locales);
                break;
            case IF_SUPPORTED_OBJECTS:
                break;
            case IF_NEED_THREAD_LOCK:
                args->value = (IMArgVal)(False);
                break;
            default:
                break;
            }
    }
}


static Bool
if_fop_test_OpenIF(
    iml_if_t *	If
)
{
    return True;
}


static Bool
if_fop_test_CloseIF(
    iml_if_t *	If
)
{
    return True;
}


static Bool
if_fop_test_GetIFValues(
    iml_if_t *	If,
    IMArgList	args,
    int		num_args
)
{
    return True;
}


static Bool
if_fop_test_SetIFValues(
    iml_if_t *	If,
    IMArgList	args,
    int		num_args
)
{
    return True;
}


static Bool
if_fop_test_OpenDesktop(
    iml_desktop_t *	desktop,
    IMArgList		args,
    int			num_args
)
{
    int i;

    printf("if_fop_test_OpenDesktop()\n");
    printf("	This method is invoked when the user start to use\n");
    printf("	the desktop, which means the first connection.\n");
    
    printf("\n");
    printf("	user [%s@%s] is entered\n",
        desktop->user_name,
        desktop->host_name);
    printf("\n");

    printf("	The additional info of IM client are\n");

    for (i = 0; i < num_args; i++, args++) {
        switch (args->id) {
            case UI_USER_NAME:
                if (args->value) {
                    printf("	UI_USER_NAME=%s\n", args->value);
                }
                break;
            case UI_HOST_NAME:
                if (args->value) {
                    printf("	UI_HOST_NAME=%s\n", args->value);
                }
                break;
            case UI_DISPLAY_ID:
                if (args->value) {
                    printf("	UI_DISPLAY_ID=%s\n", args->value);
                }
                break;
            case UI_PROTOCOL_TYPE:
                if (args->value) {
                    printf("	UI_PROTOCOL_TYPE=%s\n", args->value);
                }
                break;
            case UI_CLIENT_TYPE:
                if (args->value) {
                    printf("	UI_CLIENT_TYPE=%s\n", args->value);
                }
                break;
            case UI_XSERVER_VENDOR:
                if (args->value) {
                    printf("	UI_XSERVER_VENDOR=%s\n", args->value);
                }
                break;
            case UI_OS_NAME:
                if (args->value) {
                    printf("	UI_OS_NAME=%s\n", args->value);
                }
                break;
            case UI_OS_ARCH:
                if (args->value) {
                    printf("	UI_OS_ARCH=%s\n", args->value);
                }
                break;
            case UI_OS_VERSION:
                if (args->value) {
                    printf("	UI_OS_VERSION=%s\n", args->value);
                }
                break;
            }
    }
    
    return True;
}


static Bool
if_fop_test_CloseDesktop(
    iml_desktop_t *	desktop
)
{
    return True;
}


static Bool
if_fop_test_CreateSC(
    iml_session_t *	s,
    IMArgList		args,
    int			num_args
)
{
    return True;
}


static Bool
if_fop_test_DestroySC(
    iml_session_t *	s
)
{
    return True;
}


static Bool
if_fop_test_GetSCValues(
    iml_session_t *	s,
    IMArgList		args,
    int			num_args
)
{
    return True;
}


static Bool
if_fop_test_SetSCValues(
    iml_session_t *	s,
    IMArgList		args,
    int			num_args
)
{
    return True;
}


static IMText *
if_fop_test_ResetSC(
    iml_session_t *	s
)
{
    return (IMText *)NULL;
}


static void
if_fop_test_SetSCFocus(
    iml_session_t *	s
)
{
    fop_test_cases_all(s->desktop, s->If->nsc_get_function);
}


static void
if_fop_test_UnsetSCFocus(
    iml_session_t *	s
)
{
}


static void
if_fop_test_SendEvent(
    iml_session_t *	s,
    IMInputEvent *	ev
)
{
    if (IM_EventKeyList == ev->type) {
    }
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
