#include <stdio.h>
#include "newpinyin_im.h"
#include "PYIM.h"

#define LOOKUP_CHOICE_NUM  	6

#define IME_Status		ime_buffer->return_status
#define Input_Buf		ime_buffer->input_buf
#define Input_Len		ime_buffer->input_len
#define Preedit_Buf		ime_buffer->preedit_buf
#define Preedit_Len		ime_buffer->preedit_len
#define Preedit_CaretPos	ime_buffer->preedit_caretpos
#define Commit_Buf		ime_buffer->commit_buf
#define Commit_Len		ime_buffer->commit_len
#define Status_Buf		ime_buffer->status_buf
#define Status_Len		ime_buffer->status_len
#define Lookups_Num		ime_buffer->num_candidates
#define Lookup_Pos		ime_buffer->cur_lookup_pos
#define Candidates		ime_buffer->candidates
#define Comments		ime_buffer->comments
#define Lookups			ime_buffer->lookups

int convert_to_imebuffer(ImToXSun* pIeh, ImeBufferRec *ime_buffer);

int newpy_open(JINT nSesID)
{
	ImToXSun *pIeh;

	pIeh = (ImToXSun *)NewPY_open(nSesID);
	if (pIeh == NULL)
		return (-1);

	return(0);
}

int newpy_close(JINT nSesID)
{
	NewPY_close(nSesID);
	return(0);
}

int newpy_filter(int keycode, int keychar, int keystatus, ImeBufferRec *ime_buffer)
{
	ImToXSun *pIeh;
	JINT ret;

	JINT nSesID = ime_buffer->session_id;
   	pIeh = (ImToXSun *)NewPY_trans (nSesID, (JINT)keycode, (JINT)keychar, (JINT)keystatus);

	if (pIeh == NULL)
		return(IME_UNUSED_KEY);
		
	ret = convert_to_imebuffer(pIeh, ime_buffer);
	return (ret);
}

/*
**  Convert from Struct ImToXSun to Struct ImToXSunChar
*/
int convert_to_imebuffer(ImToXSun* pIeh, ImeBufferRec *ime_buffer)
{
	JINT   i, j, nHz;
	JINT   nNumDollar;   /* Number of Numsign and Dollar before Caret */
	static ImToXSunChar  iehc;
	
	IME_Status = 0;

	DEBUG_printf("nType:%d\n", pIeh->nType);
	DEBUG_printf("IMXSUN_TYPE_BOUNCEKEY:%d\n", IMXSUN_TYPE_BOUNCEKEY);
	if (pIeh->nType == IMXSUN_TYPE_BOUNCEKEY)
		return(IME_UNUSED_KEY);

/*
	ime_buffer->lookup_label_type = NUMERIC_LABEL;
*/
	Lookups_Num = pIeh->nChoiceNum;
	IME_Status |= IME_LOOKUP_AREA;

	/* One Hanzi is  2 Bytes */
	nHz = 0;
	for (i = 0; (pIeh->pwPreedit[i] >= 0x8140); i++)
		nHz++;
	
/*
	iehc.nType        = pIeh->nType;
	iehc.nErrorCode   = pIeh->nErrorCode;
	iehc.nChoiceNum   = pIeh->nChoiceNum;
	iehc.nLabelType   = LABELTYPE_1234567;
*/
	
	nNumDollar = 0;
	j = 0;
	for (i = 0; pIeh->pwPreedit[i] != 0x0000; i++)
	{
		if ((pIeh->pwPreedit[i] != (JWORD)'#') && (pIeh->pwPreedit[i] != (JWORD)'$'))
		{
			pIeh->pwPreedit[j++] = pIeh->pwPreedit[i];
		}
		else  /* '#' and '$' before pIeh->nCaretPos should be counted!! */
		{
			if (i < pIeh->nCaretPos)
				nNumDollar ++;
		}
	}
	for (; j < 128; j++)
		pIeh->pwPreedit[j++] = 0x0000;
	
/*
	iehc.nCaretPos    = pIeh->nCaretPos + nHz - nNumDollar;
*/
	
	Jword2Uchar(pIeh->pwPreedit, iehc.szPreedit, 128);
	Jword2Uchar(pIeh->pwCommit,  iehc.szCommit,  256);
	Jword2Uchar(pIeh->pwStatus,  iehc.szStatus,   16);

/*
	Preedit_CaretPos = pIeh->nCaretPos + nHz - nNumDollar;

	DEBUG_printf("pIeh->nCaretPos:%d, nHz:%d, nNumDollar:%d\n", pIeh->nCaretPos, nHz, nNumDollar);
	DEBUG_printf("Preedit_CaretPos:%d\n", Preedit_CaretPos);
*/
	Preedit_CaretPos = pIeh->nCaretPos;

	strncpy((char *)Preedit_Buf, (char *)(iehc.szPreedit), MAX_PREEDIT_CHAR_NUM);
	strncpy((char *)Commit_Buf,  (char *)(iehc.szCommit),  MAX_COMMIT_CHAR_NUM);
	
	Preedit_Len = strlen((char *)Preedit_Buf);
	IME_Status |= IME_PREEDIT_AREA;

	Commit_Len  = strlen((char *)Commit_Buf);
	IME_Status |= IME_COMMIT;

/*
	DEBUG_printf("Lookups_Num:%d\n", Lookups_Num);
	DEBUG_printf("Preedit:%s\n", Preedit_Buf);
	DEBUG_printf("Commit:%s\n",  Commit_Buf);
	DEBUG_printf("Preedit:%s\n", iehc.szPreedit);
	DEBUG_printf("Commit:%s\n", iehc.szCommit);
	DEBUG_printf("Status:%s\n", iehc.szStatus);
*/

	DEBUG_printf("Newpy return: commit_len: %d\n", strlen((char *)iehc.szCommit));
	DEBUG_printf("Commit:%s\n", (char *)iehc.szCommit);
	DEBUG_printf("Commit:%s\n",  Commit_Buf);
	for(i = 0; i < 8; i++) {
		Jword2Uchar(pIeh->pwLookupChoice[i], iehc.szLookupChoice[i],  24);
		strncpy((char *)Lookups[i], (char *)(iehc.szLookupChoice[i]), 24);
		DEBUG_printf("Lookups[%d]:%s\n", i, Lookups[i]);

	}
	
	return(IME_OK);
}

