#ifndef __HANGUL_H__
#define __HANGUL_H__

#include <IMProtocolStruct.h>

#define CHOSEONG_FILLER		0x115F
#define JUNGSEONG_FILLER	0x1160
#define JONGSEONG_FILLER	0x11A7

#define IS_VALID_CHOSEONG(LC)	(((LC) >= 0x1100) && ((LC) <= 0x1159))
#define IS_VALID_JUNGSEONG(IV)	(((IV) >= 0x1161) && ((IV) <= 0x11a2))
#define IS_VALID_JONGSEONG(TC)	(((TC) >= 0x11a7) && ((TC) <= 0x11f9))

UTFCHAR hangul_combining_chosung_to_compatibility_jamo (UTFCHAR ch);
UTFCHAR hangul_combining_jungsung_to_compatibility_moeum (UTFCHAR ch);
UTFCHAR hangul_combining_jongsung_to_compatibility_jaeum (UTFCHAR ch);
UTFCHAR hangul_combining_chosung_to_combining_jongsung (UTFCHAR jaeum_choseong);
UTFCHAR hangul_combining_jongsung_to_combining_chosung (UTFCHAR jongsung);
void    hangul_jongseong_decompose (UTFCHAR ch, UTFCHAR* jong, UTFCHAR* cho);

#endif /* __HANGUL_H__ */
