#ifndef _PROPERTY_DATA_H_
#define _PROPERTY_DATA_H_

#include "ime.h"
#include "gdk/gdk.h"
#include "vkb_layout.h"

typedef struct _ime_module_t {
    int  version;
    char *uuid;
    char *name;
    char *author;
    char *hinting;
    char *copyright;
    char *icon_file;

    int  enabled;

    ImePropertyListRec *property_list;

    GdkPixbuf *icon_pixbuf;

    int num_vkbs;
    vkb_layout_t **vkbs;
} ime_module_t;

typedef struct _property_data_t {

    /* iiim server properties */
    int  time_stamp;
    char fkey_vkb;

    /* statusbar properties */
    int show_ime_button;
    int show_qjbj_button;
    int show_punct_button;
    int show_vkb_button;
    int show_utility_button;
    int show_with_vertical;

    int pos_x_palette;
    int pos_y_palette;

    int tooltips_enabled;
    int beep_enabled;

    /* composite style for preedit/candidates */
    int composite_style;

    /* ime modules */
    int num_ime_modules;
    ime_module_t **ime_modules;

} property_data_t;

#define DATA_PROPERTY_DATA_INFO	"property_data_info"

enum {
    PROPERTY_DATA_FOR_LOCAL_PROFILE = 0,
    PROPERTY_DATA_FOR_IME_CONFIG,
    PROPERTY_DATA_FOR_SERVER_NOTIFICATION,
    PROPERTY_DATA_FOR_ALL
};

#endif /* _PROPERTY_DATA_H_ */
