/*
  Copyright 2002-2003 Sun Microsystems, Inc. All Rights Reserved.

  Permission is hereby granted, free of charge, to any person obtaining a
  copy of this software and associated documentation files (the
  "Software"), to deal in the Software without restriction, including
  without limitation the rights to use, copy, modify, merge, publish,
  distribute, sublicense, and/or sell copies of the Software, and to
  permit persons to whom the Software is furnished to do so, subject to
  the following conditions: The above copyright notice and this
  permission notice shall be included in all copies or substantial
  portions of the Software.


  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
  IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
  CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
  THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
  ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


  Except as contained in this notice, the names of The Open Group and/or
  Sun Microsystems, Inc. shall not be used in advertising or otherwise to
  promote the sale, use or other dealings in this Software without prior
  written authorization from The Open Group and/or Sun Microsystems,
  Inc., as applicable.


  X Window System is a trademark of The Open Group

  OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
  logo, LBX, X Window System, and Xinerama are trademarks of the Open
  Group. All other trademarks and registered trademarks mentioned herein
  are the property of their respective owners. No right, title or
  interest in or to any trademark, service mark, logo or trade name of
  Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "codetable.h"
#include "unit_input.h"
#include "keymap.h"
#include "logf.h"

#define LOOKUP_CHOICE_NUM   6

#define IME_Status  ime_buffer->return_status
#define Input_Buf  ime_buffer->inputkey_buf
#define Input_Len  ime_buffer->inputkey_len
#define Preedit_Buf  ime_buffer->preedit_buf
#define Preedit_Len  ime_buffer->preedit_len
#define Preedit_CaretPos ime_buffer->preedit_caretpos
#define Commit_Buf  ime_buffer->commit_buf
#define Commit_Len  ime_buffer->commit_len
#define Status_Buf  ime_buffer->status_buf
#define Status_Len  ime_buffer->status_len
#define Lookup_Buf  ime_buffer->lookup_buf
#define Lookup_Num  ime_buffer->lookup_num
#define Lookup_Pos  ime_buffer->cur_lookup_pos
#define Candidates_Buf  ime_buffer->candidates_buf
#define Additions_Buf  ime_buffer->additions_buf

int Is_UsedCodes_Key(hztbl, key)
     CodeTableStruct *hztbl;
     int key;
{
  if ( index(hztbl->UsedCodes, key) )
    return(1);
  else
    return(0);
}

int get_select_num(hztbl, key)
     CodeTableStruct *hztbl;
     int key;
{
  int ret = -1;
  switch(hztbl->nSelectKeyMode)
    {
    case NUMBER_MODE:
      if (key >= '0' && key <= '9')
	ret = (key - '0' + 9) % 10;
      break;

    case LOWER_MODE:
      if (key >= 'a' && key <= 'a' + 10)
	ret = key - 'a';
      break;

    case UPPER_MODE:
      if (key >= 'A' && key <= 'A' + 10)
	ret = key - 'A';
      break;
    }
  return(ret);
}

int Is_Select_Key(hztbl, key)
     CodeTableStruct *hztbl;
     int key;
{
  int ret = get_select_num(hztbl, key);
  if (ret == -1)
    return(0);
  else
    return(1);
}

int Is_Commit_Key(hztbl, key)
     CodeTableStruct *hztbl;
     int key;
{
  if (key == SPACE_KEY || key == RETURN_KEY)
    return(1);
  else
    return(0);
}

int Is_BackSpace_Key(hztbl, key)
     CodeTableStruct *hztbl;
     int key;
{
  unsigned char *keylist = hztbl->functionkey[BACKSPACE_KEY_ID].keylist;

  if (key == BACKSPACE_KEY || key == DELETE_KEY)
    return(1);

  if ( keylist[0] )
    {
      if ( index(keylist, key) )
	return(1);
    }

  return(0);
}

int Is_ClearAll_Key(hztbl, key)
     CodeTableStruct *hztbl;
     int key;
{
  unsigned char *keylist = hztbl->functionkey[CLEARALL_KEY_ID].keylist;

  if (key == ESC_KEY)
    return(1);

  if ( keylist[0] )
    {
      if ( index(keylist, key) )
	return(1);
    }
  return(0);
}

int Is_NextPage_Key(hztbl, key)
     CodeTableStruct *hztbl;
     int key;
{
  unsigned char *keylist = hztbl->functionkey[PAGEDOWN_KEY_ID].keylist;

  if (key == PAGEDOWN_KEY)
    return(1);

  if ( keylist[0] )
    {
      if ( index(keylist, key) )
	return(1);
    }
  return(0);
}

int Is_PrevPage_Key(hztbl, key)
     CodeTableStruct *hztbl;
     int key;
{
  unsigned char *keylist = hztbl->functionkey[PAGEUP_KEY_ID].keylist;

  if (key == PAGEUP_KEY)
    return(1);
 
  if ( keylist[0] )
    {
      if ( index(keylist, key) )
	return(1);
    }
  return(0);
}

int get_lookup_result(hztbl, ime_buffer, nHelpInfoMode, pos, max_lookup_num)
     CodeTableStruct *hztbl;
     IMEBufferRec *ime_buffer;
     int nHelpInfoMode;
     int pos;
     int max_lookup_num;
{
  int i, lookup_num;

  lookup_num = codetable_search(hztbl, Input_Buf, Input_Len, Candidates_Buf, Additions_Buf, pos, max_lookup_num); 
  if (lookup_num > 0)
    {
      for (i=0; i<lookup_num; i++)
	{
	  log_f("%d: %s %s\n", i, Candidates_Buf[i], Additions_Buf[i]);
	  if (nHelpInfoMode)
	    sprintf((char *)Lookup_Buf[i], "%s %s", Candidates_Buf[i], Additions_Buf[i]);
	  else
	    strcpy(Lookup_Buf[i], Candidates_Buf[i]);
	}
    }
  return(lookup_num);
}

int commit_candidate(ime_buffer, id)
     IMEBufferRec *ime_buffer;
     int id;
{
  if (id >= Lookup_Num)
    return(-1);

  strcpy((char *)Commit_Buf, (char *)Candidates_Buf[id]);
  Commit_Len = strlen((char *)Commit_Buf);
  log_f("Inside commit_candidate, Commit_Buf <%s>\n",Commit_Buf);
  IME_Status = IME_COMMIT;
  Input_Len = 0;
  Input_Buf[Input_Len] = '\0';
  Preedit_Len = 0;
  Lookup_Num = 0;
  Preedit_CaretPos = 0;
  IME_Status |= IME_PREEDIT_AREA | IME_LOOKUP_AREA;
  return(0);
}

void warning_bell()
{
}

/* return value:  IME_NOT_USED_KEY:  if IME not use this key, return this key to systerm directly */
/*                IME_USED_KEY:      if IME has used this key */
int codetable_filter(hztbl, key_event, ime_buffer)
     CodeTableStruct *hztbl;
     IMEKey key_event;
     IMEBufferRec *ime_buffer;
{
  int     hznum;
  char    ch;
  int     key, pos;
  int nLookup_Pos_Save = 0;
  int  bNeedCheckMore = 0;
 
  int  Max_Lookup_Num = LOOKUP_CHOICE_NUM;
  int  nKeyByKeyMode = hztbl->nKeyByKeyMode;
  int  nHelpInfoMode = hztbl->nHelpInfoMode;
  int  nAutoSelectMode = hztbl->nAutoSelectMode;
  int  nKeyPromptMode = hztbl->nKeyPromptMode;
  int prev_Input_Len;
  static int static_prev_Input_Buf[MAX_INPUT_KEY_NUM];
  int *prev_Input_Buf = static_prev_Input_Buf;
 
  ime_buffer->encode = hztbl->Encode;

  IME_Status = 0;

  key = map_keyevent_to_imekey(hztbl, key_event);
  log_f("ctfilter: map_keyevent_to_imekey: return key:0x%x\n", key);
 
  if (key == IME_NOT_USED_KEY)
    return(IME_NOT_USED_KEY);
 
  switch(hztbl->nSelectKeyMode) {
  case NUMBER_MODE:
    ime_buffer->lookup_label_type = NUMERIC_LABEL;
    break;
  case LOWER_MODE:
    ime_buffer->lookup_label_type = LOWER_LABEL;
    break;
  case UPPER_MODE:
    ime_buffer->lookup_label_type = UPPER_LABEL;
    break;
  default:
    ime_buffer->lookup_label_type = NUMERIC_LABEL;
  }

  if((Is_UsedCodes_Key(hztbl, key)) || (Is_Wildchar_Key(hztbl, key))) { 
    prev_Input_Buf = Input_Buf;
    prev_Input_Len = Input_Len;

    /* if inputted keys length has over the limit */
          
    if (Input_Len >= hztbl->MaxCodes) {
      warning_bell();
      return (IME_USED_KEY);
    }

    /* if not key by key, and is selectkey, and Lookup Mode */
    /* directly select */

    if(!nKeyByKeyMode && (Is_Select_Key(hztbl, key)) && (Lookup_Num>0)) { 

      /* select from candidata */
      /* here should see whether there is enough candidates */

      int select_num;
      select_num = get_select_num(hztbl, key);
      if ((select_num >= 0) && (select_num < Lookup_Num)) {
        commit_candidate(ime_buffer, select_num);
      }else warning_bell();

      return(IME_USED_KEY);
    }

    Input_Buf[Input_Len] = key;
    Input_Len ++;
    Input_Buf[Input_Len] = '\0';

    Lookup_Num = 0;
    bNeedCheckMore = 0;
    /* if need display key by key */
    if (nKeyByKeyMode) {
      nLookup_Pos_Save = Lookup_Pos;
      Lookup_Pos = 0;
      Lookup_Num = get_lookup_result(hztbl, ime_buffer, nHelpInfoMode, Lookup_Pos, Max_Lookup_Num); 
      if (Lookup_Num == 1 && nAutoSelectMode) {
        commit_candidate(ime_buffer, 0);
        return(IME_USED_KEY);
      }

      if (Lookup_Num == 0) {
        log_f("Lookup_Num is zero \n"); 
        /* if key is also a seleck key */
        if (Is_Select_Key(hztbl, key))
          bNeedCheckMore = 1;
        else {
          Input_Buf = prev_Input_Buf;
          Input_Len = prev_Input_Len;
          if (Input_Len == 0) {
            Commit_Len = 0;
            Commit_Buf[Commit_Len] = key;
            Commit_Len++;
            Commit_Buf[Commit_Len] = '\0';
            Commit_Len = strlen((char *)Commit_Buf);
            log_f("codetable_filter: commit_candidate, Commit_Buf <%s>\n",Commit_Buf);
            IME_Status = IME_COMMIT;
            Input_Len = 0;
            Input_Buf[Input_Len] = 0;
            Preedit_Len = 0;
            Preedit_Buf[Preedit_Len] = '\0';
            IME_Status |= IME_PREEDIT_AREA | IME_LOOKUP_AREA;
            return(IME_NOT_USED_KEY);
          }
          nLookup_Pos_Save = Lookup_Pos;
          Lookup_Pos = 0;
          Lookup_Num = get_lookup_result(hztbl, ime_buffer, nHelpInfoMode, Lookup_Pos, Max_Lookup_Num); 
          commit_candidate(ime_buffer, 0);
          Input_Buf[Input_Len] = key;
          Input_Len ++;
          Input_Buf[Input_Len] = '\0';
          Lookup_Num = get_lookup_result(hztbl, ime_buffer, nHelpInfoMode, Lookup_Pos, Max_Lookup_Num);
          if (bNeedCheckMore == 0) {
            Preedit_Buf[Preedit_Len] = key;
            Preedit_Len += 1;
            Preedit_Buf[Preedit_Len] = '\0';
            Preedit_CaretPos = Preedit_Len;
            return(IME_USED_KEY);
          }
        }
      }
      log_f("prev_Input_Len [%d], Input_Len [%d]\n",prev_Input_Len, Input_Len);
      if (prev_Input_Len != Input_Len) {
	Preedit_Buf[Preedit_Len] = key;
	Preedit_Len += 1;
	Preedit_Buf[Preedit_Len] = '\0';
      }
    }else{
      Preedit_Buf[Preedit_Len] = key;
      Preedit_Len += 1;
      Preedit_Buf[Preedit_Len] = '\0';
    }
    Preedit_CaretPos = Preedit_Len;
    IME_Status = IME_PREEDIT_AREA;

    if (bNeedCheckMore == 0) {
      IME_Status |= IME_LOOKUP_AREA;
      return(IME_USED_KEY);
    }
  }
  
  if (bNeedCheckMore == 1) {
    /* restore the original status that before into this function */
    IME_Status = 0;
    Input_Len --;
    Input_Buf[Input_Len] = '\0';
    Lookup_Pos = nLookup_Pos_Save;
    Lookup_Num = get_lookup_result(hztbl, ime_buffer, nHelpInfoMode, Lookup_Pos, Max_Lookup_Num); 
  }

  if (Is_Select_Key(hztbl, key)) { /* select from candidata */
    /* here should see whether there is enough candidates */
    int select_num;

    /*  if no inputted key, directly return this key */
    if (Input_Len==0) return(IME_NOT_USED_KEY);
    log_f("Select Key, key:%c, Lookup_Num:%d\n", key, Lookup_Num);
    select_num = get_select_num(hztbl, key);
    if (Lookup_Num>0 && (select_num >= 0) && (select_num < Lookup_Num)) {
      commit_candidate(ime_buffer, select_num);
    } else warning_bell();

    return(IME_USED_KEY);
  }

  if (Is_ClearAll_Key(hztbl, key)) { 
    /* Esc , clear preedit, lookup choice pointer, and so on */
    log_f("ESC_KEY\n");
    /*  if no inputted key, directly return this key */
    if (Input_Len==0) return(IME_NOT_USED_KEY);
  
    Input_Len = 0;
    Preedit_Len = 0;
    Lookup_Num = 0;
    Preedit_CaretPos = 0;
    IME_Status = IME_PREEDIT_AREA | IME_LOOKUP_AREA;
    return (IME_USED_KEY);
  }

  if (Is_BackSpace_Key(hztbl, key)) { /* Back Space & Delete */
    log_f("BACKSPACE_KEY\n");
    /*  if no inputted key, directly return this key */
    if (Input_Len==0) return(IME_NOT_USED_KEY);
  
    /* Delete characters in pre-edit region */
    Input_Len --;
    if (nKeyPromptMode) {
      ch = Input_Buf[Input_Len];
      log_f("ch:%c, keyprompt:%s\n", ch, hztbl->keyprompt[atoi(&ch)].prompt);
      Preedit_Len -= strlen(hztbl->keyprompt[atoi(&ch)].prompt);
      Preedit_Buf[Preedit_Len] = '\0';
    }else{
      Preedit_Len -= 1;
      Preedit_Buf[Preedit_Len] = '\0';
    }

    Input_Buf[Input_Len] = '\0';
    Preedit_CaretPos = Preedit_Len;
    IME_Status = IME_PREEDIT_AREA;

    Lookup_Num = 0;
  
    /* if still left some keys, and need display key by key, then search. */
    /* else undisplay the candidate window */
    if ((Input_Len > 0) && nKeyByKeyMode) {
      Lookup_Pos = 0;
      Lookup_Num = get_lookup_result(hztbl, ime_buffer, nHelpInfoMode, Lookup_Pos, Max_Lookup_Num); 
    }

    IME_Status |= IME_LOOKUP_AREA;
    return(IME_USED_KEY);

  }

  if (Is_NextPage_Key(hztbl, key)) { /* select from candidata */
    /*  if no inputted key, directly return this key */
    if (Input_Len==0) return(IME_NOT_USED_KEY);

    /* if any preedit key and not in Lookup status */
    log_f("NextPage:  Lookup_Num:%d\n", Lookup_Num);
    if (Lookup_Num==0) return(IME_USED_KEY);

    pos = Lookup_Pos + Max_Lookup_Num;
    log_f("NextPage: pos:%d\n", pos);
    hznum = get_lookup_result(hztbl, ime_buffer, nHelpInfoMode, pos, Max_Lookup_Num); 
    if (hznum > 0) {
      Lookup_Num = hznum;
      Lookup_Pos = pos;
      IME_Status = IME_LOOKUP_AREA;
    }else warning_bell();
    
    return(IME_USED_KEY);

  }

  if (Is_PrevPage_Key(hztbl, key)) { /* select from candidata */

    /*  if no inputted key, directly return this key */
    if (Input_Len==0) return(IME_NOT_USED_KEY);
    log_f("PrevPage:  Lookup_Num:%d\n", Lookup_Num);
    /* if any preedit key and not in Lookup status */
    if (Lookup_Num==0) return(IME_USED_KEY);
  
    /* if in beginning pos */
    if (Lookup_Pos<=0) {
      warning_bell();
      return(IME_USED_KEY);
    }

    pos = Lookup_Pos - Max_Lookup_Num;
    hznum = get_lookup_result(hztbl, ime_buffer, nHelpInfoMode, pos, Max_Lookup_Num); 
    log_f("hznum :%d\n", hznum);
    if (hznum > 0) {
      Lookup_Num = hznum;
      Lookup_Pos = pos;
      IME_Status = IME_LOOKUP_AREA;
    }else warning_bell();

    return(IME_USED_KEY);
  }

  if (Is_Commit_Key(hztbl, key)) { /* space or return key */
    log_f("Space or Return key, Commit Key ===\n");
    /* if no input keys and no candidates */
    if (Input_Len==0 && Lookup_Num==0) 
      return(IME_NOT_USED_KEY);

    /* if any candidates, then commit the first candidate */
    if (Lookup_Num > 0) {
      log_f("Commit Key , Commit the first candidate===\n");
      commit_candidate(ime_buffer, 0);
      return(IME_USED_KEY);
    }

    /* if any keys and key is Space key and mode is not keybykey */
    /* then search and display the candidates */
    if (key == SPACE_KEY && !nKeyByKeyMode) {
      Lookup_Pos = 0;
      Lookup_Num = get_lookup_result(hztbl, ime_buffer, nHelpInfoMode, Lookup_Pos, Max_Lookup_Num); 
      log_f("Lookup_Num:%d\n", Lookup_Num);
      if (Lookup_Num == 1 && nAutoSelectMode) {
        commit_candidate(ime_buffer, 0);
        return(IME_USED_KEY);
      }

      if (Lookup_Num == 0)
        warning_bell();

      IME_Status = IME_LOOKUP_AREA;
      return(IME_USED_KEY);
    }

    return(IME_USED_KEY);
  }

  /* for unnormal keys */
  log_f(" unnormal key:%d\n", key);
  if (Input_Len==0) return(IME_NOT_USED_KEY);
  else return(IME_USED_KEY);
}

