#!/bin/sh

if [ ! -d /usr/lib/im ]; then
    exit 0
fi

if [ ! -d /usr/lib/iiim ]; then
    exit 0
fi

if [ ! -d /usr/lib/iiim/le ]; then
    mkdir /usr/lib/iiim/le
fi

# With this symbolic link, IIIM clients can find dynamically
# loadable AUX objects under /usr/lib/im.
#
if [ ! -d /usr/lib/iiim/le/locale ]; then
    if [ -d /usr/lib/im/locale ]; then
	ln -s ../../im/locale /usr/lib/iiim/le
    fi
fi

# With these symbolic links, IIIM server can find dynamically
# loadable LE objects under /usr/lib/im.
#
ls -1 /usr/lib/im/leif | egrep '\.so$' | sed -e 's;\.so$;;' |
while read LE; do
    if [ ! -f "/usr/lib/im/leif/${LE}.so" ]; then
	continue
    fi
    if [ ! -d "/usr/lib/iiim/le/${LE}" ]; then
	mkdir "/usr/lib/iiim/le/${LE}"
    fi
    if [ ! -f "/usr/lib/iiim/le/${LE}/${LE}.so" ]; then
	ln -s "../../../im/leif/${LE}.so" "/usr/lib/iiim/le/${LE}"
    fi
done

exit 0
