#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#include <iiimp-data.h>
#include <iiimp-opcode.h>

#include "iiimp-dataP.h"


IIIMP_message *
iiimp_preedit_draw_new(
    IIIMP_data_s *	data_s,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_int32		caret,
    IIIMP_int32		change_first,
    IIIMP_int32		change_length,
    IIIMP_contents *	preedit)
{
    IIIMP_message *	m;
    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    m->opcode = IM_PREEDIT_DRAW;
    m->im_id = im_id;
    m->ic_id = ic_id;
    m->v.preedit_draw.caret = caret;
    m->v.preedit_draw.change_first = change_first;
    m->v.preedit_draw.change_length = change_length;
    m->v.preedit_draw.preedit = preedit;
    return m;
}


void
iiimp_preedit_draw_delete(IIIMP_data_s * data_s, IIIMP_message * m)
{
    if (NULL == m) return;
    iiimp_contents_delete(data_s, m->v.preedit_draw.preedit);
    free(m);
    return;
}


uchar_t *
iiimp_preedit_draw_pack(
    IIIMP_data_s *	data_s,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_int32		caret,
    IIIMP_int32		change_first,
    IIIMP_int32		change_length,
    IIIMP_contents *	preedit,
    size_t *		buf_size)
{
    size_t		nbyte;
    int			length;
    uchar_t *		buf;
    size_t		rest;
    uchar_t *		p;

    nbyte = 0;
    nbyte += 2;			/* input method id */
    nbyte += 2;			/* input context id */
    nbyte += 4;			/* caret */
    nbyte += 4;			/* change first */
    nbyte += 4;			/* change length */
    nbyte += preedit->nbyte;	/* preedit string of text */

    length = (nbyte >> 2);
    *buf_size = (1 + 3 + nbyte);

    buf = (uchar_t *)malloc(1 + 3 + nbyte);
    if (NULL == buf) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    PUT_PACKET_HEADER(buf, IM_PREEDIT_DRAW, length);

    rest = nbyte;
    p = (buf + 4);

    PUTU16(im_id, rest, p, data_s->byte_swap);
    PUTU16(ic_id, rest, p, data_s->byte_swap);
    PUTU32(caret, rest, p, data_s->byte_swap);
    PUTU32(change_first, rest, p, data_s->byte_swap);
    PUTU32(change_length, rest, p, data_s->byte_swap);
    iiimp_contents_pack(data_s, preedit, &rest, &p);

    return buf;
}


IIIMP_message *
iiimp_preedit_draw_unpack(
    IIIMP_data_s *	data_s,
    IIIMP_card7		opcode,
    size_t *		nbyte,
    const uchar_t **	ptr)
{
    IIIMP_message *		m;
    IIIMP_preedit_draw_v *	v;
    size_t			rest;
    const uchar_t *		p;

    rest = *nbyte;
    p = *ptr;

    if (rest < (2 + 2 + 4 + 4 + 4 + 4)) {
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    v = &(m->v.preedit_draw);

    m->opcode = opcode;

    GETU16(m->im_id, rest, p, data_s->byte_swap);
    GETU16(m->ic_id, rest, p, data_s->byte_swap);
    GET32(v->caret, rest, p, data_s->byte_swap);
    GET32(v->change_first, rest, p, data_s->byte_swap);
    GET32(v->change_length, rest, p, data_s->byte_swap);

    v->preedit = iiimp_contents_unpack(data_s, &rest, &p, rest);
    if (NULL == m) {
	free(m);
	return NULL;
    }

    *nbyte = rest;
    *ptr = p;

    return m;
}


void
iiimp_preedit_draw_print(
    IIIMP_data_s *	data_s,
    IIIMP_message *	m)
{
    IIIMP_preedit_draw_v *	v;

    v = &(m->v.preedit_draw);
    iiimp_message_header_print(data_s, m->opcode, m->im_id, m->ic_id);
    (void)fprintf(data_s->print_fp, "\tcaret=%d ", v->caret);
    (void)fprintf(data_s->print_fp, "change_first=%d ", v->change_first);
    (void)fprintf(data_s->print_fp, "change_length=%d\n", v->change_length);
    iiimp_contents_print(data_s, v->preedit);
}


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
