---------------
--  Options  --
---------------

options.timeout = 120
options.subscribe = true


----------------
--  Accounts  --
----------------

-- Connects to "imap1.mail.server", as user "user1" with "secret1" as password.
account1 = {
	server = 'imap1.mail.server',
	username = 'user1',
	password = 'secret1',
}

-- Another account which connects to the mail server using the SSLv3 protocol.
account2 = {
	server = 'imap2.mail.server',
	username = 'user2',
	password = 'secret2',
	ssl = 'ssl3',
}


---------------
--  Filters  --
---------------

-- The simplest filter that is possible. Matches all messages in the mailbox.
all = {}

-- A simple filter with just one rule.  Matches newly arrived, unread messages.
simple = {
	'new',
}

-- Another simple filter with two rules.  Matches unseen messages with the
-- specified "From" header.
weeklynews = {
	'unseen',
	'from "weekly-news@news.letter"',
}

-- A filter with the negation operator.  Matches messages with the specified
-- "From" header but without the specified "Subject" header.
security = {
	'from "announce@my.unix.os"',
	'not subject "security advisory"',
}

-- A filter with "inverted" AND/OR logic.  Matches messages with _any_ of the
-- specified headers.
unwanted = {
	invert = true,
	'from "marketing@company.junk"',
	'from "advertising@annoying.promotion"',
	'subject "new great products"',
}

-- A filter which considers the message's size.  Matches messages with the
-- specified "Subject" header and a size less than 50000 octets (bytes).
patch = {
	'subject "[patch]"',
	'smaller 50000',
}

-- A filter which considers the message's internal date.  Matches messages with
-- the specified "Sender" header, which have arrived in the mailbox after
-- 01/01/2004.
maillist = {
	 'header "sender" "owner@maillist.server"',
	 'since 01-Jan-2004',
}


-- A more complicated filter.  Matches recent, unseen messages, that have
-- either one of the specified "From" headers, but do not have the specified
-- phrase in the body of the message.
workplay = {
	'recent',
	'unseen',
	{ 'from "tux@penguin.land"', 'from "beastie@daemon.land"' },
	'not body "all work and no play"',
}


----------------
--  Commands  --
----------------

-- Get status (messages, recent, unseen) of the mailbox.
check(account1, 'INBOX')

-- Copy messages between mailboxes at the same account.
results = match(account1, 'INBOX', weeklynews)
copy(account1, 'INBOX', account1, 'news', results)

-- Copy messages between mailboxes at a different account.
results = match(account1, 'INBOX', patch)
copy(account1, 'INBOX', account2, 'patch', results)

-- Move messages between mailboxes at the same account.
results = match(account1, 'INBOX', maillist)
move(account1, 'INBOX', account1, 'list', results)

-- Move messages between mailboxes at a different account.
results = match(account1, 'INBOX', security)
move(account1, 'INBOX', account2, 'INBOX', results)

-- Delete messages.
results = match(account1, 'INBOX', unwanted)
delete(account1, 'INBOX', results)

-- Flag messages.
results = match(account1, 'INBOX', workplay)
flag(account1, 'INBOX', 'add', { 'seen' }, results)

