static const gunichar symbols[] = {
    0x2600,  /* black sun with rays                                          */
    0x2601,  /* cloud                                                        */
    0x2602,  /* umbrella                                                     */
    0x2603,  /* snowman                                                      */
    0x2604,  /* comet                                                        */
    0x2605,  /* black star                                                   */
    0x2606,  /* white star                                                   */
    0x2607,  /* lightning                                                    */
    0x2608,  /* thunderstorm                                                 */
    0x2609,  /* sun                                                          */
    0x260a,  /* ascending node                                               */
    0x260b,  /* descending node                                              */
    0x260c,  /* conjunction                                                  */
    0x260d,  /* opposition                                                   */
    0x260e,  /* black telephone                                              */
    0x260f,  /* white telephone                                              */
    0x2610,  /* ballot box                                                   */
    0x2611,  /* ballot box with check                                        */
    0x2612,  /* ballot box with x                                            */
    0x2613,  /* saltire                                                      */
    0x2616,  /* white shogi piece                                            */
    0x2617,  /* black shogi piece                                            */
    0x2619,  /* reversed rotated floral heart bullet                         */
    0x261a,  /* black left pointing index                                    */
    0x261b,  /* black right pointing index                                   */
    0x261c,  /* white left pointing index                                    */
    0x261d,  /* white up pointing index                                      */
    0x261e,  /* white right pointing index                                   */
    0x261f,  /* white down pointing index                                    */
    0x2620,  /* skull and crossbones                                         */
    0x2621,  /* caution sign                                                 */
    0x2622,  /* radioactive sign                                             */
    0x2623,  /* biohazard sign                                               */
    0x2624,  /* caduceus                                                     */
    0x2625,  /* ankh                                                         */
    0x2626,  /* orthodox cross                                               */
    0x2627,  /* chi rho                                                      */
    0x2628,  /* cross of lorraine                                            */
    0x2629,  /* cross of jerusalem                                           */
    0x262a,  /* star and crescent                                            */
    0x262b,  /* farsi symbol                                                 */
    0x262c,  /* adi shakti                                                   */
    0x262d,  /* hammer and sickle                                            */
    0x262e,  /* peace symbol                                                 */
    0x262f,  /* yin yang                                                     */
    0x2630,  /* trigram for heaven                                           */
    0x2631,  /* trigram for lake                                             */
    0x2632,  /* trigram for fire                                             */
    0x2633,  /* trigram for thunder                                          */
    0x2634,  /* trigram for wind                                             */
    0x2635,  /* trigram for water                                            */
    0x2636,  /* trigram for mountain                                         */
    0x2637,  /* trigram for earth                                            */
    0x2638,  /* wheel of dharma                                              */
    0x2639,  /* white frowning face                                          */
    0x263a,  /* white smiling face                                           */
    0x263b,  /* black smiling face                                           */
    0x263c,  /* white sun with rays                                          */
    0x263d,  /* first quarter moon                                           */
    0x263e,  /* last quarter moon                                            */
    0x263f,  /* mercury                                                      */
    0x2640,  /* female sign                                                  */
    0x2641,  /* earth                                                        */
    0x2642,  /* male sign                                                    */
    0x2643,  /* jupiter                                                      */
    0x2644,  /* saturn                                                       */
    0x2645,  /* uranus                                                       */
    0x2646,  /* neptune                                                      */
    0x2647,  /* pluto                                                        */
    0x2648,  /* aries                                                        */
    0x2649,  /* taurus                                                       */
    0x264a,  /* gemini                                                       */
    0x264b,  /* cancer                                                       */
    0x264c,  /* leo                                                          */
    0x264d,  /* virgo                                                        */
    0x264e,  /* libra                                                        */
    0x264f,  /* scorpius                                                     */
    0x2650,  /* sagittarius                                                  */
    0x2651,  /* capricorn                                                    */
    0x2652,  /* aquarius                                                     */
    0x2653,  /* pisces                                                       */
    0x2654,  /* white chess king                                             */
    0x2655,  /* white chess queen                                            */
    0x2656,  /* white chess rook                                             */
    0x2657,  /* white chess bishop                                           */
    0x2658,  /* white chess knight                                           */
    0x2659,  /* white chess pawn                                             */
    0x265a,  /* black chess king                                             */
    0x265b,  /* black chess queen                                            */
    0x265c,  /* black chess rook                                             */
    0x265d,  /* black chess bishop                                           */
    0x265e,  /* black chess knight                                           */
    0x265f,  /* black chess pawn                                             */
    0x2660,  /* black spade suit                                             */
    0x2661,  /* white heart suit                                             */
    0x2662,  /* white diamond suit                                           */
    0x2663,  /* black club suit                                              */
    0x2664,  /* white spade suit                                             */
    0x2665,  /* black heart suit                                             */
    0x2666,  /* black diamond suit                                           */
    0x2667,  /* white club suit                                              */
    0x2668,  /* hot springs                                                  */
    0x2669,  /* quarter note                                                 */
    0x266a,  /* eighth note                                                  */
    0x266b,  /* beamed eighth notes                                          */
    0x266c,  /* beamed sixteenth notes                                       */
    0x266d,  /* music flat sign                                              */
    0x266e,  /* music natural sign                                           */
    0x266f,  /* music sharp sign                                             */
    0x2670,  /* west syriac cross                                            */
    0x2671,  /* east syriac cross                                            */
    0x2672,  /* universal recycling symbol                                   */
    0x2673,  /* recycling symbol for type-1 plastics                         */
    0x2674,  /* recycling symbol for type-2 plastics                         */
    0x2675,  /* recycling symbol for type-3 plastics                         */
    0x2676,  /* recycling symbol for type-4 plastics                         */
    0x2677,  /* recycling symbol for type-5 plastics                         */
    0x2678,  /* recycling symbol for type-6 plastics                         */
    0x2679,  /* recycling symbol for type-7 plastics                         */
    0x267a,  /* recycling symbol for generic materials                       */
    0x267b,  /* black universal recycling symbol                             */
    0x267c,  /* recycled paper symbol                                        */
    0x267d,  /* partially-recycled paper symbol                              */
    0x2680,  /* die face-1                                                   */
    0x2681,  /* die face-2                                                   */
    0x2682,  /* die face-3                                                   */
    0x2683,  /* die face-4                                                   */
    0x2684,  /* die face-5                                                   */
    0x2685,  /* die face-6                                                   */
    0x2686,  /* white circle with dot right                                  */
    0x2687,  /* white circle with two dots                                   */
    0x2688,  /* black circle with white dot right                            */
    0x2689,  /* black circle with two white dots                             */
    0
};

static const gunichar char_symbol[] = {
    0x00a2,  /* cent sign                                                    */
    0x00a3,  /* pound sign                                                   */
    0x00a4,  /* currency sign                                                */
    0x00a5,  /* yen sign                                                     */
    0x20a0,  /* euro-currency sign                                           */
    0x20a1,  /* colon sign                                                   */
    0x20a2,  /* cruzeiro sign                                                */
    0x20a3,  /* french franc sign                                            */
    0x20a4,  /* lira sign                                                    */
    0x20a5,  /* mill sign                                                    */
    0x20a6,  /* naira sign                                                   */
    0x20a7,  /* peseta sign                                                  */
    0x20a8,  /* rupee sign                                                   */
    0x20a9,  /* won sign                                                     */
    0x20aa,  /* new sheqel sign                                              */
    0x20ab,  /* dong sign                                                    */
    0x20ac,  /* euro sign                                                    */
    0x20ad,  /* kip sign                                                     */
    0x20ae,  /* tugrik sign                                                  */
    0x20af,  /* drachma sign                                                 */
    0x20b0,  /* german penny sign                                            */
    0x20b1,  /* peso sign                                                    */

    0x2100,  /* account of                                                   */
    0x2101,  /* addressed to the subject                                     */
    0x2102,  /* double-struck capital c                                      */
    0x2103,  /* degree celsius                                               */
    0x2104,  /* centre line symbol                                           */
    0x2105,  /* care of                                                      */
    0x2106,  /* cada una                                                     */
    0x2107,  /* euler constant                                               */
    0x2108,  /* scruple                                                      */
    0x2109,  /* degree fahrenheit                                            */
    0x210a,  /* script small g                                               */
    0x210b,  /* script capital h                                             */
    0x210c,  /* black-letter capital h                                       */
    0x210d,  /* double-struck capital h                                      */
    0x210e,  /* planck constant                                              */
    0x210f,  /* planck constant over two pi                                  */
    0x2110,  /* script capital i                                             */
    0x2111,  /* black-letter capital i                                       */
    0x2112,  /* script capital l                                             */
    0x2113,  /* script small l                                               */
    0x2114,  /* l b bar symbol                                               */
    0x2115,  /* double-struck capital n                                      */
    0x2116,  /* numero sign                                                  */
    0x2117,  /* sound recording copyright                                    */
    0x2118,  /* script capital p                                             */
    0x2119,  /* double-struck capital p                                      */
    0x211a,  /* double-struck capital q                                      */
    0x211b,  /* script capital r                                             */
    0x211c,  /* black-letter capital r                                       */
    0x211d,  /* double-struck capital r                                      */
    0x211e,  /* prescription take                                            */
    0x211f,  /* response                                                     */
    0x2120,  /* service mark                                                 */
    0x2121,  /* telephone sign                                               */
    0x2122,  /* trade mark sign                                              */
    0x2123,  /* versicle                                                     */
    0x2124,  /* double-struck capital z                                      */
    0x2125,  /* ounce sign                                                   */
    0x2126,  /* ohm sign                                                     */
    0x2127,  /* inverted ohm sign                                            */
    0x2128,  /* black-letter capital z                                       */
    0x2129,  /* turned greek small letter iota                               */
    0x212a,  /* kelvin sign                                                  */
    0x212b,  /* angstrom sign                                                */
    0x212c,  /* script capital b                                             */
    0x212d,  /* black-letter capital c                                       */
    0x212e,  /* estimated symbol                                             */
    0x212f,  /* script small e                                               */
    0x2130,  /* script capital e                                             */
    0x2131,  /* script capital f                                             */
    0x2132,  /* turned capital f                                             */
    0x2133,  /* script capital m                                             */
    0x2134,  /* script small o                                               */
    0x2135,  /* alef symbol                                                  */
    0x2136,  /* bet symbol                                                   */
    0x2137,  /* gimel symbol                                                 */
    0x2138,  /* dalet symbol                                                 */
    0x2139,  /* information source                                           */
    0x213a,  /* rotated capital q                                            */
    0x213d,  /* double-struck small gamma                                    */
    0x213e,  /* double-struck capital gamma                                  */
    0x213f,  /* double-struck capital pi                                     */
    0x2140,  /* double-struck n-ary summation                                */
    0x2141,  /* turned sans-serif capital g                                  */
    0x2142,  /* turned sans-serif capital l                                  */
    0x2143,  /* reversed sans-serif capital l                                */
    0x2144,  /* turned sans-serif capital y                                  */
    0x2145,  /* double-struck italic capital d                               */
    0x2146,  /* double-struck italic small d                                 */
    0x2147,  /* double-struck italic small e                                 */
    0x2148,  /* double-struck italic small i                                 */
    0x2149,  /* double-struck italic small j                                 */
    0x214a,  /* property line                                                */
    0x214b,  /* turned ampersand                                             */

    0x327f,  /* korean standard symbol                                       */
    0x3004,  /* japanese industrial standard symbol                          */
    0
};

static const gunichar punctuation[] = {
    0x2018,  /* left single quotation mark                                   */
    0x2019,  /* right single quotation mark                                  */
    0x201a,  /* single low-9 quotation mark                                  */
    0x201b,  /* single high-reversed-9 quotation mark                        */
    0x201c,  /* left double quotation mark                                   */
    0x201d,  /* right double quotation mark                                  */
    0x201e,  /* double low-9 quotation mark                                  */
    0x201f,  /* double high-reversed-9 quotation mark                        */
    0x2020,  /* dagger                                                       */
    0x2021,  /* double dagger                                                */
    0x2022,  /* bullet                                                       */
    0x2023,  /* triangular bullet                                            */
    0x2024,  /* one dot leader                                               */
    0x2025,  /* two dot leader                                               */
    0x2026,  /* horizontal ellipsis                                          */
    0x2027,  /* hyphenation point                                            */

    0x203b,  /* reference mark                                               */
    0x00a7,  /* section sign                                                 */

    0x3001,  /* ideographic comma                                            */
    0x3002,  /* ideographic full stop                                        */
    0x3003,  /* ditto mark                                                   */
    0x3005,  /* ideographic iteration mark                                   */
    0x3006,  /* ideographic closing mark                                     */
    0x3007,  /* ideographic number zero                                      */
    0x3008,  /* left angle bracket                                           */
    0x3009,  /* right angle bracket                                          */
    0x300a,  /* left double angle bracket                                    */
    0x300b,  /* right double angle bracket                                   */
    0x300c,  /* left corner bracket                                          */
    0x300d,  /* right corner bracket                                         */
    0x300e,  /* left white corner bracket                                    */
    0x300f,  /* right white corner bracket                                   */
    0x3010,  /* left black lenticular bracket                                */
    0x3011,  /* right black lenticular bracket                               */
    0x3014,  /* left tortoise shell bracket                                  */
    0x3015,  /* right tortoise shell bracket                                 */
    0x3016,  /* left white lenticular bracket                                */
    0x3017,  /* right white lenticular bracket                               */
    0x3018,  /* left white tortoise shell bracket                            */
    0x3019,  /* right white tortoise shell bracket                           */
    0x301a,  /* left white square bracket                                    */
    0x301b,  /* right white square bracket                                   */
    0x301c,  /* wave dash                                                    */
    0x301d,  /* reversed double prime quotation mark                         */
    0x301e,  /* double prime quotation mark                                  */
    0x301f,  /* low double prime quotation mark                              */
    0
};

static const gunichar number_form[] = {
    0x2070,  /* superscript zero                                             */
    0x00b9,  /* superscript one                                              */
    0x00b2,  /* superscript two                                              */
    0x00b3,  /* superscript three                                            */
    0x2074,  /* superscript four                                             */
    0x2075,  /* superscript five                                             */
    0x2076,  /* superscript six                                              */
    0x2077,  /* superscript seven                                            */
    0x2078,  /* superscript eight                                            */
    0x2079,  /* superscript nine                                             */
    0x207a,  /* superscript plus sign                                        */
    0x207b,  /* superscript minus                                            */
    0x207c,  /* superscript equals sign                                      */
    0x207d,  /* superscript left parenthesis                                 */
    0x207e,  /* superscript right parenthesis                                */
    0x207f,  /* superscript latin small letter n                             */
    0x2080,  /* subscript zero                                               */
    0x2081,  /* subscript one                                                */
    0x2082,  /* subscript two                                                */
    0x2083,  /* subscript three                                              */
    0x2084,  /* subscript four                                               */
    0x2085,  /* subscript five                                               */
    0x2086,  /* subscript six                                                */
    0x2087,  /* subscript seven                                              */
    0x2088,  /* subscript eight                                              */
    0x2089,  /* subscript nine                                               */
    0x208a,  /* subscript plus sign                                          */
    0x208b,  /* subscript minus                                              */
    0x208c,  /* subscript equals sign                                        */
    0x208d,  /* subscript left parenthesis                                   */
    0x208e,  /* subscript right parenthesis                                  */
    0x00bd,  /* vulgar fraction one half                                     */
    0x2153,  /* vulgar fraction one third                                    */
    0x2154,  /* vulgar fraction two thirds                                   */
    0x00bc,  /* vulgar fraction one quarter                                  */
    0x00be,  /* vulgar fraction three quarters                               */
    0x2155,  /* vulgar fraction one fifth                                    */
    0x2156,  /* vulgar fraction two fifths                                   */
    0x2157,  /* vulgar fraction three fifths                                 */
    0x2158,  /* vulgar fraction four fifths                                  */
    0x2159,  /* vulgar fraction one sixth                                    */
    0x215a,  /* vulgar fraction five sixths                                  */
    0x215b,  /* vulgar fraction one eighth                                   */
    0x215c,  /* vulgar fraction three eighths                                */
    0x215d,  /* vulgar fraction five eighths                                 */
    0x215e,  /* vulgar fraction seven eighths                                */
    0x215f,  /* fraction numerator one                                       */
    0x2160,  /* roman numeral one                                            */
    0x2161,  /* roman numeral two                                            */
    0x2162,  /* roman numeral three                                          */
    0x2163,  /* roman numeral four                                           */
    0x2164,  /* roman numeral five                                           */
    0x2165,  /* roman numeral six                                            */
    0x2166,  /* roman numeral seven                                          */
    0x2167,  /* roman numeral eight                                          */
    0x2168,  /* roman numeral nine                                           */
    0x2169,  /* roman numeral ten                                            */
    0x216a,  /* roman numeral eleven                                         */
    0x216b,  /* roman numeral twelve                                         */
    0x216c,  /* roman numeral fifty                                          */
    0x216d,  /* roman numeral one hundred                                    */
    0x216e,  /* roman numeral five hundred                                   */
    0x216f,  /* roman numeral one thousand                                   */
    0x2170,  /* small roman numeral one                                      */
    0x2171,  /* small roman numeral two                                      */
    0x2172,  /* small roman numeral three                                    */
    0x2173,  /* small roman numeral four                                     */
    0x2174,  /* small roman numeral five                                     */
    0x2175,  /* small roman numeral six                                      */
    0x2176,  /* small roman numeral seven                                    */
    0x2177,  /* small roman numeral eight                                    */
    0x2178,  /* small roman numeral nine                                     */
    0x2179,  /* small roman numeral ten                                      */
    0x217a,  /* small roman numeral eleven                                   */
    0x217b,  /* small roman numeral twelve                                   */
    0x217c,  /* small roman numeral fifty                                    */
    0x217d,  /* small roman numeral one hundred                              */
    0x217e,  /* small roman numeral five hundred                             */
    0x217f,  /* small roman numeral one thousand                             */
    0x2180,  /* roman numeral one thousand c d                               */
    0x2181,  /* roman numeral five thousand                                  */
    0x2182,  /* roman numeral ten thousand                                   */
    0x2183,  /* roman numeral reversed one hundred                           */
    0
};
 
static const gunichar parenthesized[] = {
    0x2474,  /* parenthesized digit one                                      */
    0x2475,  /* parenthesized digit two                                      */
    0x2476,  /* parenthesized digit three                                    */
    0x2477,  /* parenthesized digit four                                     */
    0x2478,  /* parenthesized digit five                                     */
    0x2479,  /* parenthesized digit six                                      */
    0x247a,  /* parenthesized digit seven                                    */
    0x247b,  /* parenthesized digit eight                                    */
    0x247c,  /* parenthesized digit nine                                     */
    0x247d,  /* parenthesized number ten                                     */
    0x247e,  /* parenthesized number eleven                                  */
    0x247f,  /* parenthesized number twelve                                  */
    0x2480,  /* parenthesized number thirteen                                */
    0x2481,  /* parenthesized number fourteen                                */
    0x2482,  /* parenthesized number fifteen                                 */
    0x2483,  /* parenthesized number sixteen                                 */
    0x2484,  /* parenthesized number seventeen                               */
    0x2485,  /* parenthesized number eighteen                                */
    0x2486,  /* parenthesized number nineteen                                */
    0x2487,  /* parenthesized number twenty                                  */
    0x249c,  /* parenthesized latin small letter a                           */
    0x249d,  /* parenthesized latin small letter b                           */
    0x249e,  /* parenthesized latin small letter c                           */
    0x249f,  /* parenthesized latin small letter d                           */
    0x24a0,  /* parenthesized latin small letter e                           */
    0x24a1,  /* parenthesized latin small letter f                           */
    0x24a2,  /* parenthesized latin small letter g                           */
    0x24a3,  /* parenthesized latin small letter h                           */
    0x24a4,  /* parenthesized latin small letter i                           */
    0x24a5,  /* parenthesized latin small letter j                           */
    0x24a6,  /* parenthesized latin small letter k                           */
    0x24a7,  /* parenthesized latin small letter l                           */
    0x24a8,  /* parenthesized latin small letter m                           */
    0x24a9,  /* parenthesized latin small letter n                           */
    0x24aa,  /* parenthesized latin small letter o                           */
    0x24ab,  /* parenthesized latin small letter p                           */
    0x24ac,  /* parenthesized latin small letter q                           */
    0x24ad,  /* parenthesized latin small letter r                           */
    0x24ae,  /* parenthesized latin small letter s                           */
    0x24af,  /* parenthesized latin small letter t                           */
    0x24b0,  /* parenthesized latin small letter u                           */
    0x24b1,  /* parenthesized latin small letter v                           */
    0x24b2,  /* parenthesized latin small letter w                           */
    0x24b3,  /* parenthesized latin small letter x                           */
    0x24b4,  /* parenthesized latin small letter y                           */
    0x24b5,  /* parenthesized latin small letter z                           */
    0x3200,  /* parenthesized hangul kiyeok                                  */
    0x3201,  /* parenthesized hangul nieun                                   */
    0x3202,  /* parenthesized hangul tikeut                                  */
    0x3203,  /* parenthesized hangul rieul                                   */
    0x3204,  /* parenthesized hangul mieum                                   */
    0x3205,  /* parenthesized hangul pieup                                   */
    0x3206,  /* parenthesized hangul sios                                    */
    0x3207,  /* parenthesized hangul ieung                                   */
    0x3208,  /* parenthesized hangul cieuc                                   */
    0x3209,  /* parenthesized hangul chieuch                                 */
    0x320a,  /* parenthesized hangul khieukh                                 */
    0x320b,  /* parenthesized hangul thieuth                                 */
    0x320c,  /* parenthesized hangul phieuph                                 */
    0x320d,  /* parenthesized hangul hieuh                                   */
    0x320e,  /* parenthesized hangul kiyeok a                                */
    0x320f,  /* parenthesized hangul nieun a                                 */
    0x3210,  /* parenthesized hangul tikeut a                                */
    0x3211,  /* parenthesized hangul rieul a                                 */
    0x3212,  /* parenthesized hangul mieum a                                 */
    0x3213,  /* parenthesized hangul pieup a                                 */
    0x3214,  /* parenthesized hangul sios a                                  */
    0x3215,  /* parenthesized hangul ieung a                                 */
    0x3216,  /* parenthesized hangul cieuc a                                 */
    0x3217,  /* parenthesized hangul chieuch a                               */
    0x3218,  /* parenthesized hangul khieukh a                               */
    0x3219,  /* parenthesized hangul thieuth a                               */
    0x321a,  /* parenthesized hangul phieuph a                               */
    0x321b,  /* parenthesized hangul hieuh a                                 */
    0x321c,  /* parenthesized hangul cieuc u                                 */
    0x3220,  /* parenthesized ideograph one                                  */
    0x3221,  /* parenthesized ideograph two                                  */
    0x3222,  /* parenthesized ideograph three                                */
    0x3223,  /* parenthesized ideograph four                                 */
    0x3224,  /* parenthesized ideograph five                                 */
    0x3225,  /* parenthesized ideograph six                                  */
    0x3226,  /* parenthesized ideograph seven                                */
    0x3227,  /* parenthesized ideograph eight                                */
    0x3228,  /* parenthesized ideograph nine                                 */
    0x3229,  /* parenthesized ideograph ten                                  */
    0x322a,  /* parenthesized ideograph moon                                 */
    0x322b,  /* parenthesized ideograph fire                                 */
    0x322c,  /* parenthesized ideograph water                                */
    0x322d,  /* parenthesized ideograph wood                                 */
    0x322e,  /* parenthesized ideograph metal                                */
    0x322f,  /* parenthesized ideograph earth                                */
    0x3230,  /* parenthesized ideograph sun                                  */
    0x3231,  /* parenthesized ideograph stock                                */
    0x3232,  /* parenthesized ideograph have                                 */
    0x3233,  /* parenthesized ideograph society                              */
    0x3234,  /* parenthesized ideograph name                                 */
    0x3235,  /* parenthesized ideograph special                              */
    0x3236,  /* parenthesized ideograph financial                            */
    0x3237,  /* parenthesized ideograph congratulation                       */
    0x3238,  /* parenthesized ideograph labor                                */
    0x3239,  /* parenthesized ideograph represent                            */
    0x323a,  /* parenthesized ideograph call                                 */
    0x323b,  /* parenthesized ideograph study                                */
    0x323c,  /* parenthesized ideograph supervise                            */
    0x323d,  /* parenthesized ideograph enterprise                           */
    0x323e,  /* parenthesized ideograph resource                             */
    0x323f,  /* parenthesized ideograph alliance                             */
    0x3240,  /* parenthesized ideograph festival                             */
    0x3241,  /* parenthesized ideograph rest                                 */
    0x3242,  /* parenthesized ideograph self                                 */
    0x3243,  /* parenthesized ideograph reach                                */
    0
};

static const gunichar circled[] = {
    0x24ea,  /* circled digit zero                                           */
    0x2460,  /* circled digit one                                            */
    0x2461,  /* circled digit two                                            */
    0x2462,  /* circled digit three                                          */
    0x2463,  /* circled digit four                                           */
    0x2464,  /* circled digit five                                           */
    0x2465,  /* circled digit six                                            */
    0x2466,  /* circled digit seven                                          */
    0x2467,  /* circled digit eight                                          */
    0x2468,  /* circled digit nine                                           */
    0x2469,  /* circled number ten                                           */
    0x246a,  /* circled number eleven                                        */
    0x246b,  /* circled number twelve                                        */
    0x246c,  /* circled number thirteen                                      */
    0x246d,  /* circled number fourteen                                      */
    0x246e,  /* circled number fifteen                                       */
    0x246f,  /* circled number sixteen                                       */
    0x2470,  /* circled number seventeen                                     */
    0x2471,  /* circled number eighteen                                      */
    0x2472,  /* circled number nineteen                                      */
    0x2473,  /* circled number twenty                                        */
    0x3251,  /* circled number twenty one                                    */
    0x3252,  /* circled number twenty two                                    */
    0x3253,  /* circled number twenty three                                  */
    0x3254,  /* circled number twenty four                                   */
    0x3255,  /* circled number twenty five                                   */
    0x3256,  /* circled number twenty six                                    */
    0x3257,  /* circled number twenty seven                                  */
    0x3258,  /* circled number twenty eight                                  */
    0x3259,  /* circled number twenty nine                                   */
    0x325a,  /* circled number thirty                                        */
    0x325b,  /* circled number thirty one                                    */
    0x325c,  /* circled number thirty two                                    */
    0x325d,  /* circled number thirty three                                  */
    0x325e,  /* circled number thirty four                                   */
    0x325f,  /* circled number thirty five                                   */
    0x32b1,  /* circled number thirty six                                    */
    0x32b2,  /* circled number thirty seven                                  */
    0x32b3,  /* circled number thirty eight                                  */
    0x32b4,  /* circled number thirty nine                                   */
    0x32b5,  /* circled number forty                                         */
    0x32b6,  /* circled number forty one                                     */
    0x32b7,  /* circled number forty two                                     */
    0x32b8,  /* circled number forty three                                   */
    0x32b9,  /* circled number forty four                                    */
    0x32ba,  /* circled number forty five                                    */
    0x32bb,  /* circled number forty six                                     */
    0x32bc,  /* circled number forty seven                                   */
    0x32bd,  /* circled number forty eight                                   */
    0x32be,  /* circled number forty nine                                    */
    0x32bf,  /* circled number fifty                                         */
    0x24b6,  /* circled latin capital letter a                               */
    0x24b7,  /* circled latin capital letter b                               */
    0x24b8,  /* circled latin capital letter c                               */
    0x24b9,  /* circled latin capital letter d                               */
    0x24ba,  /* circled latin capital letter e                               */
    0x24bb,  /* circled latin capital letter f                               */
    0x24bc,  /* circled latin capital letter g                               */
    0x24bd,  /* circled latin capital letter h                               */
    0x24be,  /* circled latin capital letter i                               */
    0x24bf,  /* circled latin capital letter j                               */
    0x24c0,  /* circled latin capital letter k                               */
    0x24c1,  /* circled latin capital letter l                               */
    0x24c2,  /* circled latin capital letter m                               */
    0x24c3,  /* circled latin capital letter n                               */
    0x24c4,  /* circled latin capital letter o                               */
    0x24c5,  /* circled latin capital letter p                               */
    0x24c6,  /* circled latin capital letter q                               */
    0x24c7,  /* circled latin capital letter r                               */
    0x24c8,  /* circled latin capital letter s                               */
    0x24c9,  /* circled latin capital letter t                               */
    0x24ca,  /* circled latin capital letter u                               */
    0x24cb,  /* circled latin capital letter v                               */
    0x24cc,  /* circled latin capital letter w                               */
    0x24cd,  /* circled latin capital letter x                               */
    0x24ce,  /* circled latin capital letter y                               */
    0x24cf,  /* circled latin capital letter z                               */
    0x24d0,  /* circled latin small letter a                                 */
    0x24d1,  /* circled latin small letter b                                 */
    0x24d2,  /* circled latin small letter c                                 */
    0x24d3,  /* circled latin small letter d                                 */
    0x24d4,  /* circled latin small letter e                                 */
    0x24d5,  /* circled latin small letter f                                 */
    0x24d6,  /* circled latin small letter g                                 */
    0x24d7,  /* circled latin small letter h                                 */
    0x24d8,  /* circled latin small letter i                                 */
    0x24d9,  /* circled latin small letter j                                 */
    0x24da,  /* circled latin small letter k                                 */
    0x24db,  /* circled latin small letter l                                 */
    0x24dc,  /* circled latin small letter m                                 */
    0x24dd,  /* circled latin small letter n                                 */
    0x24de,  /* circled latin small letter o                                 */
    0x24df,  /* circled latin small letter p                                 */
    0x24e0,  /* circled latin small letter q                                 */
    0x24e1,  /* circled latin small letter r                                 */
    0x24e2,  /* circled latin small letter s                                 */
    0x24e3,  /* circled latin small letter t                                 */
    0x24e4,  /* circled latin small letter u                                 */
    0x24e5,  /* circled latin small letter v                                 */
    0x24e6,  /* circled latin small letter w                                 */
    0x24e7,  /* circled latin small letter x                                 */
    0x24e8,  /* circled latin small letter y                                 */
    0x24e9,  /* circled latin small letter z                                 */
    0x3260,  /* circled hangul kiyeok                                        */
    0x3261,  /* circled hangul nieun                                         */
    0x3262,  /* circled hangul tikeut                                        */
    0x3263,  /* circled hangul rieul                                         */
    0x3264,  /* circled hangul mieum                                         */
    0x3265,  /* circled hangul pieup                                         */
    0x3266,  /* circled hangul sios                                          */
    0x3267,  /* circled hangul ieung                                         */
    0x3268,  /* circled hangul cieuc                                         */
    0x3269,  /* circled hangul chieuch                                       */
    0x326a,  /* circled hangul khieukh                                       */
    0x326b,  /* circled hangul thieuth                                       */
    0x326c,  /* circled hangul phieuph                                       */
    0x326d,  /* circled hangul hieuh                                         */
    0x326e,  /* circled hangul kiyeok a                                      */
    0x326f,  /* circled hangul nieun a                                       */
    0x3270,  /* circled hangul tikeut a                                      */
    0x3271,  /* circled hangul rieul a                                       */
    0x3272,  /* circled hangul mieum a                                       */
    0x3273,  /* circled hangul pieup a                                       */
    0x3274,  /* circled hangul sios a                                        */
    0x3275,  /* circled hangul ieung a                                       */
    0x3276,  /* circled hangul cieuc a                                       */
    0x3277,  /* circled hangul chieuch a                                     */
    0x3278,  /* circled hangul khieukh a                                     */
    0x3279,  /* circled hangul thieuth a                                     */
    0x327a,  /* circled hangul phieuph a                                     */
    0x327b,  /* circled hangul hieuh a                                       */
    0x3280,  /* circled ideograph one                                        */
    0x3281,  /* circled ideograph two                                        */
    0x3282,  /* circled ideograph three                                      */
    0x3283,  /* circled ideograph four                                       */
    0x3284,  /* circled ideograph five                                       */
    0x3285,  /* circled ideograph six                                        */
    0x3286,  /* circled ideograph seven                                      */
    0x3287,  /* circled ideograph eight                                      */
    0x3288,  /* circled ideograph nine                                       */
    0x3289,  /* circled ideograph ten                                        */
    0x328a,  /* circled ideograph moon                                       */
    0x328b,  /* circled ideograph fire                                       */
    0x328c,  /* circled ideograph water                                      */
    0x328d,  /* circled ideograph wood                                       */
    0x328e,  /* circled ideograph metal                                      */
    0x328f,  /* circled ideograph earth                                      */
    0x3290,  /* circled ideograph sun                                        */
    0x3291,  /* circled ideograph stock                                      */
    0x3292,  /* circled ideograph have                                       */
    0x3293,  /* circled ideograph society                                    */
    0x3294,  /* circled ideograph name                                       */
    0x3295,  /* circled ideograph special                                    */
    0x3296,  /* circled ideograph financial                                  */
    0x3297,  /* circled ideograph congratulation                             */
    0x3298,  /* circled ideograph labor                                      */
    0x3299,  /* circled ideograph secret                                     */
    0x329a,  /* circled ideograph male                                       */
    0x329b,  /* circled ideograph female                                     */
    0x329c,  /* circled ideograph suitable                                   */
    0x329d,  /* circled ideograph excellent                                  */
    0x329e,  /* circled ideograph print                                      */
    0x329f,  /* circled ideograph attention                                  */
    0x32a0,  /* circled ideograph item                                       */
    0x32a1,  /* circled ideograph rest                                       */
    0x32a2,  /* circled ideograph copy                                       */
    0x32a3,  /* circled ideograph correct                                    */
    0x32a4,  /* circled ideograph high                                       */
    0x32a5,  /* circled ideograph centre                                     */
    0x32a6,  /* circled ideograph low                                        */
    0x32a7,  /* circled ideograph left                                       */
    0x32a8,  /* circled ideograph right                                      */
    0x32a9,  /* circled ideograph medicine                                   */
    0x32aa,  /* circled ideograph religion                                   */
    0x32ab,  /* circled ideograph study                                      */
    0x32ac,  /* circled ideograph supervise                                  */
    0x32ad,  /* circled ideograph enterprise                                 */
    0x32ae,  /* circled ideograph resource                                   */
    0x32af,  /* circled ideograph alliance                                   */
    0x32b0,  /* circled ideograph night                                      */
    0
};

static const gunichar math1[] = {
    0x00b1,  /* plus-minus sign                                              */
    0x00d7,  /* multiplication sign                                          */
    0x00f7,  /* division sign                                                */
    0x2200,  /* for all                                                      */
    0x2201,  /* complement                                                   */
    0x2202,  /* partial differential                                         */
    0x2203,  /* there exists                                                 */
    0x2204,  /* there does not exist                                         */
    0x2205,  /* empty set                                                    */
    0x2206,  /* increment                                                    */
    0x2207,  /* nabla                                                        */
    0x2208,  /* element of                                                   */
    0x2209,  /* not an element of                                            */
    0x220a,  /* small element of                                             */
    0x220b,  /* contains as member                                           */
    0x220c,  /* does not contain as member                                   */
    0x220d,  /* small contains as member                                     */
    0x220e,  /* end of proof                                                 */
    0x220f,  /* n-ary product                                                */
    0x2210,  /* n-ary coproduct                                              */
    0x2211,  /* n-ary summation                                              */
    0x2212,  /* minus sign                                                   */
    0x2213,  /* minus-or-plus sign                                           */
    0x2214,  /* dot plus                                                     */
    0x2215,  /* division slash                                               */
    0x2216,  /* set minus                                                    */
    0x2217,  /* asterisk operator                                            */
    0x2218,  /* ring operator                                                */
    0x2219,  /* bullet operator                                              */
    0x221a,  /* square root                                                  */
    0x221b,  /* cube root                                                    */
    0x221c,  /* fourth root                                                  */
    0x221d,  /* proportional to                                              */
    0x221e,  /* infinity                                                     */
    0x221f,  /* right angle                                                  */
    0x2220,  /* angle                                                        */
    0x2221,  /* measured angle                                               */
    0x2222,  /* spherical angle                                              */
    0x2223,  /* divides                                                      */
    0x2224,  /* does not divide                                              */
    0x2225,  /* parallel to                                                  */
    0x2226,  /* not parallel to                                              */
    0x2227,  /* logical and                                                  */
    0x2228,  /* logical or                                                   */
    0x2229,  /* intersection                                                 */
    0x222a,  /* union                                                        */
    0x222b,  /* integral                                                     */
    0x222c,  /* double integral                                              */
    0x222d,  /* triple integral                                              */
    0x222e,  /* contour integral                                             */
    0x222f,  /* surface integral                                             */
    0x2230,  /* volume integral                                              */
    0x2231,  /* clockwise integral                                           */
    0x2232,  /* clockwise contour integral                                   */
    0x2233,  /* anticlockwise contour integral                               */
    0x2234,  /* therefore                                                    */
    0x2235,  /* because                                                      */
    0x2236,  /* ratio                                                        */
    0x2237,  /* proportion                                                   */
    0x2238,  /* dot minus                                                    */
    0x2239,  /* excess                                                       */
    0x223a,  /* geometric proportion                                         */
    0x223b,  /* homothetic                                                   */
    0x223c,  /* tilde operator                                               */
    0x223d,  /* reversed tilde                                               */
    0x223e,  /* inverted lazy s                                              */
    0x223f,  /* sine wave                                                    */
    0x2240,  /* wreath product                                               */
    0x2241,  /* not tilde                                                    */
    0x2242,  /* minus tilde                                                  */
    0x2243,  /* asymptotically equal to                                      */
    0x2244,  /* not asymptotically equal to                                  */
    0x2245,  /* approximately equal to                                       */
    0x2246,  /* approximately but not actually equal to                      */
    0x2247,  /* neither approximately nor actually equal to                  */
    0x2248,  /* almost equal to                                              */
    0x2249,  /* not almost equal to                                          */
    0x224a,  /* almost equal or equal to                                     */
    0x224b,  /* triple tilde                                                 */
    0x224c,  /* all equal to                                                 */
    0x224d,  /* equivalent to                                                */
    0x224e,  /* geometrically equivalent to                                  */
    0x224f,  /* difference between                                           */
    0x2250,  /* approaches the limit                                         */
    0x2251,  /* geometrically equal to                                       */
    0x2252,  /* approximately equal to or the image of                       */
    0x2253,  /* image of or approximately equal to                           */
    0x2254,  /* colon equals                                                 */
    0x2255,  /* equals colon                                                 */
    0x2256,  /* ring in equal to                                             */
    0x2257,  /* ring equal to                                                */
    0x2258,  /* corresponds to                                               */
    0x2259,  /* estimates                                                    */
    0x225a,  /* equiangular to                                               */
    0x225b,  /* star equals                                                  */
    0x225c,  /* delta equal to                                               */
    0x225d,  /* equal to by definition                                       */
    0x225e,  /* measured by                                                  */
    0x225f,  /* questioned equal to                                          */
    0x2260,  /* not equal to                                                 */
    0x2261,  /* identical to                                                 */
    0x2262,  /* not identical to                                             */
    0x2263,  /* strictly equivalent to                                       */
    0x2264,  /* less-than or equal to                                        */
    0x2265,  /* greater-than or equal to                                     */
    0x2266,  /* less-than over equal to                                      */
    0x2267,  /* greater-than over equal to                                   */
    0x2268,  /* less-than but not equal to                                   */
    0x2269,  /* greater-than but not equal to                                */
    0x226a,  /* much less-than                                               */
    0x226b,  /* much greater-than                                            */
    0x226c,  /* between                                                      */
    0x226d,  /* not equivalent to                                            */
    0x226e,  /* not less-than                                                */
    0x226f,  /* not greater-than                                             */
    0x2270,  /* neither less-than nor equal to                               */
    0x2271,  /* neither greater-than nor equal to                            */
    0x2272,  /* less-than or equivalent to                                   */
    0x2273,  /* greater-than or equivalent to                                */
    0x2274,  /* neither less-than nor equivalent to                          */
    0x2275,  /* neither greater-than nor equivalent to                       */
    0x2276,  /* less-than or greater-than                                    */
    0x2277,  /* greater-than or less-than                                    */
    0x2278,  /* neither less-than nor greater-than                           */
    0x2279,  /* neither greater-than nor less-than                           */
    0x227a,  /* precedes                                                     */
    0x227b,  /* succeeds                                                     */
    0x227c,  /* precedes or equal to                                         */
    0x227d,  /* succeeds or equal to                                         */
    0x227e,  /* precedes or equivalent to                                    */
    0x227f,  /* succeeds or equivalent to                                    */
    0x2280,  /* does not precede                                             */
    0x2281,  /* does not succeed                                             */
    0
};

static const gunichar math2[] = {
    0x2282,  /* subset of                                                    */
    0x2283,  /* superset of                                                  */
    0x2284,  /* not a subset of                                              */
    0x2285,  /* not a superset of                                            */
    0x2286,  /* subset of or equal to                                        */
    0x2287,  /* superset of or equal to                                      */
    0x2288,  /* neither a subset of nor equal to                             */
    0x2289,  /* neither a superset of nor equal to                           */
    0x228a,  /* subset of with not equal to                                  */
    0x228b,  /* superset of with not equal to                                */
    0x228c,  /* multiset                                                     */
    0x228d,  /* multiset multiplication                                      */
    0x228e,  /* multiset union                                               */
    0x228f,  /* square image of                                              */
    0x2290,  /* square original of                                           */
    0x2291,  /* square image of or equal to                                  */
    0x2292,  /* square original of or equal to                               */
    0x2293,  /* square cap                                                   */
    0x2294,  /* square cup                                                   */
    0x2295,  /* circled plus                                                 */
    0x2296,  /* circled minus                                                */
    0x2297,  /* circled times                                                */
    0x2298,  /* circled division slash                                       */
    0x2299,  /* circled dot operator                                         */
    0x229a,  /* circled ring operator                                        */
    0x229b,  /* circled asterisk operator                                    */
    0x229c,  /* circled equals                                               */
    0x229d,  /* circled dash                                                 */
    0x229e,  /* squared plus                                                 */
    0x229f,  /* squared minus                                                */
    0x22a0,  /* squared times                                                */
    0x22a1,  /* squared dot operator                                         */
    0x22a2,  /* right tack                                                   */
    0x22a3,  /* left tack                                                    */
    0x22a4,  /* down tack                                                    */
    0x22a5,  /* up tack                                                      */
    0x22a6,  /* assertion                                                    */
    0x22a7,  /* models                                                       */
    0x22a8,  /* true                                                         */
    0x22a9,  /* forces                                                       */
    0x22aa,  /* triple vertical bar right turnstile                          */
    0x22ab,  /* double vertical bar double right turnstile                   */
    0x22ac,  /* does not prove                                               */
    0x22ad,  /* not true                                                     */
    0x22ae,  /* does not force                                               */
    0x22af,  /* negated double vertical bar double right turnstile           */
    0x22b0,  /* precedes under relation                                      */
    0x22b1,  /* succeeds under relation                                      */
    0x22b2,  /* normal subgroup of                                           */
    0x22b3,  /* contains as normal subgroup                                  */
    0x22b4,  /* normal subgroup of or equal to                               */
    0x22b5,  /* contains as normal subgroup or equal to                      */
    0x22b6,  /* original of                                                  */
    0x22b7,  /* image of                                                     */
    0x22b8,  /* multimap                                                     */
    0x22b9,  /* hermitian conjugate matrix                                   */
    0x22ba,  /* intercalate                                                  */
    0x22bb,  /* xor                                                          */
    0x22bc,  /* nand                                                         */
    0x22bd,  /* nor                                                          */
    0x22be,  /* right angle with arc                                         */
    0x22bf,  /* right triangle                                               */
    0x22c0,  /* n-ary logical and                                            */
    0x22c1,  /* n-ary logical or                                             */
    0x22c2,  /* n-ary intersection                                           */
    0x22c3,  /* n-ary union                                                  */
    0x22c4,  /* diamond operator                                             */
    0x22c5,  /* dot operator                                                 */
    0x22c6,  /* star operator                                                */
    0x22c7,  /* division times                                               */
    0x22c8,  /* bowtie                                                       */
    0x22c9,  /* left normal factor semidirect product                        */
    0x22ca,  /* right normal factor semidirect product                       */
    0x22cb,  /* left semidirect product                                      */
    0x22cc,  /* right semidirect product                                     */
    0x22cd,  /* reversed tilde equals                                        */
    0x22ce,  /* curly logical or                                             */
    0x22cf,  /* curly logical and                                            */
    0x22d0,  /* double subset                                                */
    0x22d1,  /* double superset                                              */
    0x22d2,  /* double intersection                                          */
    0x22d3,  /* double union                                                 */
    0x22d4,  /* pitchfork                                                    */
    0x22d5,  /* equal and parallel to                                        */
    0x22d6,  /* less-than with dot                                           */
    0x22d7,  /* greater-than with dot                                        */
    0x22d8,  /* very much less-than                                          */
    0x22d9,  /* very much greater-than                                       */
    0x22da,  /* less-than equal to or greater-than                           */
    0x22db,  /* greater-than equal to or less-than                           */
    0x22dc,  /* equal to or less-than                                        */
    0x22dd,  /* equal to or greater-than                                     */
    0x22de,  /* equal to or precedes                                         */
    0x22df,  /* equal to or succeeds                                         */
    0x22e0,  /* does not precede or equal                                    */
    0x22e1,  /* does not succeed or equal                                    */
    0x22e2,  /* not square image of or equal to                              */
    0x22e3,  /* not square original of or equal to                           */
    0x22e4,  /* square image of or not equal to                              */
    0x22e5,  /* square original of or not equal to                           */
    0x22e6,  /* less-than but not equivalent to                              */
    0x22e7,  /* greater-than but not equivalent to                           */
    0x22e8,  /* precedes but not equivalent to                               */
    0x22e9,  /* succeeds but not equivalent to                               */
    0x22ea,  /* not normal subgroup of                                       */
    0x22eb,  /* does not contain as normal subgroup                          */
    0x22ec,  /* not normal subgroup of or equal to                           */
    0x22ed,  /* does not contain as normal subgroup or equal                 */
    0x22ee,  /* vertical ellipsis                                            */
    0x22ef,  /* midline horizontal ellipsis                                  */
    0x22f0,  /* up right diagonal ellipsis                                   */
    0x22f1,  /* down right diagonal ellipsis                                 */
    0x22f2,  /* element of with long horizontal stroke                       */
    0x22f3,  /* element of with vertical bar at end of horizontal stroke     */
    0x22f4,  /* small element of with vertical bar at end of horizontal strok*/
    0x22f5,  /* element of with dot above                                    */
    0x22f6,  /* element of with overbar                                      */
    0x22f7,  /* small element of with overbar                                */
    0x22f8,  /* element of with underbar                                     */
    0x22f9,  /* element of with two horizontal strokes                       */
    0x22fa,  /* contains with long horizontal stroke                         */
    0x22fb,  /* contains with vertical bar at end of horizontal stroke       */
    0x22fc,  /* small contains with vertical bar at end of horizontal stroke */
    0x22fd,  /* contains with overbar                                        */
    0x22fe,  /* small contains with overbar                                  */
    0x22ff,  /* z notation bag membership                                    */
    0
};

static const gunichar greek[] = {
    0x0391,  /* greek capital letter alpha                                   */
    0x0392,  /* greek capital letter beta                                    */
    0x0393,  /* greek capital letter gamma                                   */
    0x0394,  /* greek capital letter delta                                   */
    0x0395,  /* greek capital letter epsilon                                 */
    0x0396,  /* greek capital letter zeta                                    */
    0x0397,  /* greek capital letter eta                                     */
    0x0398,  /* greek capital letter theta                                   */
    0x0399,  /* greek capital letter iota                                    */
    0x039a,  /* greek capital letter kappa                                   */
    0x039b,  /* greek capital letter lamda                                   */
    0x039c,  /* greek capital letter mu                                      */
    0x039d,  /* greek capital letter nu                                      */
    0x039e,  /* greek capital letter xi                                      */
    0x039f,  /* greek capital letter omicron                                 */
    0x03a0,  /* greek capital letter pi                                      */
    0x03a1,  /* greek capital letter rho                                     */
    0x03a3,  /* greek capital letter sigma                                   */
    0x03a4,  /* greek capital letter tau                                     */
    0x03a5,  /* greek capital letter upsilon                                 */
    0x03a6,  /* greek capital letter phi                                     */
    0x03a7,  /* greek capital letter chi                                     */
    0x03a8,  /* greek capital letter psi                                     */
    0x03a9,  /* greek capital letter omega                                   */
    0x03b1,  /* greek small letter alpha                                     */
    0x03b2,  /* greek small letter beta                                      */
    0x03b3,  /* greek small letter gamma                                     */
    0x03b4,  /* greek small letter delta                                     */
    0x03b5,  /* greek small letter epsilon                                   */
    0x03b6,  /* greek small letter zeta                                      */
    0x03b7,  /* greek small letter eta                                       */
    0x03b8,  /* greek small letter theta                                     */
    0x03b9,  /* greek small letter iota                                      */
    0x03ba,  /* greek small letter kappa                                     */
    0x03bb,  /* greek small letter lamda                                     */
    0x03bc,  /* greek small letter mu                                        */
    0x03bd,  /* greek small letter nu                                        */
    0x03be,  /* greek small letter xi                                        */
    0x03bf,  /* greek small letter omicron                                   */
    0x03c0,  /* greek small letter pi                                        */
    0x03c1,  /* greek small letter rho                                       */
    0x03c2,  /* greek small letter final sigma                               */
    0x03c3,  /* greek small letter sigma                                     */
    0x03c4,  /* greek small letter tau                                       */
    0x03c5,  /* greek small letter upsilon                                   */
    0x03c6,  /* greek small letter phi                                       */
    0x03c7,  /* greek small letter chi                                       */
    0x03c8,  /* greek small letter psi                                       */
    0x03c9,  /* greek small letter omega                                     */
    0
};

static const gunichar hangul_cjamo[] = {
    0x3131,  /* hangul letter kiyeok              */
    0x3132,  /* hangul letter ssangkiyeok         */
    0x3133,  /* hangul letter kiyeok-sios         */
    0x3134,  /* hangul letter nieun               */
    0x3135,  /* hangul letter nieun-cieuc         */
    0x3136,  /* hangul letter nieun-hieuh         */
    0x3137,  /* hangul letter tikeut              */
    0x3138,  /* hangul letter ssangtikeut         */
    0x3139,  /* hangul letter rieul               */
    0x313a,  /* hangul letter rieul-kiyeok        */
    0x313b,  /* hangul letter rieul-mieum         */
    0x313c,  /* hangul letter rieul-pieup         */
    0x313d,  /* hangul letter rieul-sios          */
    0x313e,  /* hangul letter rieul-thieuth       */
    0x313f,  /* hangul letter rieul-phieuph       */
    0x3140,  /* hangul letter rieul-hieuh         */
    0x3141,  /* hangul letter mieum               */
    0x3142,  /* hangul letter pieup               */
    0x3143,  /* hangul letter ssangpieup          */
    0x3144,  /* hangul letter pieup-sios          */
    0x3145,  /* hangul letter sios                */
    0x3146,  /* hangul letter ssangsios           */
    0x3147,  /* hangul letter ieung               */
    0x3148,  /* hangul letter cieuc               */
    0x3149,  /* hangul letter ssangcieuc          */
    0x314a,  /* hangul letter chieuch             */
    0x314b,  /* hangul letter khieukh             */
    0x314c,  /* hangul letter thieuth             */
    0x314d,  /* hangul letter phieuph             */
    0x314e,  /* hangul letter hieuh               */
    0x314f,  /* hangul letter a                   */
    0x3150,  /* hangul letter ae                  */
    0x3151,  /* hangul letter ya                  */
    0x3152,  /* hangul letter yae                 */
    0x3153,  /* hangul letter eo                  */
    0x3154,  /* hangul letter e                   */
    0x3155,  /* hangul letter yeo                 */
    0x3156,  /* hangul letter ye                  */
    0x3157,  /* hangul letter o                   */
    0x3158,  /* hangul letter wa                  */
    0x3159,  /* hangul letter wae                 */
    0x315a,  /* hangul letter oe                  */
    0x315b,  /* hangul letter yo                  */
    0x315c,  /* hangul letter u                   */
    0x315d,  /* hangul letter weo                 */
    0x315e,  /* hangul letter we                  */
    0x315f,  /* hangul letter wi                  */
    0x3160,  /* hangul letter yu                  */
    0x3161,  /* hangul letter eu                  */
    0x3162,  /* hangul letter yi                  */
    0x3163,  /* hangul letter i                   */
    0x3165,  /* hangul letter ssangnieun          */
    0x3166,  /* hangul letter nieun-tikeut        */
    0x3167,  /* hangul letter nieun-sios          */
    0x3168,  /* hangul letter nieun-pansios       */
    0x3169,  /* hangul letter rieul-kiyeok-sios   */
    0x316a,  /* hangul letter rieul-tikeut        */
    0x316b,  /* hangul letter rieul-pieup-sios    */
    0x316c,  /* hangul letter rieul-pansios       */
    0x316d,  /* hangul letter rieul-yeorinhieuh   */
    0x316e,  /* hangul letter mieum-pieup         */
    0x316f,  /* hangul letter mieum-sios          */
    0x3170,  /* hangul letter mieum-pansios       */
    0x3171,  /* hangul letter kapyeounmieum       */
    0x3172,  /* hangul letter pieup-kiyeok        */
    0x3173,  /* hangul letter pieup-tikeut        */
    0x3174,  /* hangul letter pieup-sios-kiyeok   */
    0x3175,  /* hangul letter pieup-sios-tikeut   */
    0x3176,  /* hangul letter pieup-cieuc         */
    0x3177,  /* hangul letter pieup-thieuth       */
    0x3178,  /* hangul letter kapyeounpieup       */
    0x3179,  /* hangul letter kapyeounssangpieup  */
    0x317a,  /* hangul letter sios-kiyeok         */
    0x317b,  /* hangul letter sios-nieun          */
    0x317c,  /* hangul letter sios-tikeut         */
    0x317d,  /* hangul letter sios-pieup          */
    0x317e,  /* hangul letter sios-cieuc          */
    0x317f,  /* hangul letter pansios             */
    0x3180,  /* hangul letter ssangieung          */
    0x3181,  /* hangul letter yesieung            */
    0x3182,  /* hangul letter yesieung-sios       */
    0x3183,  /* hangul letter yesieung-pansios    */
    0x3184,  /* hangul letter kapyeounphieuph     */
    0x3185,  /* hangul letter ssanghieuh          */
    0x3186,  /* hangul letter yeorinhieuh         */
    0x3187,  /* hangul letter yo-ya               */
    0x3188,  /* hangul letter yo-yae              */
    0x3189,  /* hangul letter yo-i                */
    0x318a,  /* hangul letter yu-yeo              */
    0x318b,  /* hangul letter yu-ye               */
    0x318c,  /* hangul letter yu-i                */
    0x318d,  /* hangul letter araea               */
    0x318e,  /* hangul letter araeae              */
    0
};

static const gunichar katakana[] = {
    0x30a1,  /* katakana small a      */      
    0x30a2,  /* katakana a            */
    0x30a3,  /* katakana small i      */
    0x30a4,  /* katakana i            */
    0x30a5,  /* katakana small u      */
    0x30a6,  /* katakana u            */
    0x30a7,  /* katakana small e      */
    0x30a8,  /* katakana e            */
    0x30a9,  /* katakana small o      */
    0x30aa,  /* katakana o            */

    0x30ab,  /* katakana ka           */
    0x30ac,  /* katakana ga           */
    0x30ad,  /* katakana ki           */
    0x30ae,  /* katakana gi           */
    0x30af,  /* katakana ku           */
    0x30b0,  /* katakana gu           */
    0x30b1,  /* katakana ke           */
    0x30b2,  /* katakana ge           */
    0x30b3,  /* katakana ko           */
    0x30b4,  /* katakana go           */

    0x30b5,  /* katakana sa           */
    0x30b6,  /* katakana za           */
    0x30b7,  /* katakana si           */
    0x30b8,  /* katakana zi           */
    0x30b9,  /* katakana su           */
    0x30ba,  /* katakana zu           */
    0x30bb,  /* katakana se           */
    0x30bc,  /* katakana ze           */
    0x30bd,  /* katakana so           */
    0x30be,  /* katakana zo           */

    0x30bf,  /* katakana ta           */
    0x30c0,  /* katakana da           */
    0x30c1,  /* katakana ti           */
    0x30c2,  /* katakana di           */
    0x30c3,  /* katakana small tu     */
    0x30c4,  /* katakana tu           */
    0x30c5,  /* katakana du           */
    0x30c6,  /* katakana te           */
    0x30c7,  /* katakana de           */
    0x30c8,  /* katakana to           */
    0x30c9,  /* katakana do           */

    0x30ca,  /* katakana na           */
    0x30cb,  /* katakana ni           */
    0x30cc,  /* katakana nu           */
    0x30cd,  /* katakana ne           */
    0x30ce,  /* katakana no           */

    0x30cf,  /* katakana ha           */
    0x30d0,  /* katakana ba           */
    0x30d1,  /* katakana pa           */
    0x30d2,  /* katakana hi           */
    0x30d3,  /* katakana bi           */
    0x30d4,  /* katakana pi           */
    0x30d5,  /* katakana hu           */
    0x30d6,  /* katakana bu           */
    0x30d7,  /* katakana pu           */
    0x30d8,  /* katakana he           */
    0x30d9,  /* katakana be           */
    0x30da,  /* katakana pe           */
    0x30db,  /* katakana ho           */
    0x30dc,  /* katakana bo           */
    0x30dd,  /* katakana po           */

    0x30de,  /* katakana ma           */
    0x30df,  /* katakana mi           */
    0x30e0,  /* katakana mu           */
    0x30e1,  /* katakana me           */
    0x30e2,  /* katakana mo           */

    0x30e3,  /* katakana small ya     */
    0x30e4,  /* katakana ya           */
    0x30e5,  /* katakana small yu     */
    0x30e6,  /* katakana yu           */
    0x30e7,  /* katakana small yo     */
    0x30e8,  /* katakana yo           */

    0x30e9,  /* katakana ra           */
    0x30ea,  /* katakana ri           */
    0x30eb,  /* katakana ru           */
    0x30ec,  /* katakana re           */
    0x30ed,  /* katakana ro           */

    0x30ee,  /* katakana small wa     */
    0x30ef,  /* katakana wa           */
    0x30f0,  /* katakana wi           */
    0x30f1,  /* katakana we           */
    0x30f2,  /* katakana wo           */

    0x30f3,  /* katakana n            */

    0x30f4,  /* katakana vu           */
    0x30f5,  /* katakana small ka     */
    0x30f6,  /* katakana small ke     */
    0x30f7,  /* katakana va           */
    0x30f8,  /* katakana vi           */
    0x30f9,  /* katakana ve           */
    0x30fa,  /* katakana vo           */

    0x30fb,  /* katakana middle dot   */
    0x30fc,  /* katakana prolonged sound mark  */
    0x30fd,  /* katakana iteration mark        */
    0x30fe,  /* katakana voiced iteration mark */
    0
};

static const gunichar hiragana[] = {
    0x3041,  /* hiragana small a      */
    0x3042,  /* hiragana a            */
    0x3043,  /* hiragana small i      */
    0x3044,  /* hiragana i            */
    0x3045,  /* hiragana small u      */
    0x3046,  /* hiragana u            */
    0x3047,  /* hiragana small e      */
    0x3048,  /* hiragana e            */
    0x3049,  /* hiragana small o      */
    0x304a,  /* hiragana o            */

    0x304b,  /* hiragana ka           */
    0x304c,  /* hiragana ga           */
    0x304d,  /* hiragana ki           */
    0x304e,  /* hiragana gi           */
    0x304f,  /* hiragana ku           */
    0x3050,  /* hiragana gu           */
    0x3051,  /* hiragana ke           */
    0x3052,  /* hiragana ge           */
    0x3053,  /* hiragana ko           */
    0x3054,  /* hiragana go           */

    0x3055,  /* hiragana sa           */
    0x3056,  /* hiragana za           */
    0x3057,  /* hiragana si           */
    0x3058,  /* hiragana zi           */
    0x3059,  /* hiragana su           */
    0x305a,  /* hiragana zu           */
    0x305b,  /* hiragana se           */
    0x305c,  /* hiragana ze           */
    0x305d,  /* hiragana so           */
    0x305e,  /* hiragana zo           */

    0x305f,  /* hiragana ta           */
    0x3060,  /* hiragana da           */
    0x3061,  /* hiragana ti           */
    0x3062,  /* hiragana di           */
    0x3063,  /* hiragana small tu     */
    0x3064,  /* hiragana tu           */
    0x3065,  /* hiragana du           */
    0x3066,  /* hiragana te           */
    0x3067,  /* hiragana de           */
    0x3068,  /* hiragana to           */
    0x3069,  /* hiragana do           */

    0x306a,  /* hiragana na           */
    0x306b,  /* hiragana ni           */
    0x306c,  /* hiragana nu           */
    0x306d,  /* hiragana ne           */
    0x306e,  /* hiragana no           */

    0x306f,  /* hiragana ha           */
    0x3070,  /* hiragana ba           */
    0x3071,  /* hiragana pa           */
    0x3072,  /* hiragana hi           */
    0x3073,  /* hiragana bi           */
    0x3074,  /* hiragana pi           */
    0x3075,  /* hiragana hu           */
    0x3076,  /* hiragana bu           */
    0x3077,  /* hiragana pu           */
    0x3078,  /* hiragana he           */
    0x3079,  /* hiragana be           */
    0x307a,  /* hiragana pe           */
    0x307b,  /* hiragana ho           */
    0x307c,  /* hiragana bo           */
    0x307d,  /* hiragana po           */

    0x307e,  /* hiragana ma           */
    0x307f,  /* hiragana mi           */
    0x3070,  /* hiragana mu           */
    0x3081,  /* hiragana me           */
    0x3082,  /* hiragana mo           */

    0x3083,  /* hiragana small ya     */
    0x3084,  /* hiragana ya           */
    0x3085,  /* hiragana small yu     */
    0x3086,  /* hiragana yu           */
    0x3087,  /* hiragana small yo     */
    0x3088,  /* hiragana yo           */

    0x3089,  /* hiragana ra           */
    0x308a,  /* hiragana ri           */
    0x308b,  /* hiragana ru           */
    0x308c,  /* hiragana re           */
    0x308d,  /* hiragana ro           */

    0x308e,  /* hiragana small wa     */
    0x308f,  /* hiragana wa           */
    0x3090,  /* hiragana wi           */
    0x3091,  /* hiragana we           */
    0x3092,  /* hiragana wo           */

    0x3093,  /* hiragana n            */

    0x3094,  /* hiragana vu           */
    0x3095,  /* hiragana small ka     */
    0x3096,  /* hiragana small ke     */

    0x3099,  /* combining voiced sound mark          */
    0x309a,  /* combining semi-voiced sound mark     */
    0x309b,  /* voiced sound mark                    */
    0x309c,  /* semi-voiced sound mark               */

    0x309d,  /* hiragana iteration mark        */
    0x309e,  /* hiragana voiced iteration mark */
    0
};

static const gunichar shapes[] = {
    0x25a0,  /* black square                                                 */
    0x25a1,  /* white square                                                 */
    0x25a2,  /* white square with rounded corners                            */
    0x25a3,  /* white square containing black small square                   */
    0x25a4,  /* square with horizontal fill                                  */
    0x25a5,  /* square with vertical fill                                    */
    0x25a6,  /* square with orthogonal crosshatch fill                       */
    0x25a7,  /* square with upper left to lower right fill                   */
    0x25a8,  /* square with upper right to lower left fill                   */
    0x25a9,  /* square with diagonal crosshatch fill                         */
    0x25aa,  /* black small square                                           */
    0x25ab,  /* white small square                                           */
    0x25ac,  /* black rectangle                                              */
    0x25ad,  /* white rectangle                                              */
    0x25ae,  /* black vertical rectangle                                     */
    0x25af,  /* white vertical rectangle                                     */
    0x25b0,  /* black parallelogram                                          */
    0x25b1,  /* white parallelogram                                          */
    0x25b2,  /* black up-pointing triangle                                   */
    0x25b3,  /* white up-pointing triangle                                   */
    0x25b4,  /* black up-pointing small triangle                             */
    0x25b5,  /* white up-pointing small triangle                             */
    0x25b6,  /* black right-pointing triangle                                */
    0x25b7,  /* white right-pointing triangle                                */
    0x25b8,  /* black right-pointing small triangle                          */
    0x25b9,  /* white right-pointing small triangle                          */
    0x25ba,  /* black right-pointing pointer                                 */
    0x25bb,  /* white right-pointing pointer                                 */
    0x25bc,  /* black down-pointing triangle                                 */
    0x25bd,  /* white down-pointing triangle                                 */
    0x25be,  /* black down-pointing small triangle                           */
    0x25bf,  /* white down-pointing small triangle                           */
    0x25c0,  /* black left-pointing triangle                                 */
    0x25c1,  /* white left-pointing triangle                                 */
    0x25c2,  /* black left-pointing small triangle                           */
    0x25c3,  /* white left-pointing small triangle                           */
    0x25c4,  /* black left-pointing pointer                                  */
    0x25c5,  /* white left-pointing pointer                                  */
    0x25c6,  /* black diamond                                                */
    0x25c7,  /* white diamond                                                */
    0x25c8,  /* white diamond containing black small diamond                 */
    0x25c9,  /* fisheye                                                      */
    0x25ca,  /* lozenge                                                      */
    0x25cb,  /* white circle                                                 */
    0x25cc,  /* dotted circle                                                */
    0x25cd,  /* circle with vertical fill                                    */
    0x25ce,  /* bullseye                                                     */
    0x25cf,  /* black circle                                                 */
    0x25d0,  /* circle with left half black                                  */
    0x25d1,  /* circle with right half black                                 */
    0x25d2,  /* circle with lower half black                                 */
    0x25d3,  /* circle with upper half black                                 */
    0x25d4,  /* circle with upper right quadrant black                       */
    0x25d5,  /* circle with all but upper left quadrant black                */
    0x25d6,  /* left half black circle                                       */
    0x25d7,  /* right half black circle                                      */
    0x25d8,  /* inverse bullet                                               */
    0x25d9,  /* inverse white circle                                         */
    0x25da,  /* upper half inverse white circle                              */
    0x25db,  /* lower half inverse white circle                              */
    0x25dc,  /* upper left quadrant circular arc                             */
    0x25dd,  /* upper right quadrant circular arc                            */
    0x25de,  /* lower right quadrant circular arc                            */
    0x25df,  /* lower left quadrant circular arc                             */
    0x25e0,  /* upper half circle                                            */
    0x25e1,  /* lower half circle                                            */
    0x25e2,  /* black lower right triangle                                   */
    0x25e3,  /* black lower left triangle                                    */
    0x25e4,  /* black upper left triangle                                    */
    0x25e5,  /* black upper right triangle                                   */
    0x25e6,  /* white bullet                                                 */
    0x25e7,  /* square with left half black                                  */
    0x25e8,  /* square with right half black                                 */
    0x25e9,  /* square with upper left diagonal half black                   */
    0x25ea,  /* square with lower right diagonal half black                  */
    0x25eb,  /* white square with vertical bisecting line                    */
    0x25ec,  /* white up-pointing triangle with dot                          */
    0x25ed,  /* up-pointing triangle with left half black                    */
    0x25ee,  /* up-pointing triangle with right half black                   */
    0x25ef,  /* large circle                                                 */
    0x25f0,  /* white square with upper left quadrant                        */
    0x25f1,  /* white square with lower left quadrant                        */
    0x25f2,  /* white square with lower right quadrant                       */
    0x25f3,  /* white square with upper right quadrant                       */
    0x25f4,  /* white circle with upper left quadrant                        */
    0x25f5,  /* white circle with lower left quadrant                        */
    0x25f6,  /* white circle with lower right quadrant                       */
    0x25f7,  /* white circle with upper right quadrant                       */
    0x25f8,  /* upper left triangle                                          */
    0x25f9,  /* upper right triangle                                         */
    0x25fa,  /* lower left triangle                                          */
    0x25fb,  /* white medium square                                          */
    0x25fc,  /* black medium square                                          */
    0x25fd,  /* white medium small square                                    */
    0x25fe,  /* black medium small square                                    */
    0x25ff,  /* lower right triangle                                         */
    0
};

struct table_item {
    char* name;
    const gunichar* list;
};

static const struct table_item char_table[] = {
    { "\353\254\270\354\236\245\353\266\200\355\230\270", punctuation   },
    { "\352\270\200\354\236\220\352\270\260\355\230\270", char_symbol   },
    { "\354\210\253\354\236\220\352\270\260\355\230\270", number_form   },
    { "\352\264\204\355\230\270\352\270\200\354\236\220", parenthesized },
    { "\354\233\220\352\270\200\354\236\220",             circled       },
    { "\354\210\230\355\225\231\352\270\260\355\230\270 1", math1       },
    { "\354\210\230\355\225\231\352\270\260\355\230\270 2", math2       },
    { "\355\225\234\352\270\200\353\202\261\354\236\220", hangul_cjamo  },
    { "\352\267\270\353\246\254\354\212\244\353\254\270\354\236\220", greek  },
    { "\352\260\200\355\203\200\352\260\200\353\202\230", katakana      },
    { "\355\236\210\353\235\274\352\260\200\353\202\230", hiragana      },
    { "\354\235\274\353\260\230\352\270\260\355\230\270", symbols       },
    { "\353\252\250\354\226\221\352\270\200\354\236\220", shapes        },
    { NULL,						  NULL	        }
};
 
/* vim: set sw=4 : */
