<?php
/**
 * $Horde: imp/lib/prefs.php,v 1.3.10.5 2005/08/13 17:15:55 slusarz Exp $
 *
 * Copyright 1999-2005 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2005 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

function handle_sentmailselect($updated)
{
    global $conf, $imp, $prefs, $identity;

    if ($conf['user']['allow_folders'] &&
        !$prefs->isLocked('sent_mail_folder')) {
        $sent_mail_folder = Util::getFormData('sent_mail');
        $sent_mail_new = String::convertCharset(Util::getFormData('sent_mail_new'), NLS::getCharset(), 'UTF7-IMAP');
        $sent_mail_default = $prefs->getValue('sent_mail_folder');
        if (empty($sent_mail_folder) && !empty($sent_mail_new)) {
            $sent_mail_folder = $sent_mail_new;
        } elseif (($sent_mail_folder == '-1') && !empty($sent_mail_default)) {
            $sent_mail_folder = $sent_mail_default;
        }
        $sent_mail_folder = IMP::stripPreambleString($sent_mail_folder);
        if (!empty($sent_mail_folder)) {
            include_once IMP_BASE . '/lib/Folder.php';
            $imp_folder = &IMP_Folder::singleton();
            if (!$imp_folder->exists(IMP::addPreambleString($sent_mail_folder))) {
                $imp_folder->create(IMP::addPreambleString($sent_mail_folder), $prefs->getValue('subscribe'));
            }
        }
        $identity->setValue('sent_mail_folder', $sent_mail_folder);
        $updated = true;
    }

    return $updated;
}

function handlefolders($updated, $pref, $folder, $new)
{
    global $conf, $imp, $prefs;

    if ($conf['user']['allow_folders']) {
        $folder = Util::getFormData($folder);
        $new = String::convertCharset(Util::getFormData($new), NLS::getCharset(), 'UTF7-IMAP');
        if (isset($folder) && !$prefs->isLocked($pref)) {
            if (empty($folder) && !empty($new)) {
                $folder = $new;
                include_once IMP_BASE . '/lib/Folder.php';
                $imp_folder = &IMP_Folder::singleton();
                if (!$imp_folder->create(IMP::addPreambleString($folder), $prefs->getValue('subscribe'))) {
                    $folder = null;
                }
            } else {
                $folder = IMP::stripPreambleString($folder);
            }
            if (!empty($folder)) {
                $prefs->setValue($pref, $folder);
                $updated = true;
            }
        }
    }

    return $updated;
}

function handle_folderselect($updated)
{
    return $updated | handlefolders($updated, 'drafts_folder', 'drafts', 'drafts_new');
}

function handle_trashselect($updated)
{
    return $updated | handlefolders($updated, 'trash_folder', 'trash', 'trash_new');
}

function handle_sourceselect($updated)
{
    global $prefs;

    $search_sources = Util::getFormData('search_sources');
    if (!is_null($search_sources)) {
        $prefs->setValue('search_sources', $search_sources);
        $updated = true;
    }

    $search_fields_string = Util::getFormData('search_fields_string');
    if (!is_null($search_fields_string)) {
        $prefs->setValue('search_fields', $search_fields_string);
        $updated = true;
    }

    $add_source = Util::getFormData('add_source');
    if (!is_null($add_source)) {
        $prefs->setValue('add_source', $add_source);
        $updated = true;
    }

    return $updated;
}

function handle_initialpageselect($updated)
{
    $initial_page = Util::getFormData('initial_page');
    if ($initial_page != 'folders.php' &&
        substr($initial_page, 0, strlen(IMP::preambleString())) == IMP::preambleString()) {
        $initial_page = substr($initial_page, strlen(IMP::preambleString()));
    }
    $GLOBALS['prefs']->setValue('initial_page', $initial_page);
    return true;
}

function handle_encryptselect($updated)
{
    $default_encrypt = Util::getFormData('default_encrypt');
    $GLOBALS['prefs']->setValue('default_encrypt', $default_encrypt);
    return true;
}

function handle_spamselect($updated)
{
    return $updated | handlefolders($updated, 'spam_folder', 'spam', 'spam_new');
}

function prefs_callback()
{
    if ($GLOBALS['prefs']->isDirty('subscribe')) {
        unset($GLOBALS['imp']['imptree']);
    }
}

require_once IMP_BASE . '/lib/Maintenance/imp.php';
$maint = &new Maintenance_IMP();
foreach (($maint->exportIntervalPrefs()) as $val) {
    $$val = &$intervals;
}

/* Make sure we have an active IMAP stream. */
$GLOBALS['registry']->call('mail/getStream');
