/*
 * indicator-network - user interface for connman
 * Copyright 2010 Canonical Ltd.
 *
 * Authors:
 * Kalle Valo <kalle.valo@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _INDIDICATOR_CONNMAN_H_
#define _INDIDICATOR_CONNMAN_H_

#define CONNMAN_SERVICE			"org.moblin.connman"
#define CONNMAN_PATH			"/org/moblin/connman"

#define CONNMAN_DEBUG_INTERFACE		CONNMAN_SERVICE ".Debug"
#define CONNMAN_ERROR_INTERFACE		CONNMAN_SERVICE ".Error"
#define CONNMAN_AGENT_INTERFACE		CONNMAN_SERVICE ".Agent"
#define CONNMAN_COUNTER_INTERFACE	CONNMAN_SERVICE ".Counter"

#define CONNMAN_MANAGER_INTERFACE	CONNMAN_SERVICE ".Manager"
#define CONNMAN_MANAGER_PATH		"/"

#define CONNMAN_TASK_INTERFACE		CONNMAN_SERVICE ".Task"
#define CONNMAN_PROFILE_INTERFACE	CONNMAN_SERVICE ".Profile"
#define CONNMAN_SERVICE_INTERFACE	CONNMAN_SERVICE ".Service"
#define CONNMAN_DEVICE_INTERFACE	CONNMAN_SERVICE ".Device"
#define CONNMAN_NETWORK_INTERFACE	CONNMAN_SERVICE ".Network"
#define CONNMAN_PROVIDER_INTERFACE	CONNMAN_SERVICE ".Provider"
#define CONNMAN_TECHNOLOGY_INTERFACE	CONNMAN_SERVICE ".Technology"

#define CONNMAN_SIGNAL_PROPERTY_CHANGED	"PropertyChanged"

#define CONNMAN_TECHNOLOGY_ETHERNET	"ethernet"
#define CONNMAN_TECHNOLOGY_WIFI		"wifi"
#define CONNMAN_TECHNOLOGY_CELLULAR	"cellular"
#define CONNMAN_TECHNOLOGY_BLUETOOTH	"bluetooth"

#define CONNMAN_PROPERTY_PASSPHRASE		"Passphrase"
#define CONNMAN_PROPERTY_DEFAULT_TECHNOLOGY	"DefaultTechnology"
#define CONNMAN_PROPERTY_ENABLED_TECHNOLOGIES	"EnabledTechnologies"
#define CONNMAN_PROPERTY_SERVICES		"Services"
#define CONNMAN_PROPERTY_NAME			"Name"
#define CONNMAN_PROPERTY_TYPE			"Type"
#define CONNMAN_PROPERTY_STATE			"State"
#define CONNMAN_PROPERTY_STRENGTH		"Strength"
#define CONNMAN_PROPERTY_SETUP_REQUIRED		"SetupRequired"
#define CONNMAN_PROPERTY_SECURITY		"Security"
#define CONNMAN_PROPERTY_ERROR			"Error"

#define CONNMAN_STATE_ONLINE			"online"
#define CONNMAN_STATE_CONNECTING		"connecting"
#define CONNMAN_STATE_OFFLINE			"offline"

#define CONNMAN_SECURITY_NONE			"none"
#define CONNMAN_SECURITY_WEP			"wep"
#define CONNMAN_SECURITY_PSK			"psk"
#define CONNMAN_SECURITY_WPA			"wpa"
#define CONNMAN_SECURITY_RSN			"rsn"
#define CONNMAN_SECURITY_IEEE8021X		"ieee8021x"

#endif
