/*
 * indicator-network - user interface for connman
 * Copyright 2010 Canonical Ltd.
 *
 * Authors:
 * Kalle Valo <kalle.valo@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _NETWORK_MENU_H_
#define _NETWORK_MENU_H_

#include "indicator-network-service.h"

struct network_menu;

struct network_menu *network_menu_new(struct network_service *ns);
void network_menu_free(struct network_menu *self);
void network_menu_update_wifi_state(struct network_menu *self,
				    gboolean state);
void network_menu_update_wired_state(struct network_menu *self,
				     gboolean state);
void network_menu_update_cellular_state(struct network_menu *self,
					gboolean state);
void network_menu_enabled(struct network_menu *self);
void network_menu_disabled(struct network_menu *self);
gboolean network_menu_is_disabled(struct network_menu *self);
void network_menu_services_updated(struct network_menu *self);
void network_menu_update_state(struct network_menu *self);

#endif
