/*
 * indicator-network - user interface for connman
 * Copyright 2010 Canonical Ltd.
 *
 * Authors:
 * Kalle Valo <kalle.valo@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __PIN_DIALOG_H__
#define __PIN_DIALOG_H__

#include <glib-object.h>
#include <gtk/gtk.h>

#define PIN_DIALOG_TYPE (pin_dialog_get_type())
#define PIN_DIALOG(o) (G_TYPE_CHECK_INSTANCE_CAST ((o),			\
						   PIN_DIALOG_TYPE,	\
						   PinDialog))
#define PIN_DIALOG_CLASS(k) (G_TYPE_CHECK_CLASS_CAST((k),		\
						     PIN_DIALOG_TYPE,	\
						     PinDialogClass))
#define IS_PIN_DIALOG(o) (G_TYPE_CHECK_INSTANCE_TYPE((o),		\
						     PIN_DIALOG_TYPE))
#define IS_PIN_DIALOG_CLASS(k) (G_TYPE_CHECK_CLASS_TYPE((k), \
							PIN_DIALOG_TYPE))
#define PIN_DIALOG_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS((o),		\
							   PIN_DIALOG_TYPE, \
							   PinDialogClass))

typedef struct _PinDialog PinDialog;
typedef struct _PinDialogClass PinDialogClass;

struct _PinDialog
{
  /* GObject parent; */
  GtkDialog parent;
};

struct _PinDialogClass
{
  /* GObjectClass parent_class; */
  GtkDialogClass parent_class;
};

GType pin_dialog_get_type(void) G_GNUC_CONST;

PinDialog *pin_dialog_new(void);

#endif
