/*
 * indicator-network - user interface for connman
 * Copyright 2010 Canonical Ltd.
 *
 * Authors:
 * Kalle Valo <kalle.valo@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _SERVICE_H_
#define _SERVICE_H_

#include <glib.h>

#include <libdbusmenu-glib/menuitem.h>

#include "indicator-network-service.h"

typedef enum {
  SERVICE_STATE_UNKNOWN,
  SERVICE_STATE_IDLE,
  SERVICE_STATE_FAILURE,
  SERVICE_STATE_ASSOCIATION,
  SERVICE_STATE_CONFIGURATION,
  SERVICE_STATE_READY,
  SERVICE_STATE_LOGIN,
  SERVICE_STATE_ONLINE,
  SERVICE_STATE_DISCONNECT,
} ServiceState;

struct service
{
  gchar *path;
  gchar *name;
  gchar *type;
  struct network_service *network_service;
  DbusmenuMenuitem *menuitem;
  DBusGProxy *proxy;
  ServiceState state;
  gint signal_strength;
  gchar *error;
  gchar *security;
};

struct service *service_new(struct network_service *self, const gchar *path);
void service_free(struct service *service);

#endif
