/*
 * indicator-network - user interface for connman
 * Copyright 2010 Canonical Ltd.
 *
 * Authors:
 * Kalle Valo <kalle.valo@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _SERVICES_H_
#define _SERVICES_H_

#include <glib.h>

#include "indicator-network-service.h"

struct services;

struct services *services_new(struct network_service *ns);
void services_free(struct services *self);
void services_update(struct services *self, GValue *value);
void services_remove_all(struct services *self);
GList *services_get_wired(struct services *self);
GList *services_get_wireless(struct services *self);
GList *services_get_cellular(struct services *self);
gboolean services_is_connecting(struct services *self);
gboolean services_is_connected(struct services *self);
guint services_get_connected(struct services *self);
const gchar *services_get_default_technology(struct services *self);

#endif
