/*
 * indicator-network - user interface for connman
 * Copyright 2010-2011 Canonical Ltd.
 *
 * Authors:
 * Andrew Higginson
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

public abstract class Device : GLib.Object {

    public DeviceType type_ { get; protected set; }
    public DeviceState state { get; protected set; }

    protected Connman.Manager connman;

    protected DeviceState convert_state(Connman.TechnologyState state) {

        switch (state) {
        case Connman.TechnologyState.CONNECTED:
            return DeviceState.CONNECTED;
        case Connman.TechnologyState.ENABLED:
            return DeviceState.ONLINE;
        case Connman.TechnologyState.OFFLINE:
            return DeviceState.OFFLINE;
        case Connman.TechnologyState.AVAILABLE:
        default:
            return DeviceState.OFF;
        }
    }

    protected void update_state(Connman.TechnologyState state) {
        this.state = convert_state(state);
    }
}

public class WifiDevice : Device {

    public WifiDevice(Connman.Manager connman) {
        this.type_ = DeviceType.WIRELESS;
        this.connman = connman;

        this.connman.notify["wifi-state"].connect((s, p) => {
                update_state(this.connman.get_wifi_state());
            });

        update_state(this.connman.get_wifi_state());
    }
}

public class EthernetDevice : Device {

    public EthernetDevice(Connman.Manager connman) {
        this.type_ = DeviceType.WIRED;
        this.connman = connman;

        this.connman.notify["ethernet-state"].connect((s, p) => {
                update_state(this.connman.get_ethernet_state());
            });

        update_state(this.connman.get_ethernet_state());
    }
}

public class CellularDevice : Device {

    public CellularDevice(Connman.Manager connman) {
        this.type_ = DeviceType.MOBILE;
        this.connman = connman;

        this.connman.notify["cellular-state"].connect((s, p) => {
                update_state(this.connman.get_cellular_state());
            });

        update_state(this.connman.get_cellular_state());
    }
}

public class BluetoothDevice : Device {

    public BluetoothDevice(Connman.Manager connman) {
        this.type_ = DeviceType.BLUETOOTH;
        this.connman = connman;

        this.connman.notify["bluetooth-state"].connect((s, p) => {
                update_state(this.connman.get_bluetooth_state());
            });

        update_state(this.connman.get_bluetooth_state());
    }
}

public class FlightModeDevice : Device {

    public FlightModeDevice(Connman.Manager connman) {
        this.type_ = DeviceType.FLIGHTMODE;
        this.connman = connman;

        this.connman.notify["offline-mode"].connect((s, p) => {
                update_mode(this.connman.offline_mode);
            });

        update_mode(this.connman.offline_mode);
    }

    private void update_mode(bool mode) {

        if (mode)
            this.state = DeviceState.OFFLINE;
        else
            this.state = DeviceState.ONLINE;
    }
}
