/*
 * Copyright (C) 2014 Canonical, Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *     Antti Kaijanmäki <antti.kaijanmaki@canonical.com>
 */

#ifndef CONNECTIVITY_SERVICE_H
#define CONNECTIVITY_SERVICE_H

#include <connectivity/networking/manager.h>
#include<core/signal.h>

class ConnectivityService
{
public:
    ConnectivityService(std::shared_ptr<connectivity::networking::Manager> manager);
    virtual ~ConnectivityService();

    core::Signal<> &unlockAllModems();

private:
    class Private;
    std::unique_ptr<Private> d;
};

#endif
