#!/usr/bin/env python

#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

#  EvolutionContactsScreenlet (c) Whise 2007 

import screenlets
from screenlets import utils
from screenlets.options import StringOption , BoolOption , IntOption , FontOption, ColorOption
from screenlets import DefaultMenuItem
import pango
import gobject
import gtk
import os
from xml.dom.minidom import parse
from xml.parsers.expat import ExpatError
import re
import gnomevfs
from screenlets import Plugins
Evolution = Plugins.importAPI('Evolution')
#use gettext for translation
import gettext

_ = screenlets.utils.get_translator(__file__)

def tdoc(obj):
	obj.__doc__ = _(obj.__doc__)
	return obj

@tdoc
class EvolutionContactsScreenlet (screenlets.Screenlet):
	"""Displays Evolution contacts"""
	
	# default meta-info for Screenlets (should be removed and put into metainfo)
	__name__	= 'EvolutionContactsScreenlet'
	__version__	= '0.1.2'
	__author__	= 'Helder Fraga aka Whise'
	__desc__	= __doc__	# set description to docstring of class

	# editable options (options that are editable through the UI)
	color_odd = (0, 0, 0, 0.55)
	color_even = (0, 0, 0, 0.65)
	color_title = (0.0, 0.0, 0.0, 1)
	color_text = (1,1,1,1)
	color_back = (1.0, 1.0, 1.0, 0.65)
	color_hover = (0, 0, 1.0, 0.65)
	font = "FreeSans"
	font_title = "FreeSans"
	show_shadow = True
	expanded = True
	hover = False
	number = 0
	__timeout = None

	mouse_is_over = False
	places = []
	old_places = []
	selected = 0
	mousesel = 0
	contacts = None


	# constructor
	def __init__ (self, **keyword_args):
		#call super (width/height MUST match the size of graphics in the theme)
		screenlets.Screenlet.__init__(self, width=200, height=200, 
			uses_theme=True,ask_on_option_override = False,  **keyword_args)
		# set theme
		self.theme_name = "yellow"
		# add option group
		self.add_options_group(_('Options'), _('Options'))
		# add editable option to the group

		self.add_option(FontOption(_('Options'),'font_title', 
			self.font_title, _('Title Font'), 
			''))

		self.add_option(ColorOption(_('Options'),'color_title', 
			self.color_title, _('Title Color'), 
			''))

		self.add_option(ColorOption(_('Options'),'color_back', 
			self.color_back, _('Title Background Color'), 
			''))

		self.add_option(FontOption(_('Options'),'font', 
			self.font, _('Text Font'), 
			''))

		self.add_option(ColorOption(_('Options'),'color_text', 
			self.color_text, _('Text Color'), 
			''))

		self.add_option(ColorOption(_('Options'),'color_even', 
			self.color_even, _('Even Color'), 
			''))

		self.add_option(ColorOption(_('Options'),'color_odd', 
			self.color_odd, _('Odd Color'), 
			''))

		self.add_option(ColorOption(_('Options'),'color_hover', 
			self.color_hover, _('Hover Color'), 
			''))

		self.add_option(BoolOption(_('Options'),'show_shadow', 
			self.show_shadow, _('Show Shadow'), '',))

		self.add_option(BoolOption(_('Options'),'expanded', 
			self.expanded, _('Expanded'), '',hidden=True))

		# ADD a 1 second (1000) TIMER

		self.ask_on_option_override = False
		
		#fstab = self.readFile('/etc/fstab')
		#mounts = self.readFile('/proc/mounts')
		
		self.contacts = {}
		self.__timeout = gobject.timeout_add(int(60000), self.update)
		self.update()

	def update(self):
		self.contacts = Evolution.get_evolution_contacts()
		self.redraw_canvas()
		return True

	def menuitem_callback(self, widget, id):
		screenlets.Screenlet.menuitem_callback(self, widget, id)
		if id=="new":
			os.system("evolution &")

	def __setattr__(self, name, value):
		# call Screenlet.__setattr__ in baseclass (ESSENTIAL!!!!)
		screenlets.Screenlet.__setattr__(self, name, value)
		if name == 'contacts':
			if self.height != 20 + (len(self.contacts)*20) +20:
				self.height = 20 + (len(self.contacts)*20) +20		
				self.redraw_canvas()
	
	def on_init (self):
		"""Called when the Screenlet's options have been applied and the 
		screenlet finished its initialization. If you want to have your
		Screenlet do things on startup you should use this handler."""
		self.add_menuitem("new", _("Open Evolution"))		
		# add default menu items
		self.add_default_menuitems()
		if self.contacts != None:
			if self.height != 20 + (len(self.contacts)*20) +20:
				self.height = 20 + (len(self.contacts)*20) +20		
				self.redraw_canvas()
		#print utils.LoadBookmarks()
	
	def on_mouse_down (self, event):
		"""Called when a buttonpress-event occured in Screenlet's window. 
		Returning True causes the event to be not further propagated."""
		x = event.x / self.scale
		y = event.y / self.scale
		if event.button == 1:
			if event.type == gtk.gdk._2BUTTON_PRESS and y < 30: 
				self.expanded = not self.expanded
			if y > (30) and self.contacts != None:
				click = int((y -10 )/ (20)) -1
				a = 0
				for note in self.contacts:
					if click == a:	
						os.system("evolution mailto:%s &" % self.contacts[a].get_property('full-name'))
					a = a+1				
		return False
	
	def on_mouse_leave (self, event):
		"""Called when the mouse leaves the Screenlet's window."""
		self.redraw_canvas()

	def on_mouse_move(self, event):
		"""Called when the mouse moves in the Screenlet's window."""
		x = event.x / self.scale
		y = event.y / self.scale
		if y > (30):
			self.__dict__['mousesel'] = int((y -10 )/ (20)) -1
			if self.selected != self.mousesel or y > 20 + (len(self.contacts)*20) +20:				
				self.redraw_canvas()
	
	def on_draw (self, ctx):
		"""In here we draw"""
		ctx.scale(self.scale, self.scale)
		y = 0

		if self.expanded:
			if self.show_shadow:self.draw_shadow(ctx, 0, 0, self.width-12, self.height-5,6,[0,0,0,0.3])	
		else:
			if self.show_shadow:self.draw_shadow(ctx, 0, 0, self.width-12,40-5,6,[0,0,0,0.3])	
		ctx.translate(10,10)
		ctx.set_source_rgba(self.color_back[0],self.color_back[1],self.color_back[2],self.color_back[3])
		self.draw_rounded_rectangle(ctx,0,y,5,self.width-20,20,round_bottom_right= False,round_bottom_left= False)
		ctx.set_source_rgba(self.color_title[0],self.color_title[1],self.color_title[2],self.color_title[3])
		self.draw_text(ctx, _('Contacts'),14,y+2,self.font_title.split(' ')[0],10,self.width-20,pango.ALIGN_LEFT)
		if self.expanded:
			ctx.rotate(3.14)
			self.draw_triangle(ctx,-15,-(y+17),10,10)
			ctx.rotate(-3.14)
			
		else:
			ctx.rotate(3.14/2)
			self.draw_triangle(ctx,3,-(y+15),10,10)
			ctx.rotate(-3.14/2)
		ctx.translate(0,20)			
		if self.expanded and self.contacts != None:
			x = 0
			
			
			for app  in self.contacts:
				if x % 2:
					ctx.set_source_rgba(self.color_even[0],self.color_even[1],self.color_even[2],self.color_even[3])
					#is_mounted = 'Mounted'
				else:
					ctx.set_source_rgba(self.color_odd[0],self.color_odd[1],self.color_odd[2],self.color_odd[3])
				if self.check_for_icon(app):
					ico = 'tomboy'
				else:
					ico = 'stock_search-and-replace'


				if self.mousesel == x and self.mouse_is_over:
					ctx.set_source_rgba(self.color_hover[0],self.color_hover[1],self.color_hover[2],self.color_hover[3])
					self.__dict__['selected'] = x

				if y +60== self.height:
					self.draw_rounded_rectangle(ctx,0,y,5,self.width-20,20,round_top_right= False,round_top_left= False)	
				else:
					self.draw_rectangle(ctx,0,y,self.width -20,20)

				if self.contacts[x].get_property('full-name') is not None:
					ctx.set_source_rgba(self.color_text[0],self.color_text[1],self.color_text[2],self.color_text[3])
					self.draw_text(ctx, self.contacts[x].get_property('full-name'), 5, y+2,
						self.font.split(' ')[0] ,10, self.width-20, pango.ALIGN_LEFT)

				a = self.get_screenlet_dir() + '/themes/' + self.theme_name + '/icon.png'
				self.draw_scaled_image(ctx,self.width-40,y+2,a,16,16)
				x += 1
				y += 20
			
		
			

	def on_draw_shape (self, ctx):
		self.on_draw(ctx)
	
# If the program is run directly or passed as an argument to the python
# interpreter then create a Screenlet instance and show it
if __name__ == "__main__":
	# create new session
	import screenlets.session
	screenlets.session.create_session(EvolutionContactsScreenlet)

